/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.sites;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.web.clientproject.api.network.NetworkException;
import org.netbeans.modules.web.clientproject.sites.Bundle;
import org.netbeans.modules.web.clientproject.util.StringUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;

public final class SiteHelper {
    private static final Logger LOGGER = Logger.getLogger(SiteHelper.class.getName());
    private static final String JS_LIBS_DIR = "jslibs";

    private SiteHelper() {
    }

    public static File getJsLibsDirectory() {
        return Places.getCacheSubdirectory((String)JS_LIBS_DIR);
    }

    public static void download(String url, File target, @NullAllowed ProgressHandle progressHandle) throws NetworkException, IOException {
        InputStream is;
        assert (!EventQueue.isDispatchThread());
        if (progressHandle != null) {
            progressHandle.progress(Bundle.SiteHelper_progress_download(target.getName()));
        }
        try {
            is = new URL(url).openStream();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            throw new NetworkException(url, (Throwable)ex);
        }
        try {
            SiteHelper.copyToFile(is, target);
        }
        catch (IOException ex) {
            if (!target.delete()) {
                // empty if block
            }
            throw ex;
        }
        finally {
            is.close();
        }
    }

    public static void unzipProjectTemplate(@NonNull FileObject targetDir, @NonNull File zipFile, @NullAllowed ProgressHandle progressHandle, String ... ignoredFiles) throws IOException {
        assert (targetDir != null);
        if (progressHandle != null) {
            progressHandle.progress(Bundle.SiteHelper_progress_unzip(zipFile.getName()));
        }
        String rootFolder = SiteHelper.getZipRootFolder(new FileInputStream(zipFile));
        SiteHelper.unzipProjectTemplateFile(targetDir, new FileInputStream(zipFile), rootFolder, ignoredFiles);
    }

    public static List<String> stripRootFolder(List<String> paths) {
        ArrayList<String> stripped = new ArrayList<String>(paths.size());
        String rootFolder = null;
        for (String path : paths) {
            assert (StringUtilities.hasText(path)) : "Empty path not allowed";
            int slashIndex = path.indexOf(47);
            String top = slashIndex == -1 ? path : path.substring(0, slashIndex);
            if (rootFolder == null) {
                rootFolder = top;
            }
            if (!rootFolder.equals(top)) {
                return paths;
            }
            if (slashIndex == -1 || path.length() <= slashIndex) continue;
            stripped.add(path.substring(slashIndex + 1));
        }
        return stripped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipProjectTemplateFile(FileObject targetDir, InputStream source, String rootFolder, String ... ignoredFiles) throws IOException {
        boolean firstItem = true;
        try {
            ZipEntry entry;
            int stripLen = rootFolder != null ? rootFolder.length() : 0;
            ZipInputStream str = new ZipInputStream(source);
            Set ignored = Collections.emptySet();
            if (ignoredFiles != null && ignoredFiles.length > 0) {
                ignored = new HashSet<String>(Arrays.asList(ignoredFiles));
            }
            while ((entry = str.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (stripLen > 0) {
                    entryName = entryName.substring(stripLen);
                }
                if (entryName.length() == 0 || ignored.contains(entryName)) continue;
                firstItem = false;
                if (entry.isDirectory()) {
                    if (entryName.startsWith("build") || entryName.startsWith("nbproject") || targetDir.getFileObject(entryName) != null) continue;
                    FileUtil.createFolder((FileObject)targetDir, (String)entryName);
                    continue;
                }
                if (entryName.startsWith(".git") || entryName.contains("/.git") || entryName.startsWith("build/") || entryName.startsWith("nbproject/") || entryName.contains("/.LCK") && entryName.endsWith("~")) continue;
                FileObject fo = FileUtil.createData((FileObject)targetDir, (String)entryName);
                SiteHelper.writeFile(str, fo);
            }
        }
        finally {
            source.close();
            if (firstItem) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.SiteHelper_error_emptyZip()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(ZipInputStream str, FileObject fo) throws IOException {
        OutputStream out = fo.getOutputStream();
        try {
            FileUtil.copy((InputStream)str, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyToFile(InputStream is, File target) throws IOException {
        FileOutputStream os = new FileOutputStream(target);
        try {
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            ((OutputStream)os).close();
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getZipRootFolder(InputStream source) throws IOException {
        String folder = null;
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            boolean first = true;
            while ((entry = str.getNextEntry()) != null) {
                if (first) {
                    first = false;
                    if (entry.isDirectory()) {
                        folder = entry.getName();
                        continue;
                    }
                    String fileName = entry.getName();
                    int slashIndex = fileName.indexOf(47);
                    if (slashIndex != -1) {
                        String name = fileName.substring(slashIndex + 1);
                        folder = fileName.substring(0, slashIndex);
                        if (name.length() == 0 || folder.length() == 0) {
                            String string = null;
                            return string;
                        }
                    } else {
                        String string = null;
                        return string;
                    }
                    folder = folder + "/";
                    continue;
                }
                if (entry.getName().startsWith(folder)) continue;
                String string = null;
                return string;
            }
        }
        finally {
            source.close();
        }
        return folder;
    }
}

