/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.sites;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.web.clientproject.sites.Bundle;
import org.netbeans.modules.web.clientproject.sites.SiteHelper;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.util.FileUtilities;
import org.openide.filesystems.FileObject;

public abstract class OnlineSites
implements SiteTemplateImplementation {
    private static final Logger LOGGER = Logger.getLogger(OnlineSites.class.getName());
    private final String name;
    private final String url;
    private final File libFile;
    private final String description;
    private final String id;

    protected OnlineSites(String id, String name, String description, String url, File libFile) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.url = url;
        this.libFile = libFile;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPrepared() {
        return this.libFile.isFile();
    }

    public void prepare() throws IOException {
        assert (!EventQueue.isDispatchThread());
        assert (!this.isPrepared());
        SiteHelper.download(this.url, this.libFile, null);
    }

    public void configure(SiteTemplateImplementation.ProjectProperties projectProperties) {
    }

    public final void apply(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, ProgressHandle handle) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (!this.isPrepared()) {
            LOGGER.info("Template not correctly prepared, nothing to be applied");
            return;
        }
        SiteHelper.unzipProjectTemplate(this.getTargetDir(projectDir, projectProperties), this.libFile, handle, new String[0]);
    }

    protected FileObject getTargetDir(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties) {
        return projectDir.getFileObject(projectProperties.getSiteRootFolder());
    }

    public Collection<String> supportedLibraries() {
        return SiteHelper.stripRootFolder(FileUtilities.listJsFilesFromZipFile(this.libFile));
    }

    public static class SiteTwitterBootstrap
    extends OnlineSites {
        public SiteTwitterBootstrap() {
            super("TWITTER", Bundle.SiteTwitterBootstrap_name(), Bundle.SiteTwitterBootstrap_description(), "http://twitter.github.com/bootstrap/assets/bootstrap.zip", new File(SiteHelper.getJsLibsDirectory(), "twitter-bootstrap.zip"));
        }
    }

    public static class SiteHtml5BoilerplateV3
    extends OnlineSites {
        public SiteHtml5BoilerplateV3() {
            super("INIT.BOILER3", Bundle.SiteHtml5Boilerplate_name(), Bundle.SiteHtml5Boilerplate_description(), "https://github.com/h5bp/html5-boilerplate/zipball/v3.0.2", new File(SiteHelper.getJsLibsDirectory(), "html5-boilerplate-302.zip"));
        }
    }

    public static class SiteHtml5BoilerplateV4
    extends OnlineSites {
        public SiteHtml5BoilerplateV4() {
            super("INIT.BOILER4", Bundle.SiteHtml5BoilerplateV4_name(), Bundle.SiteHtml5BoilerplateV4_description(), "https://github.com/h5bp/html5-boilerplate/zipball/v4.0.0", new File(SiteHelper.getJsLibsDirectory(), "html5-boilerplate-400.zip"));
        }
    }

    public static class ResponsiveSiteInitializr
    extends OnlineSites {
        public ResponsiveSiteInitializr() {
            super("INIT.RESP", Bundle.ResponsiveSiteInitializr_name(), Bundle.SiteInitializr_description(), "http://www.initializr.com/builder?izr-responsive&jquerydev&h5bp-iecond&h5bp-chromeframe&h5bp-analytics&h5bp-favicon&h5bp-appletouchicons&modernizrrespond&h5bp-css&h5bp-csshelpers&h5bp-mediaqueryprint&izr-emptyscript", new File(SiteHelper.getJsLibsDirectory(), "initializr-responsive-latest.zip"));
        }
    }

    public static class ClassicSiteInitializr
    extends OnlineSites {
        public ClassicSiteInitializr() {
            super("INIT.CLASSIC", Bundle.ClassicSiteInitializr_name(), Bundle.SiteInitializr_description(), "http://www.initializr.com/builder?h5bp-content&modernizr&jquerydev&h5bp-iecond&h5bp-chromeframe&h5bp-analytics&h5bp-htaccess&h5bp-favicon&h5bp-appletouchicons&h5bp-scripts&h5bp-robots&h5bp-humans&h5bp-404&h5bp-adobecrossdomain&h5bp-css&h5bp-csshelpers&h5bp-mediaqueryprint&h5bp-mediaqueries", new File(SiteHelper.getJsLibsDirectory(), "initializr-classic-latest.zip"));
        }
    }

    public static class BootstrapSiteInitializr
    extends OnlineSites {
        public BootstrapSiteInitializr() {
            super("BOOTSTRAP", Bundle.BootstrapSiteInitializr_name(), Bundle.SiteInitializr_description(), "http://www.initializr.com/builder?boot-hero&jquerydev&h5bp-iecond&h5bp-chromeframe&h5bp-analytics&h5bp-favicon&h5bp-appletouchicons&modernizrrespond&izr-emptyscript&boot-css&boot-scripts", new File(SiteHelper.getJsLibsDirectory(), "initializr-bootstrap-latest.zip"));
        }
    }

    public static class SiteAngularJsSeed
    extends OnlineSites {
        private static final String SITE_ROOT_FOLDER = "app";
        private static final String TEST_FOLDER = "test";
        private static final String CONFIG_FOLDER = "config";

        public SiteAngularJsSeed() {
            super("ANGULAR", Bundle.SiteAngularJsSeed_name(), Bundle.SiteAngularJsSeed_description(), "https://github.com/angular/angular-seed/zipball/master", new File(SiteHelper.getJsLibsDirectory(), "angularjs-seed.zip"));
        }

        @Override
        public void configure(SiteTemplateImplementation.ProjectProperties projectProperties) {
            projectProperties.setSiteRootFolder(SITE_ROOT_FOLDER).setTestFolder(TEST_FOLDER).setConfigFolder(CONFIG_FOLDER);
        }

        @Override
        protected FileObject getTargetDir(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties) {
            return projectDir;
        }
    }
}

