/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.browser.ClientProjectConfigurationImpl;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectConfigurationImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectPlatformImplementation;

public class ClientProjectPlatformImpl
implements ClientProjectPlatformImplementation {
    private Project p;
    private List<ClientProjectConfigurationImpl> configs;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public ClientProjectPlatformImpl(Project p) {
        this.p = p;
        WebBrowsers.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("browsers".equals(evt.getPropertyName())) {
                    ClientProjectPlatformImpl.this.configs = null;
                    ClientProjectPlatformImpl.this.support.firePropertyChange("configurations", null, null);
                }
            }
        });
    }

    public List<? extends ClientProjectConfigurationImplementation> getConfigurations() {
        if (this.configs == null) {
            this.configs = this.getBrowserConfigurations();
        }
        return this.configs;
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.support.addPropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.support.removePropertyChangeListener(lst);
    }

    private List<ClientProjectConfigurationImpl> getBrowserConfigurations() {
        ArrayList<ClientProjectConfigurationImpl> l = new ArrayList<ClientProjectConfigurationImpl>();
        int chrome = 200;
        int chromium = 300;
        int others = 400;
        for (WebBrowser browser : WebBrowsers.getInstance().getAll(false)) {
            if (browser.getBrowserFamily() == BrowserFamilyId.JAVAFX_WEBVIEW) {
                l.add(new ClientProjectConfigurationImpl((ClientSideProject)this.p, browser, this, ClientProjectConfigurationImpl.BrowserIntegration.ENABLED, 100, false));
                continue;
            }
            if (browser.getBrowserFamily() == BrowserFamilyId.CHROME || browser.getId().endsWith("ChromeBrowser")) {
                l.add(new ClientProjectConfigurationImpl((ClientSideProject)this.p, browser, this, ClientProjectConfigurationImpl.BrowserIntegration.ENABLED, chrome++, false));
                l.add(new ClientProjectConfigurationImpl((ClientSideProject)this.p, browser, this, ClientProjectConfigurationImpl.BrowserIntegration.DISABLE, chrome++, true));
                continue;
            }
            if (browser.getBrowserFamily() == BrowserFamilyId.CHROMIUM || browser.getId().endsWith("ChromiumBrowser")) {
                l.add(new ClientProjectConfigurationImpl((ClientSideProject)this.p, browser, this, ClientProjectConfigurationImpl.BrowserIntegration.ENABLED, chromium++, false));
                l.add(new ClientProjectConfigurationImpl((ClientSideProject)this.p, browser, this, ClientProjectConfigurationImpl.BrowserIntegration.DISABLE, chromium++, true));
                continue;
            }
            l.add(new ClientProjectConfigurationImpl((ClientSideProject)this.p, browser, this, null, others++, false));
        }
        Collections.sort(l, new Comparator<ClientProjectConfigurationImpl>(){

            @Override
            public int compare(ClientProjectConfigurationImpl o1, ClientProjectConfigurationImpl o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        return l;
    }

    public List<String> getNewConfigurationTypes() {
        return Collections.emptyList();
    }

    public String createConfiguration(String configurationType, String configurationName) {
        return null;
    }
}

