/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.browser;

import javax.swing.JPanel;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.browser.BrowserActionProvider;
import org.netbeans.modules.web.clientproject.browser.ClientProjectPlatformImpl;
import org.netbeans.modules.web.clientproject.browser.RefreshOnSaveListenerImpl;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectConfigurationImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.netbeans.modules.web.clientproject.spi.platform.RefreshOnSaveListener;
import org.netbeans.modules.web.clientproject.ui.browser.BrowserConfigurationPanel;
import org.netbeans.modules.web.common.spi.ServerURLMappingImplementation;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.NbBundle;

public class ClientProjectConfigurationImpl
implements ClientProjectConfigurationImplementation {
    private final ClientSideProject project;
    private final WebBrowser browser;
    private final ClientProjectPlatformImpl platform;
    private BrowserSupport browserSupport;
    private ProjectConfigurationCustomizerImpl cust = null;
    private ServerURLMappingImplementation mapping;
    private BrowserIntegration browserIntegration;
    private int order;
    private boolean disableIntegration;

    public ClientProjectConfigurationImpl(ClientSideProject project, WebBrowser browser, ClientProjectPlatformImpl platform, BrowserIntegration browserIntegration, int order, boolean disableIntegration) {
        this.project = project;
        this.browser = browser;
        this.platform = platform;
        this.browserIntegration = browserIntegration;
        this.order = order;
        this.disableIntegration = disableIntegration;
    }

    public String getId() {
        return PropertyUtils.getUsablePropertyName((String)(this.browser.getId() + (this.disableIntegration ? ".dis" : "")));
    }

    public String getBrowserId() {
        return this.browser.getId() + (this.disableIntegration ? "" : ".INTEGRATED");
    }

    public void save() {
        if (this.cust != null && this.getBrowserIntegration() == BrowserIntegration.ENABLED) {
            EditableProperties p = this.project.getProjectHelper().getProperties("nbproject/project.properties");
            p.put("browser.autorefresh." + this.getId(), Boolean.toString(this.cust.panel.isAutoRefresh()));
            p.put("browser.highlightselection." + this.getId(), Boolean.toString(this.cust.panel.isHighlightSelection()));
            this.project.getProjectHelper().putProperties("nbproject/project.properties", p);
        }
    }

    public BrowserIntegration getBrowserIntegration() {
        return this.browserIntegration;
    }

    public boolean canBeDefaultConfiguration() {
        return this.browserIntegration == BrowserIntegration.ENABLED && (this.browser.getBrowserFamily() == BrowserFamilyId.CHROME || this.browser.getBrowserFamily() == BrowserFamilyId.CHROMIUM);
    }

    public boolean isAutoRefresh() {
        String val = this.project.getEvaluator().getProperty("browser.autorefresh." + this.getId());
        if (val != null) {
            return Boolean.parseBoolean(val) && this.getBrowserIntegration() == BrowserIntegration.ENABLED;
        }
        return this.getBrowserIntegration() == BrowserIntegration.ENABLED;
    }

    public boolean isHighlightSelectionEnabled() {
        String val = this.project.getEvaluator().getProperty("browser.highlightselection." + this.getId());
        if (val != null) {
            return Boolean.parseBoolean(val) && this.getBrowserIntegration() == BrowserIntegration.ENABLED;
        }
        return this.getBrowserIntegration() == BrowserIntegration.ENABLED;
    }

    public String getDisplayName() {
        if (this.browserIntegration == BrowserIntegration.ENABLED && this.browser.getBrowserFamily() != BrowserFamilyId.JAVAFX_WEBVIEW) {
            return NbBundle.getMessage(ClientProjectConfigurationImpl.class, (String)"WITH_NETBEANS_INTEGRATION", (Object)this.browser.getName());
        }
        return this.browser.getName();
    }

    public RefreshOnSaveListener getRefreshOnSaveListener() {
        return new RefreshOnSaveListenerImpl(this.project, this.getBrowserSupport(), this);
    }

    public ActionProvider getActionProvider() {
        return new BrowserActionProvider(this.project, this.getBrowserSupport(), this);
    }

    public ProjectConfigurationCustomizer getProjectConfigurationCustomizer() {
        if (this.cust == null) {
            this.cust = new ProjectConfigurationCustomizerImpl();
        }
        return this.cust;
    }

    public BrowserSupport getBrowserSupport() {
        if (this.browserSupport == null) {
            this.browserSupport = this.browser.isEmbedded() ? BrowserSupport.getDefaultEmbedded() : BrowserSupport.create((WebBrowser)this.browser, (boolean)this.disableIntegration);
        }
        return this.browserSupport;
    }

    public boolean canBeDeleted() {
        return false;
    }

    public void delete() {
        throw new UnsupportedOperationException("not allowed");
    }

    public void deactivate() {
        if (this.browserSupport != null) {
            this.getBrowserSupport().close(false);
        }
    }

    int getOrder() {
        return this.order;
    }

    private class ProjectConfigurationCustomizerImpl
    implements ProjectConfigurationCustomizer {
        private BrowserConfigurationPanel panel;

        private ProjectConfigurationCustomizerImpl() {
        }

        public JPanel createPanel() {
            this.panel = new BrowserConfigurationPanel(ClientProjectConfigurationImpl.this.project, ClientProjectConfigurationImpl.this, ClientProjectConfigurationImpl.this.browser);
            return this.panel;
        }
    }

    public static enum BrowserIntegration {
        ENABLED,
        DISABLE,
        NONE;

    }
}

