/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.browser;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.javascript.jstestdriver.api.RunTests;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.browser.ClientProjectConfigurationImpl;
import org.netbeans.modules.web.clientproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.api.WebServer;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BrowserActionProvider
implements ActionProvider {
    private final ClientSideProject project;
    private final BrowserSupport support;
    private ClientProjectConfigurationImpl cfg;
    private RequestProcessor RP = new RequestProcessor("js unit testing");
    private static final Logger LOGGER = Logger.getLogger(BrowserActionProvider.class.getName());

    public BrowserActionProvider(ClientSideProject project, BrowserSupport support, ClientProjectConfigurationImpl cfg) {
        this.project = project;
        this.support = support;
        this.cfg = cfg;
    }

    public String[] getSupportedActions() {
        return new String[]{"run"};
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if (this.project.isUsingEmbeddedServer()) {
            WebServer.getWebserver().start((Project)this.project, this.project.getSiteRootFolder(), this.project.getWebContextRoot());
        } else {
            WebServer.getWebserver().stop((Project)this.project);
        }
        String startFile = this.project.getStartFile();
        String[] splt = ClientSideProjectUtilities.splitPathAndFragment(startFile);
        String justStartFile = splt[0];
        String fragment = splt[1];
        if ("run".equals(command)) {
            FileObject siteRoot = this.project.getSiteRootFolder();
            if (siteRoot == null) {
                ProjectProblems.showAlert((Project)this.project);
                return;
            }
            FileObject fo = siteRoot.getFileObject(justStartFile);
            if (fo == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(BrowserActionProvider.class, (String)"MAIN_FILE", (Object)startFile)));
                CustomizerProviderImpl cust = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
                cust.showCustomizer("RUN");
                splt = ClientSideProjectUtilities.splitPathAndFragment(this.project.getStartFile());
                justStartFile = splt[0];
                fragment = splt[1];
                fo = siteRoot.getFileObject(justStartFile);
                if (fo == null) {
                    return;
                }
            }
            this.browseFile(this.support, fo, fragment);
        } else if ("run.single".equals(command)) {
            FileObject fo = this.getFile(context);
            if (fo != null) {
                this.browseFile(this.support, fo);
            }
        } else if ("test".equals(command)) {
            this.runTests(null);
        }
    }

    private void runTests(final String testName) {
        if (this.project.getConfigFolder() == null || this.project.getConfigFolder().getFileObject("jsTestDriver.conf") == null || this.project.getTestsFolder() == null) {
            return;
        }
        final FileObject configFile = this.project.getConfigFolder().getFileObject("jsTestDriver.conf");
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (testName == null) {
                        RunTests.runAllTests((Project)BrowserActionProvider.this.project, (FileObject)BrowserActionProvider.this.project.getProjectDirectory(), (FileObject)configFile);
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "cannot execute tests", t);
                }
            }
        });
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if ("test".equals(command)) {
            return this.project.getConfigFolder() != null && this.project.getConfigFolder().getFileObject("jsTestDriver.conf") != null && this.project.getTestsFolder() != null;
        }
        return true;
    }

    private FileObject getFile(Lookup context) {
        return (FileObject)context.lookup(FileObject.class);
    }

    private boolean isHTMLFile(FileObject fo) {
        return fo != null && "html".equals(fo.getExt());
    }

    private void browseFile(BrowserSupport bs, FileObject fo) {
        this.browseFile(bs, fo, "");
    }

    private void browseFile(BrowserSupport bs, FileObject fo, String fragment) {
        URL url = ServerURLMapping.toServer((Project)this.project, (FileObject)fo);
        if (fragment.length() > 0) {
            url = WebUtils.stringToUrl((String)(WebUtils.urlToString((URL)url) + fragment));
        }
        bs.load(url, fo);
    }
}

