/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.netbeans.modules.javascript.jstestdriver.api.JsTestDriver;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.common.api.WebServer;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ServerURLMappingImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class ServerURLMappingImpl
implements ServerURLMappingImplementation {
    private ClientSideProject project;

    public ServerURLMappingImpl(ClientSideProject project) {
        this.project = project;
    }

    public URL toServer(int projectContext, FileObject projectFile) {
        if (projectContext == 1) {
            if (this.project.isUsingEmbeddedServer()) {
                return WebServer.getWebserver().toServer(projectFile);
            }
            String relPath = FileUtil.getRelativePath((FileObject)this.project.getSiteRootFolder(), (FileObject)projectFile);
            String root = this.project.getEvaluator().getProperty("external.project.url");
            if (root == null) {
                return null;
            }
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            return WebUtils.stringToUrl((String)(root + relPath));
        }
        return this.toJsTestDriverServer(projectFile);
    }

    public FileObject fromServer(int projectContext, URL serverURL) {
        FileObject fo = null;
        if (this.project.isUsingEmbeddedServer()) {
            fo = WebServer.getWebserver().fromServer(serverURL);
        } else {
            String root = this.project.getEvaluator().getProperty("external.project.url");
            if (root == null) {
                return null;
            }
            String u = WebUtils.urlToString((URL)serverURL);
            if (u.startsWith(root)) {
                FileObject siteRoot;
                if ((u = u.substring(root.length())).startsWith("/")) {
                    u = u.substring(1);
                }
                if ((siteRoot = this.project.getSiteRootFolder()) != null) {
                    fo = siteRoot.getFileObject(u);
                } else {
                    return null;
                }
            }
        }
        if (fo == null) {
            fo = this.fromJsTestDriverServer(serverURL);
        }
        return fo;
    }

    private URL toJsTestDriverServer(FileObject projectFile) {
        String prefix = JsTestDriver.getServerURL();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        prefix = prefix + "test/";
        String relativePath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)projectFile);
        if (relativePath != null) {
            try {
                return new URL(prefix + relativePath);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private FileObject fromJsTestDriverServer(URL serverURL) {
        String serverU = WebUtils.urlToString((URL)serverURL);
        String prefix = JsTestDriver.getServerURL();
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (!serverU.startsWith(prefix = prefix + "test/")) {
            return null;
        }
        String projectRelativePath = serverU.substring(prefix.length());
        try {
            projectRelativePath = URLDecoder.decode(projectRelativePath, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (projectRelativePath.length() > 0) {
            return this.project.getProjectDirectory().getFileObject(projectRelativePath);
        }
        return null;
    }
}

