/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.web.clientproject.Bundle;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectConfigurationImplementation;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public class ClientSideProjectActionProvider
implements ActionProvider {
    private final ClientSideProject project;

    public ClientSideProjectActionProvider(ClientSideProject project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        return new String[]{"run.single", "build", "clean", "run", "rename", "move", "copy", "delete", "test"};
    }

    private ActionProvider getActionProvider() {
        ClientProjectConfigurationImplementation cfg = this.project.getProjectConfigurations().getActiveConfiguration();
        if (cfg != null) {
            return cfg.getActionProvider();
        }
        return null;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        LifecycleManager.getDefault().saveAll();
        if ("rename".equals(command)) {
            this.renameProject();
            return;
        }
        if ("move".equals(command)) {
            this.moveProject();
            return;
        }
        if ("copy".equals(command)) {
            this.copyProject();
            return;
        }
        if ("delete".equals(command)) {
            this.deleteProject();
            return;
        }
        ActionProvider ap = this.getActionProvider();
        if (ap != null) {
            if (!this.checkSiteRoot()) {
                return;
            }
            ap.invokeAction(command, context);
            return;
        }
        NotifyDescriptor desc = new NotifyDescriptor((Object)"Action not supported for this configuration", "Action not supported", 2, 1, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(desc);
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        ActionProvider ap = this.getActionProvider();
        if (ap != null) {
            return ap.isActionEnabled(command, context);
        }
        return true;
    }

    private void renameProject() {
        DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
    }

    private void moveProject() {
        DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
    }

    private void copyProject() {
        DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
    }

    private void deleteProject() {
        DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
    }

    private boolean checkSiteRoot() {
        if (this.project.getSiteRootFolder() == null) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)Bundle.ClientSideProjectActionProvider_error_invalidSiteRoot(this.project.getName()), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            ProjectProblems.showCustomizer((Project)this.project);
            return false;
        }
        return true;
    }
}

