/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.web.clientproject.ClassPathProviderImpl;
import org.netbeans.modules.web.clientproject.ClientSideConfigurationProvider;
import org.netbeans.modules.web.clientproject.ClientSideProjectActionProvider;
import org.netbeans.modules.web.clientproject.ClientSideProjectSources;
import org.netbeans.modules.web.clientproject.FileEncodingQueryImpl;
import org.netbeans.modules.web.clientproject.PageInspectorCustomizerImpl;
import org.netbeans.modules.web.clientproject.ServerURLMappingImpl;
import org.netbeans.modules.web.clientproject.SharabilityQueryImpl;
import org.netbeans.modules.web.clientproject.api.ClientSideModule;
import org.netbeans.modules.web.clientproject.problems.ProjectPropertiesProblemProvider;
import org.netbeans.modules.web.clientproject.remote.RemoteFiles;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectConfigurationImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.RefreshOnSaveListener;
import org.netbeans.modules.web.clientproject.ui.ClientSideProjectLogicalView;
import org.netbeans.modules.web.clientproject.ui.action.ProjectOperations;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ClientSideProject
implements Project {
    static final Logger LOGGER = Logger.getLogger(ClientSideProject.class.getName());
    public static final String PROJECT_ICON = "org/netbeans/modules/web/clientproject/ui/resources/projecticon.png";
    final AntProjectHelper projectHelper;
    private final ReferenceHelper referenceHelper;
    private final PropertyEvaluator eval;
    private final Lookup lookup;
    volatile String name;
    private RefreshOnSaveListener refreshOnSaveListener;
    private ClassPath sourcePath;
    private RemoteFiles remoteFiles;
    private ClientSideConfigurationProvider configurationProvider;
    private ClientProjectConfigurationImplementation lastActiveConfiguration;

    public ClientSideProject(AntProjectHelper helper) {
        this.projectHelper = helper;
        AuxiliaryConfiguration configuration = helper.createAuxiliaryConfiguration();
        this.eval = this.createEvaluator();
        this.referenceHelper = new ReferenceHelper(helper, configuration, this.eval);
        this.configurationProvider = new ClientSideConfigurationProvider(this);
        this.lookup = this.createLookup(configuration);
        this.remoteFiles = new RemoteFiles(this);
        this.lastActiveConfiguration = this.getProjectConfigurations().getActiveConfiguration();
        this.configurationProvider.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("activeConfiguration".equals(evt.getPropertyName())) {
                    ClientSideProject.this.refreshOnSaveListener = null;
                    if (ClientSideProject.this.lastActiveConfiguration != null) {
                        ClientSideProject.this.lastActiveConfiguration.deactivate();
                    }
                    ClientSideProject.this.lastActiveConfiguration = ClientSideProject.this.getProjectConfigurations().getActiveConfiguration();
                    if (ClientSideProject.this.lastActiveConfiguration != null) {
                        ClientSideProjectUtilities.logUsage(ClientSideProject.class, "USG_PROJECT_HTML5_CONFIGURATION_CHANGE", new Object[]{ClientSideProject.this.lastActiveConfiguration.getBrowserId()});
                    }
                }
            }
        });
    }

    public final ClientSideConfigurationProvider getProjectConfigurations() {
        return this.configurationProvider;
    }

    private RefreshOnSaveListener getRefreshOnSaveListener() {
        ClientProjectConfigurationImplementation cfg = this.configurationProvider.getActiveConfiguration();
        if (cfg != null) {
            return cfg.getRefreshOnSaveListener();
        }
        return null;
    }

    public boolean isUsingEmbeddedServer() {
        return !ClientSideProjectProperties.ProjectServer.EXTERNAL.name().equalsIgnoreCase(this.getEvaluator().getProperty("server"));
    }

    @CheckForNull
    public FileObject getSiteRootFolder() {
        String s = this.getEvaluator().getProperty("site.root.folder");
        if (s == null) {
            s = "";
        }
        if (s.length() == 0) {
            return this.getProjectDirectory();
        }
        return this.projectHelper.resolveFileObject(s);
    }

    public FileObject getTestsFolder() {
        String tests = this.getEvaluator().getProperty("test.folder");
        if (tests == null || tests.trim().length() == 0) {
            return null;
        }
        return this.getProjectDirectory().getFileObject(tests);
    }

    public FileObject getConfigFolder() {
        String config = this.getEvaluator().getProperty("config.folder");
        if (config == null || config.trim().length() == 0) {
            return null;
        }
        return this.getProjectDirectory().getFileObject(config);
    }

    public String getStartFile() {
        String s = this.getEvaluator().getProperty("start.file");
        if (s == null) {
            s = "index.html";
        }
        return s;
    }

    public String getWebContextRoot() {
        String ctx = this.getEvaluator().getProperty("web.context.root");
        if (ctx == null) {
            ctx = "/" + this.getProjectDirectory().getName();
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    public RemoteFiles getRemoteFiles() {
        return this.remoteFiles;
    }

    public AntProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public FileObject getProjectDirectory() {
        return this.getProjectHelper().getProjectDirectory();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public PropertyEvaluator getEvaluator() {
        return this.eval;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.referenceHelper;
    }

    public String getName() {
        if (this.name == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Element data = ClientSideProject.this.projectHelper.getPrimaryConfigurationData(true);
                    NodeList nameList = data.getElementsByTagNameNS("http://www.netbeans.org/ns/clientside-project/1", "name");
                    if (nameList.getLength() == 1 && (nameList = nameList.item(0).getChildNodes()).getLength() == 1 && nameList.item(0).getNodeType() == 3) {
                        ClientSideProject.this.name = ((Text)nameList.item(0)).getNodeValue();
                    }
                    if (ClientSideProject.this.name == null) {
                        ClientSideProject.this.name = ClientSideProject.this.getProjectDirectory().getNameExt();
                    }
                    return null;
                }
            });
        }
        assert (this.name != null);
        return this.name;
    }

    public void setName(String name) {
        ClientSideProjectUtilities.setProjectName(this.projectHelper, name);
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator baseEval2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.projectHelper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.projectHelper.getPropertyProvider("nbproject/private/private.properties")});
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.projectHelper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.projectHelper.getPropertyProvider("nbproject/private/private.properties"), PropertyUtils.userPropertiesProvider((PropertyEvaluator)baseEval2, (String)"user.properties.file", (File)FileUtil.toFile((FileObject)this.getProjectDirectory())), this.projectHelper.getPropertyProvider("nbproject/project.properties")});
    }

    private Lookup createLookup(AuxiliaryConfiguration configuration) {
        return Lookups.fixed((Object[])new Object[]{this, new Info(), new ClientSideProjectXmlSavedHook(), new ProjectOperations(this), ProjectSearchInfo.create(this), new FileEncodingQueryImpl(this.getEvaluator(), "files.encoding"), new ServerURLMappingImpl(this), configuration, this.projectHelper.createCacheDirectoryProvider(), this.projectHelper.createAuxiliaryProperties(), this.getEvaluator(), new ClientSideProjectLogicalView(this), new RecommendedAndPrivilegedTemplatesImpl(), new ClientSideProjectActionProvider(this), new OpenHookImpl(this), new CustomizerProviderImpl(this), new ClientSideConfigurationProvider(this), new ClassPathProviderImpl(this), this.configurationProvider, new PageInspectorCustomizerImpl(this), new ProjectWebRootProviderImpl(), new ClientSideProjectSources(this, this.projectHelper, this.eval), new ClientSideModuleImpl(this), ProjectPropertiesProblemProvider.createForProject(this), UILookupMergerSupport.createProjectProblemsProviderMerger(), SharabilityQueryImpl.create(this.projectHelper, this.eval, "site.root.folder", "test.folder", "config.folder")});
    }

    ClassPath getSourceClassPath() {
        if (this.sourcePath == null) {
            this.sourcePath = ClassPathProviderImpl.createProjectClasspath(this);
        }
        return this.sourcePath;
    }

    private static final class ClientSideModuleImpl
    implements ClientSideModule {
        private final ClientSideProject project;

        public ClientSideModuleImpl(ClientSideProject project) {
            this.project = project;
        }

        public ClientSideModule.Properties getProperties() {
            return new PropertiesImpl();
        }

        private final class PropertiesImpl
        implements ClientSideModule.Properties {
            private PropertiesImpl() {
            }

            public FileObject getStartFile() {
                File startFile = this.getProjectProperties().getResolvedStartFile();
                if (startFile == null) {
                    return null;
                }
                return FileUtil.toFileObject((File)startFile);
            }

            public String getWebContextRoot() {
                return this.getProjectProperties().getWebRoot();
            }

            private ClientSideProjectProperties getProjectProperties() {
                return new ClientSideProjectProperties(ClientSideModuleImpl.this.project);
            }
        }
    }

    private static final class ProjectSearchInfo
    extends SearchInfoDefinition {
        private static final Set<String> WATCHED_PROPERTIES = new HashSet<String>(Arrays.asList("site.root.folder", "test.folder", "config.folder"));
        private final ClientSideProject project;
        private SearchInfo delegate = null;

        public ProjectSearchInfo(ClientSideProject project) {
            this.project = project;
        }

        public static SearchInfoDefinition create(ClientSideProject project) {
            final ProjectSearchInfo searchInfo = new ProjectSearchInfo(project);
            project.getEvaluator().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (WATCHED_PROPERTIES.contains(evt.getPropertyName())) {
                        searchInfo.resetDelegate();
                    }
                }
            });
            return searchInfo;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<FileObject> filesToSearch(SearchScopeOptions options, SearchListener listener, AtomicBoolean terminated) {
            return this.getDelegate().getFilesToSearch(options, listener, terminated).iterator();
        }

        public List<SearchRoot> getSearchRoots() {
            return this.getDelegate().getSearchRoots();
        }

        private synchronized SearchInfo getDelegate() {
            assert (Thread.holdsLock((Object)this));
            if (this.delegate == null) {
                this.delegate = this.createDelegate();
            }
            return this.delegate;
        }

        private SearchInfo createDelegate() {
            return SearchInfoUtils.createSearchInfoForRoots((FileObject[])this.getRoots(), (boolean)true, (SearchFilterDefinition[])new SearchFilterDefinition[0]);
        }

        synchronized void resetDelegate() {
            assert (Thread.holdsLock((Object)this));
            this.delegate = null;
        }

        private FileObject[] getRoots() {
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            this.addRoots(roots, this.project.getSiteRootFolder(), this.project.getConfigFolder(), this.project.getTestsFolder());
            return roots.toArray(new FileObject[roots.size()]);
        }

        private void addRoots(List<FileObject> result, FileObject ... roots) {
            for (FileObject root : roots) {
                if (root == null) continue;
                result.add(root);
            }
        }
    }

    private final class ProjectWebRootProviderImpl
    implements ProjectWebRootProvider {
        private ProjectWebRootProviderImpl() {
        }

        public FileObject getWebRoot(FileObject file) {
            return ClientSideProject.this.getSiteRootFolder();
        }
    }

    private static class SiteRootFolderListener
    implements FileChangeListener {
        private final ClientSideProject p;

        SiteRootFolderListener(ClientSideProject p) {
            this.p = p;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            RefreshOnSaveListener r = this.p.getRefreshOnSaveListener();
            if (r != null && !fe.getFile().hasExt("css")) {
                r.fileChanged(fe.getFile());
            }
        }

        public void fileDeleted(FileEvent fe) {
            RefreshOnSaveListener r = this.p.getRefreshOnSaveListener();
            if (r != null && !fe.getFile().hasExt("css")) {
                r.fileDeleted(fe.getFile());
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private static class OpenHookImpl
    extends ProjectOpenedHook
    implements PropertyChangeListener {
        private final ClientSideProject project;
        private final FileChangeListener siteRootChangesListener;
        private File siteRootFolder;

        public OpenHookImpl(ClientSideProject project) {
            this.project = project;
            this.siteRootChangesListener = new SiteRootFolderListener(project);
        }

        protected void projectOpened() {
            this.project.getEvaluator().addPropertyChangeListener((PropertyChangeListener)this);
            this.addSiteRootListener();
            GlobalPathRegistry.getDefault().register("classpath/html5", new ClassPath[]{this.project.getSourceClassPath()});
            String browserId = "";
            ClientProjectConfigurationImplementation cfg = this.project.getProjectConfigurations().getActiveConfiguration();
            if (cfg != null) {
                browserId = cfg.getBrowserId();
            }
            ClientSideProjectUtilities.logUsage(ClientSideProject.class, "USG_PROJECT_HTML5_OPEN", new Object[]{browserId, this.project.getTestsFolder() != null && this.project.getTestsFolder().getChildren().length > 0 ? "YES" : "NO"});
        }

        protected void projectClosed() {
            this.project.getEvaluator().removePropertyChangeListener((PropertyChangeListener)this);
            this.removeSiteRootListener();
            GlobalPathRegistry.getDefault().unregister("classpath/html5", new ClassPath[]{this.project.getSourceClassPath()});
        }

        private synchronized void addSiteRootListener() {
            assert (this.siteRootFolder == null) : "Should not be listening to " + this.siteRootFolder;
            FileObject siteRoot = this.project.getSiteRootFolder();
            if (siteRoot == null) {
                return;
            }
            this.siteRootFolder = FileUtil.toFile((FileObject)siteRoot);
            if (this.siteRootFolder == null) {
                LOGGER.log(Level.WARNING, "File not found for FileObject: {0}", siteRoot);
                return;
            }
            FileUtil.addRecursiveListener((FileChangeListener)this.siteRootChangesListener, (File)this.siteRootFolder);
        }

        private synchronized void removeSiteRootListener() {
            if (this.siteRootFolder == null) {
                return;
            }
            try {
                FileUtil.removeRecursiveListener((FileChangeListener)this.siteRootChangesListener, (File)this.siteRootFolder);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            this.siteRootFolder = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("site.root.folder".equals(evt.getPropertyName())) {
                OpenHookImpl openHookImpl = this;
                synchronized (openHookImpl) {
                    this.removeSiteRootListener();
                    this.addSiteRootListener();
                }
            }
        }
    }

    private static final class RecommendedAndPrivilegedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private RecommendedAndPrivilegedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return new String[]{"clientside-types", "XML", "simple-files"};
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/ClientSide/html.html", "Templates/ClientSide/javascript.js", "Templates/ClientSide/css.css", "Templates/ClientSide/json.json", "Templates/Other/org-netbeans-modules-project-ui-NewFileIterator-folderIterator"};
        }
    }

    private final class ClientSideProjectXmlSavedHook
    extends ProjectXmlSavedHook {
        private ClientSideProjectXmlSavedHook() {
        }

        protected void projectXmlSaved() throws IOException {
            Info info = (Info)ClientSideProject.this.getLookup().lookup(Info.class);
            assert (info != null);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        private Info() {
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        public String getDisplayName() {
            return ClientSideProject.this.getName();
        }

        public Icon getIcon() {
            return new ImageIcon(ImageUtilities.loadImage((String)ClientSideProject.PROJECT_ICON));
        }

        public Project getProject() {
            return ClientSideProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        void firePropertyChange(String prop) {
            this.propertyChangeSupport.firePropertyChange(prop, null, null);
        }
    }
}

