/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.browser.ClientProjectConfigurationImpl;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectConfigurationImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectPlatformImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectPlatformProvider;
import org.netbeans.modules.web.clientproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public final class ClientSideConfigurationProvider
implements ProjectConfigurationProvider<ClientProjectConfigurationImplementation>,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ClientSideConfigurationProvider.class.getName());
    public static final String PROP_CONFIG = "config";
    public static final String CONFIG_PROPS_PATH = "nbproject/private/private.properties";
    private Lookup.Result<ClientProjectPlatformProvider> res = Lookup.getDefault().lookupResult(ClientProjectPlatformProvider.class);
    private final ClientSideProject p;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Map<String, ClientProjectConfigurationImplementation> configs;
    private List<ClientProjectConfigurationImplementation> orderedConfigurations;
    private ClientProjectConfigurationImplementation lastConfig;

    public ClientSideConfigurationProvider(ClientSideProject p) {
        this.p = p;
        this.res.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                ClientSideConfigurationProvider.this.refreshConfigurations();
            }
        });
        this.lastConfig = this.getActiveConfiguration();
        p.getEvaluator().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (ClientSideConfigurationProvider.PROP_CONFIG.equals(evt.getPropertyName())) {
                    ClientProjectConfigurationImplementation cfg = ClientSideConfigurationProvider.this.getActiveConfiguration();
                    if (ClientSideConfigurationProvider.this.lastConfig != null && cfg != null && ClientSideConfigurationProvider.this.lastConfig.getId().equals(cfg.getId())) {
                        return;
                    }
                    ClientSideConfigurationProvider.this.lastConfig = cfg;
                    LOGGER.log(Level.FINER, "Refiring config -> activeConfiguration");
                    ClientSideConfigurationProvider.this.pcs.firePropertyChange("activeConfiguration", null, null);
                }
            }
        });
    }

    private void calculateConfigs() {
        this.configs = new HashMap<String, ClientProjectConfigurationImplementation>();
        this.orderedConfigurations = new ArrayList<ClientProjectConfigurationImplementation>();
        for (ClientProjectPlatformProvider prov : this.res.allInstances()) {
            for (ClientProjectPlatformImplementation platform : prov.getPlatforms((Project)this.p)) {
                platform.removePropertyChangeListener((PropertyChangeListener)this);
                platform.addPropertyChangeListener((PropertyChangeListener)this);
                for (ClientProjectConfigurationImplementation cfg : platform.getConfigurations()) {
                    this.configs.put(cfg.getId(), cfg);
                    this.orderedConfigurations.add(cfg);
                }
            }
        }
        LOGGER.log(Level.FINEST, "Calculated configurations: {0}", this.configs);
    }

    public Collection<ClientProjectConfigurationImplementation> getConfigurations() {
        if (this.configs == null) {
            this.calculateConfigs();
        }
        ArrayList<ClientProjectConfigurationImplementation> l = new ArrayList<ClientProjectConfigurationImplementation>();
        l.addAll(this.orderedConfigurations);
        return l;
    }

    public ClientProjectConfigurationImplementation getActiveConfiguration() {
        String config;
        if (this.configs == null) {
            this.calculateConfigs();
        }
        if ((config = this.p.getEvaluator().getProperty(PROP_CONFIG)) != null && this.configs.containsKey(config)) {
            return this.configs.get(config);
        }
        return this.getDefaultConfiguration(this.orderedConfigurations);
    }

    public void setActiveConfiguration(ClientProjectConfigurationImplementation c) throws IllegalArgumentException, IOException {
        EditableProperties ep;
        String n = c.getId();
        if (Utilities.compareObjects((Object)n, (Object)(ep = this.p.getProjectHelper().getProperties(CONFIG_PROPS_PATH)).getProperty(PROP_CONFIG))) {
            return;
        }
        ep.setProperty(PROP_CONFIG, n);
        this.p.getProjectHelper().putProperties(CONFIG_PROPS_PATH, ep);
        ProjectManager.getDefault().saveProject((Project)this.p);
        assert (this.p.getProjectDirectory().getFileObject(CONFIG_PROPS_PATH) != null);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        ((CustomizerProviderImpl)this.p.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("RUN");
    }

    public boolean configurationsAffectAction(String command) {
        return command.equals("run") || command.equals("build") || command.equals("clean") || command.equals("run.single");
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.pcs.addPropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.pcs.removePropertyChangeListener(lst);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        LOGGER.log(Level.FINEST, "Received {0}", e);
        this.refreshConfigurations();
    }

    private void refreshConfigurations() {
        Set oldConfigs = this.configs != null ? this.configs.keySet() : Collections.emptySet();
        this.calculateConfigs();
        Set<String> newConfigs = this.configs.keySet();
        if (!((Object)oldConfigs).equals(newConfigs)) {
            LOGGER.log(Level.FINER, "Firing configurations: {0} -> {1}", new Object[]{oldConfigs, newConfigs});
            this.pcs.firePropertyChange("configurations", null, null);
        }
    }

    public String[] getNewConfigurationTypes() {
        ArrayList types = new ArrayList();
        for (ClientProjectPlatformProvider prov : this.res.allInstances()) {
            for (ClientProjectPlatformImplementation platform : prov.getPlatforms((Project)this.p)) {
                types.addAll(platform.getNewConfigurationTypes());
            }
        }
        return types.toArray(new String[types.size()]);
    }

    public String createNewConfiguration(String type, String newName) {
        for (ClientProjectPlatformProvider prov : this.res.allInstances()) {
            for (ClientProjectPlatformImplementation platform : prov.getPlatforms((Project)this.p)) {
                String id = platform.createConfiguration(type, newName);
                if (id == null) continue;
                return id;
            }
        }
        assert (false) : "should never happen: no platform can create configuration of type " + type + " and name it " + newName;
        return null;
    }

    private ClientProjectConfigurationImplementation getDefaultConfiguration(List<ClientProjectConfigurationImplementation> cfgs) {
        for (ClientProjectConfigurationImplementation cfg : cfgs) {
            if (!(cfg instanceof ClientProjectConfigurationImpl) || !((ClientProjectConfigurationImpl)cfg).canBeDefaultConfiguration()) continue;
            return cfg;
        }
        if (cfgs.size() > 0) {
            return cfgs.get(0);
        }
        return null;
    }
}

