/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ClassPathProviderImpl
implements ClassPathProvider {
    public static final String SOURCE_CP = "classpath/html5";
    private ClientSideProject project;

    public ClassPathProviderImpl(ClientSideProject project) {
        this.project = project;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (SOURCE_CP.equals(type)) {
            FileObject siteRootFolder = this.project.getSiteRootFolder();
            if (siteRootFolder == null) {
                return null;
            }
            if (FileUtil.isParentOf((FileObject)siteRootFolder, (FileObject)file) || this.project.getTestsFolder() != null && FileUtil.isParentOf((FileObject)this.project.getTestsFolder(), (FileObject)file)) {
                return this.project.getSourceClassPath();
            }
        }
        return null;
    }

    public static ClassPath createProjectClasspath(ClientSideProject project) {
        return ClassPathSupport.createClassPath(Collections.singletonList(new PathImpl(project)));
    }

    private static class PathImpl
    implements FilteringPathResourceImplementation {
        private final ClientSideProject project;
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);

        public PathImpl(ClientSideProject project) {
            this.project = project;
            this.project.getEvaluator().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("site.root.folder".equals(evt.getPropertyName()) || "test.folder".equals(evt.getPropertyName()) || evt.getPropertyName().startsWith("file.reference.")) {
                        PathImpl.this.support.firePropertyChange("roots", null, null);
                    }
                }
            });
        }

        public boolean includes(URL root, String resource) {
            return !resource.startsWith("nbproject");
        }

        public URL[] getRoots() {
            FileObject testsFolder;
            ArrayList<URL> l = new ArrayList<URL>(2);
            FileObject sourcesFolder = this.project.getSiteRootFolder();
            if (sourcesFolder != null) {
                l.add(sourcesFolder.toURL());
            }
            if ((testsFolder = this.project.getTestsFolder()) != null) {
                l.add(testsFolder.toURL());
            }
            return l.toArray(new URL[l.size()]);
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }
    }
}

