/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.nbparser;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.lib.AbstractParseTreeNode;
import org.netbeans.modules.css.lib.ExtCss3Lexer;
import org.netbeans.modules.css.lib.ExtCss3Parser;
import org.netbeans.modules.css.lib.NbParseTreeBuilder;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.ProblemDescription;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.CharSequences;

public class CssParser
extends Parser {
    private static final CharSequence TEMPLATING_MARK = "@@@";
    private static final Logger LOG = Logger.getLogger(CssParser.class.getSimpleName());
    private CssParserResult result;

    public static CssParserResult parse(Snapshot snapshot) throws ParseException {
        CssParserResult cssParserResult;
        if (snapshot == null) {
            return null;
        }
        FileObject fo = snapshot.getSource().getFileObject();
        String fileName = fo == null ? "no file" : fo.getPath();
        LOG.log(Level.FINE, "Parsing {0} ", fileName);
        long start = System.currentTimeMillis();
        try {
            CharSequence source = snapshot.getText();
            ExtCss3Lexer lexer = new ExtCss3Lexer(source);
            CommonTokenStream tokenstream = new CommonTokenStream((TokenSource)lexer);
            NbParseTreeBuilder builder = new NbParseTreeBuilder(source);
            ExtCss3Parser parser = new ExtCss3Parser((TokenStream)tokenstream, builder);
            parser.styleSheet();
            AbstractParseTreeNode tree = builder.getTree();
            ArrayList<ProblemDescription> problems = new ArrayList<ProblemDescription>();
            problems.addAll(lexer.getProblems());
            problems.addAll(builder.getProblems());
            cssParserResult = new CssParserResult(snapshot, tree, CssParser.filterTemplatingProblems(snapshot, problems));
        }
        catch (RecognitionException ex) {
            try {
                throw new ParseException(String.format("Error parsing %s snapshot.", snapshot), (Throwable)ex);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                LOG.log(Level.FINE, "Parsing of {0} took {1} ms.", new Object[]{fileName, end - start});
                throw throwable;
            }
        }
        long end = System.currentTimeMillis();
        LOG.log(Level.FINE, "Parsing of {0} took {1} ms.", new Object[]{fileName, end - start});
        return cssParserResult;
    }

    private static List<ProblemDescription> filterTemplatingProblems(Snapshot snapshot, List<ProblemDescription> problems) {
        MimePath mimePath = snapshot.getMimePath();
        CharSequence text = snapshot.getText();
        if (mimePath.size() <= 2 || mimePath.size() == 3 && mimePath.getMimeType(0).equals("text/xhtml")) {
            return problems;
        }
        ArrayList<ProblemDescription> filtered = new ArrayList<ProblemDescription>(problems.size());
        for (ProblemDescription p : problems) {
            int to;
            char c;
            int from;
            if (p.getFrom() == text.length()) continue;
            for (from = p.getFrom(); from > 0 && (c = text.charAt(from)) != '\n'; --from) {
            }
            for (to = p.getTo(); to < text.length() && (c = text.charAt(to)) != '\n'; ++to) {
            }
            CharSequence img = snapshot.getText().subSequence(from, to);
            if (CharSequences.indexOf((CharSequence)img, (CharSequence)TEMPLATING_MARK) != -1) continue;
            filtered.add(p);
        }
        return filtered;
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.result = CssParser.parse(snapshot);
    }

    public ParserResult getResult(Task task) throws ParseException {
        return this.result;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

