/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.lib.api.CssTokenIdCategory;
import org.netbeans.modules.css.lib.nblexer.CssLanguageHierarchy;

public enum CssTokenId implements TokenId
{
    EOF(-1, CssTokenIdCategory.OTHERS),
    ERROR(0, CssTokenIdCategory.ERRORS),
    AND(15, CssTokenIdCategory.KEYWORDS),
    NOT(17, CssTokenIdCategory.KEYWORDS),
    ONLY(16, CssTokenIdCategory.KEYWORDS),
    RESOLUTION(77, CssTokenIdCategory.NUMBERS),
    WS(20, CssTokenIdCategory.WHITESPACES),
    CHARSET_SYM(8, CssTokenIdCategory.AT_RULE_SYMBOL),
    STRING(6, CssTokenIdCategory.STRINGS),
    SEMI(9, CssTokenIdCategory.SEPARATORS),
    IMPORT_SYM(10, CssTokenIdCategory.AT_RULE_SYMBOL),
    URI(7, CssTokenIdCategory.URIS),
    COMMA(14, CssTokenIdCategory.SEPARATORS),
    MEDIA_SYM(11, CssTokenIdCategory.AT_RULE_SYMBOL),
    LBRACE(12, CssTokenIdCategory.BRACES),
    RBRACE(13, CssTokenIdCategory.BRACES),
    IDENT(5, CssTokenIdCategory.IDENTIFIERS),
    PAGE_SYM(27, CssTokenIdCategory.AT_RULE_SYMBOL),
    COLON(46, CssTokenIdCategory.SEPARATORS),
    DCOLON(55, CssTokenIdCategory.SEPARATORS),
    SOLIDUS(47, CssTokenIdCategory.OTHERS),
    PLUS(48, CssTokenIdCategory.OPERATORS),
    GREATER(49, CssTokenIdCategory.OPERATORS),
    TILDE(50, CssTokenIdCategory.OPERATORS),
    MINUS(51, CssTokenIdCategory.OPERATORS),
    STAR(56, CssTokenIdCategory.OPERATORS),
    HASH(52, CssTokenIdCategory.HASHES),
    DOT(53, CssTokenIdCategory.OPERATORS),
    LBRACKET(54, CssTokenIdCategory.BRACES),
    OPEQ(59, CssTokenIdCategory.OTHERS),
    INCLUDES(60, CssTokenIdCategory.OPERATORS),
    DASHMATCH(61, CssTokenIdCategory.OPERATORS),
    RBRACKET(65, CssTokenIdCategory.BRACES),
    LPAREN(66, CssTokenIdCategory.BRACES),
    RPAREN(67, CssTokenIdCategory.BRACES),
    IMPORTANT_SYM(68, CssTokenIdCategory.KEYWORDS),
    NUMBER(69, CssTokenIdCategory.NUMBERS),
    PERCENTAGE(26, CssTokenIdCategory.NUMBERS),
    LENGTH(70, CssTokenIdCategory.NUMBERS),
    EMS(71, CssTokenIdCategory.NUMBERS),
    REM(72, CssTokenIdCategory.NUMBERS),
    EXS(73, CssTokenIdCategory.NUMBERS),
    ANGLE(74, CssTokenIdCategory.NUMBERS),
    TIME(75, CssTokenIdCategory.NUMBERS),
    FREQ(76, CssTokenIdCategory.NUMBERS),
    HEXCHAR(81, CssTokenIdCategory.NUMBERS),
    NONASCII(82, CssTokenIdCategory.OTHERS),
    UNICODE(83, CssTokenIdCategory.OTHERS),
    ESCAPE(84, CssTokenIdCategory.OTHERS),
    NMSTART(85, CssTokenIdCategory.OTHERS),
    NMCHAR(86, CssTokenIdCategory.OTHERS),
    NAME(58, CssTokenIdCategory.OTHERS),
    URL(87, CssTokenIdCategory.URIS),
    A(88, CssTokenIdCategory.OTHERS),
    B(89, CssTokenIdCategory.OTHERS),
    C(90, CssTokenIdCategory.OTHERS),
    D(91, CssTokenIdCategory.OTHERS),
    E(92, CssTokenIdCategory.OTHERS),
    F(93, CssTokenIdCategory.OTHERS),
    G(94, CssTokenIdCategory.OTHERS),
    H(95, CssTokenIdCategory.OTHERS),
    I(96, CssTokenIdCategory.OTHERS),
    J(97, CssTokenIdCategory.OTHERS),
    K(98, CssTokenIdCategory.OTHERS),
    L(99, CssTokenIdCategory.OTHERS),
    M(100, CssTokenIdCategory.OTHERS),
    N(101, CssTokenIdCategory.OTHERS),
    O(102, CssTokenIdCategory.OTHERS),
    P(103, CssTokenIdCategory.OTHERS),
    Q(104, CssTokenIdCategory.OTHERS),
    R(105, CssTokenIdCategory.OTHERS),
    S(106, CssTokenIdCategory.OTHERS),
    T(107, CssTokenIdCategory.OTHERS),
    U(108, CssTokenIdCategory.OTHERS),
    V(109, CssTokenIdCategory.OTHERS),
    W(110, CssTokenIdCategory.OTHERS),
    X(111, CssTokenIdCategory.OTHERS),
    Y(112, CssTokenIdCategory.OTHERS),
    Z(113, CssTokenIdCategory.OTHERS),
    COMMENT(80, CssTokenIdCategory.COMMENTS),
    CDO(114, CssTokenIdCategory.OTHERS),
    CDC(115, CssTokenIdCategory.OTHERS),
    INVALID(116, CssTokenIdCategory.OTHERS),
    DIMENSION(78, CssTokenIdCategory.NUMBERS),
    NL(79, CssTokenIdCategory.OTHERS),
    PIPE(57, CssTokenIdCategory.OPERATORS),
    GEN(18, CssTokenIdCategory.OTHERS),
    NAMESPACE_SYM(4, CssTokenIdCategory.AT_RULE_SYMBOL),
    TOPLEFTCORNER_SYM(30, CssTokenIdCategory.AT_RULE_SYMBOL),
    TOPLEFT_SYM(31, CssTokenIdCategory.AT_RULE_SYMBOL),
    TOPCENTER_SYM(32, CssTokenIdCategory.AT_RULE_SYMBOL),
    TOPRIGHT_SYM(33, CssTokenIdCategory.AT_RULE_SYMBOL),
    TOPRIGHTCORNER_SYM(34, CssTokenIdCategory.AT_RULE_SYMBOL),
    BOTTOMLEFTCORNER_SYM(35, CssTokenIdCategory.AT_RULE_SYMBOL),
    BOTTOMLEFT_SYM(36, CssTokenIdCategory.AT_RULE_SYMBOL),
    BOTTOMCENTER_SYM(37, CssTokenIdCategory.AT_RULE_SYMBOL),
    BOTTOMRIGHT_SYM(38, CssTokenIdCategory.AT_RULE_SYMBOL),
    BOTTOMRIGHTCORNER_SYM(39, CssTokenIdCategory.AT_RULE_SYMBOL),
    LEFTTOP_SYM(40, CssTokenIdCategory.AT_RULE_SYMBOL),
    LEFTMIDDLE_SYM(41, CssTokenIdCategory.AT_RULE_SYMBOL),
    LEFTBOTTOM_SYM(42, CssTokenIdCategory.AT_RULE_SYMBOL),
    RIGHTTOP_SYM(43, CssTokenIdCategory.AT_RULE_SYMBOL),
    RIGHTMIDDLE_SYM(44, CssTokenIdCategory.AT_RULE_SYMBOL),
    RIGHTBOTTOM_SYM(45, CssTokenIdCategory.AT_RULE_SYMBOL),
    WEBKIT_KEYFRAMES_SYM(25, CssTokenIdCategory.AT_RULE_SYMBOL),
    COUNTER_STYLE_SYM(28, CssTokenIdCategory.AT_RULE_SYMBOL),
    BEGINS(62, CssTokenIdCategory.OPERATORS),
    ENDS(63, CssTokenIdCategory.OPERATORS),
    CONTAINS(64, CssTokenIdCategory.OPERATORS),
    FONT_FACE_SYM(29, CssTokenIdCategory.AT_RULE_SYMBOL),
    HASH_CHAR_ONLY(117, CssTokenIdCategory.OTHERS),
    MOZ_DOCUMENT_SYM(21, CssTokenIdCategory.AT_RULE_SYMBOL),
    MOZ_DOMAIN(23, CssTokenIdCategory.URIS),
    MOZ_URL_PREFIX(22, CssTokenIdCategory.URIS),
    MOZ_REGEXP(24, CssTokenIdCategory.STRINGS),
    GENERIC_AT_RULE(19, CssTokenIdCategory.AT_RULE_SYMBOL);

    private static final Map<Integer, CssTokenId> codesMap;
    private final CssTokenIdCategory primaryCategory;
    private final int code;
    private static final Language<CssTokenId> language;

    public static CssTokenId forTokenTypeCode(int tokenTypeCode) {
        return codesMap.get(tokenTypeCode);
    }

    private CssTokenId(int code, CssTokenIdCategory primaryCategory) {
        this.primaryCategory = primaryCategory;
        this.code = code;
    }

    public static Language<CssTokenId> language() {
        return language;
    }

    public String primaryCategory() {
        return this.primaryCategory.name().toLowerCase();
    }

    public CssTokenIdCategory getTokenCategory() {
        return this.primaryCategory;
    }

    public boolean matchesInput(CharSequence input) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)input, CssTokenId.language());
        TokenSequence ts = th.tokenSequence(CssTokenId.language());
        ts.moveStart();
        if (!ts.moveNext()) {
            return false;
        }
        Token t = ts.token();
        return !ts.moveNext() && t.id() == this;
    }

    static {
        codesMap = new HashMap<Integer, CssTokenId>();
        for (CssTokenId id : CssTokenId.values()) {
            codesMap.put(id.code, id);
        }
        language = new CssLanguageHierarchy().language();
    }
}

