/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.lib.api.ErrorsProvider;
import org.netbeans.modules.css.lib.api.ProblemDescription;
import org.openide.filesystems.FileObject;

public class DefaultErrorsProvider
implements ErrorsProvider {
    @Override
    public List<? extends Error> getExtendedDiagnostics(CssParserResult parserResult) {
        return DefaultErrorsProvider.getCslErrorForCss3ProblemDescription(parserResult.getSnapshot().getSource().getFileObject(), parserResult.getParserDiagnostics());
    }

    public static List<Error> getCslErrorForCss3ProblemDescription(FileObject file, List<ProblemDescription> pds) {
        ArrayList<Error> errors = new ArrayList<Error>();
        for (ProblemDescription pd : pds) {
            errors.add(DefaultErrorsProvider.getCslErrorForCss3ProblemDescription(file, pd));
        }
        return errors;
    }

    private static Error getCslErrorForCss3ProblemDescription(FileObject file, ProblemDescription pd) {
        return new CssDefaultError(pd.getKey(), pd.getDescription(), pd.getDescription(), file, pd.getFrom(), pd.getTo(), false, DefaultErrorsProvider.getCslSeverityForCss3ProblemType(pd.getType()));
    }

    private static Severity getCslSeverityForCss3ProblemType(ProblemDescription.Type problemType) {
        switch (problemType) {
            case ERROR: {
                return Severity.ERROR;
            }
            case FATAL: {
                return Severity.FATAL;
            }
            case INFO: {
                return Severity.INFO;
            }
            case WARNING: {
                return Severity.WARNING;
            }
        }
        return Severity.ERROR;
    }

    private static class CssDefaultError
    extends DefaultError {
        private CssDefaultError(String key, String displayName, String description, FileObject file, int start, int end, boolean lineError, Severity severity) {
            super(key, displayName, description, file, start, end, lineError, severity);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            DefaultError other = (DefaultError)obj;
            if (this.getDisplayName() == null ? other.getDisplayName() != null : !this.getDisplayName().equals(other.getDisplayName())) {
                return false;
            }
            if (this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription())) {
                return false;
            }
            if (!(this.getFile() == other.getFile() || this.getFile() != null && this.getFile().equals(other.getFile()))) {
                return false;
            }
            if (this.getStartPosition() != other.getStartPosition()) {
                return false;
            }
            if (this.getEndPosition() != other.getEndPosition()) {
                return false;
            }
            if (this.isLineError() != other.isLineError()) {
                return false;
            }
            if (this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey())) {
                return false;
            }
            if (this.getSeverity() != other.getSeverity()) {
                return false;
            }
            return Arrays.deepEquals(this.getParameters(), other.getParameters());
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.getDisplayName() != null ? this.getDisplayName().hashCode() : 0);
            hash = 29 * hash + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
            hash = 29 * hash + (this.getFile() != null ? this.getFile().hashCode() : 0);
            hash = 29 * hash + this.getStartPosition();
            hash = 29 * hash + this.getEndPosition();
            hash = 29 * hash + (this.isLineError() ? 1 : 0);
            hash = 29 * hash + (this.getKey() != null ? this.getKey().hashCode() : 0);
            hash = 29 * hash + (this.getSeverity() != null ? this.getSeverity().hashCode() : 0);
            hash = 29 * hash + Arrays.deepHashCode(this.getParameters());
            return hash;
        }

        public String toString() {
            return super.toString() + " (file:" + this.getFile() + ", from:" + this.getStartPosition() + ", to:" + this.getEndPosition() + ")";
        }
    }
}

