/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.osgi.Bundle;
import org.netbeans.modules.maven.osgi.Matcher;
import org.netbeans.modules.maven.spi.queries.ForeignClassBundler;
import org.openide.util.Exceptions;

public class ForeignClassBundlerImpl
implements ForeignClassBundler {
    private static final ProblemReport PROBLEM_REPORT = new ProblemReport(5, Bundle.PRBL_Name(), Bundle.PRBL_DESC(), null);
    private final Project project;
    private boolean calculated = false;
    private boolean calculatedValue = false;

    public ForeignClassBundlerImpl(Project p) {
        this.project = p;
    }

    public synchronized boolean preferSources() {
        if (this.calculated) {
            return this.calculatedValue;
        }
        this.calculatedValue = this.calculateValue();
        this.calculated = true;
        return this.calculatedValue;
    }

    private boolean calculateValue() {
        NbMavenProject nbmp;
        ProblemReporter pr = (ProblemReporter)this.project.getLookup().lookup(ProblemReporter.class);
        if (pr != null) {
            pr.removeReport(PROBLEM_REPORT);
        }
        if ((nbmp = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)) == null) {
            return true;
        }
        MavenProject mp = nbmp.getMavenProject();
        Properties props = PluginPropertyUtils.getPluginPropertyParameter((Project)this.project, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"instructions", (String)"bundle");
        if (props != null) {
            String exportedPack = props.getProperty("Export-Package");
            String privatePack = props.getProperty("Private-Package");
            if (exportedPack != null || privatePack != null) {
                Matcher exported = new Matcher(exportedPack);
                Matcher prived = new Matcher(privatePack);
                for (Artifact a : mp.getRuntimeArtifacts()) {
                    File f = a.getFile();
                    if (f == null || !f.isFile()) continue;
                    try {
                        JarFile jf = new JarFile(f);
                        Enumeration<JarEntry> en = jf.entries();
                        while (en.hasMoreElements()) {
                            String pack;
                            JarEntry je = en.nextElement();
                            if (!je.isDirectory() || je.getName().startsWith("META-INF") || !exported.matches(pack = je.getName().substring(0, je.getName().length() - 1).replace("/", ".")) && !prived.matches(pack)) continue;
                            if (pr != null) {
                                pr.addReport(PROBLEM_REPORT);
                            }
                            return false;
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return true;
    }

    public synchronized void resetCachedValue() {
        this.calculated = false;
    }
}

