/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.osgi.util.PackageDefinitionUtil;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AccessQueryImpl
implements AccessibilityQueryImplementation {
    private final Project prj;
    private WeakReference<List<Pattern>> ref;
    private static String DEFAULT_IMP = "*";

    public AccessQueryImpl(Project prj) {
        this.prj = prj;
    }

    public Boolean isPubliclyAccessible(FileObject pkg) {
        String path;
        FileObject srcdir = FileUtilities.convertStringToFileObject((String)((NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class)).getMavenProject().getBuild().getSourceDirectory());
        if (srcdir != null && (path = FileUtil.getRelativePath((FileObject)srcdir, (FileObject)pkg)) != null) {
            String name = path.replace('/', '.');
            return this.check(name);
        }
        return null;
    }

    private Boolean check(String value) {
        String[] exps = PluginPropertyUtils.getPluginPropertyList((Project)this.prj, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"instructions", (String)"Export-Package", (String)"manifest");
        String[] imps = PluginPropertyUtils.getPluginPropertyList((Project)this.prj, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"instructions", (String)"Private-Package", (String)"manifest");
        String exp = null;
        if (exps != null && exps.length == 1) {
            exp = exps[0];
        }
        String imp = null;
        if (imps != null && imps.length == 1) {
            imp = imps[0];
        }
        if (exp != null && AccessQueryImpl.testPackagePatterns(exp, value)) {
            return Boolean.TRUE;
        }
        Boolean result = null;
        if (AccessQueryImpl.testPackagePatterns(imp != null ? imp : DEFAULT_IMP, value)) {
            result = Boolean.FALSE;
        }
        if (exp == null && !value.contains(".impl") && !value.contains(".internal")) {
            result = Boolean.TRUE;
        }
        return result;
    }

    static boolean testPackagePatterns(String patterns, String value) {
        boolean matches = false;
        if (patterns != null) {
            patterns = PackageDefinitionUtil.omitDirectives(patterns);
            StringTokenizer tok = new StringTokenizer(patterns, " ,", false);
            while (tok.hasMoreTokens() && !matches) {
                String token = tok.nextToken();
                if ("*".equals(token = token.trim())) {
                    return true;
                }
                boolean recursive = false;
                boolean exclusivePattern = false;
                if (token.startsWith("!")) {
                    token = token.substring(1);
                    exclusivePattern = true;
                }
                if (token.endsWith("*")) {
                    token = token.substring(0, token.length() - "*".length());
                    recursive = true;
                    if (token.endsWith(".")) {
                        token = token.substring(0, token.length() - 1);
                    }
                }
                if (!(matches = recursive ? value.startsWith(token) : value.equals(token)) || !exclusivePattern) continue;
                matches = !matches;
            }
        }
        return matches;
    }
}

