/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.features.ColorsManager;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;

class LanguagesHighlightsLayer
extends AbstractHighlightsContainer {
    private Document document;

    LanguagesHighlightsLayer(Document document) {
        this.document = document;
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        TokenSequence seq = TokenHierarchy.get((Document)this.document).tokenSequence();
        if (seq != null) {
            return new Highlights(seq, startOffset, endOffset);
        }
        return HighlightsSequence.EMPTY;
    }

    private static class Highlights
    implements HighlightsSequence {
        private int endOffset;
        private int startOffset1;
        private int endOffset1;
        private SimpleAttributeSet attributeSet;
        private TokenSequence tokenSequence;
        private String mimeType;
        private Map<String, Map<String, Color>> tokenImportColors = new HashMap<String, Map<String, Color>>();
        private Map<String, Color> preprocessorImportColors;

        private Highlights(TokenSequence tokenSequence, int startOffset, int endOffset) {
            this.tokenSequence = tokenSequence;
            this.mimeType = tokenSequence.language().mimeType();
            this.endOffset = endOffset;
            this.startOffset1 = startOffset;
            this.endOffset1 = startOffset;
        }

        public boolean moveNext() {
            if (this.tokenSequence == null) {
                return false;
            }
            this.attributeSet = new SimpleAttributeSet();
            do {
                this.startOffset1 = this.endOffset1;
                this.mark(this.tokenSequence);
                if (this.endOffset1 > this.startOffset1) {
                    return true;
                }
                this.tokenSequence.move(this.startOffset1);
                if (!this.tokenSequence.moveNext()) {
                    return false;
                }
                Token token = this.tokenSequence.token();
                this.endOffset1 = this.tokenSequence.offset() + token.length();
            } while (this.endOffset1 < this.endOffset);
            return false;
        }

        public int getStartOffset() {
            return this.startOffset1;
        }

        public int getEndOffset() {
            return this.endOffset1;
        }

        public AttributeSet getAttributes() {
            return this.attributeSet;
        }

        private void mark(TokenSequence ts) {
            Color c;
            ts.move(this.startOffset1);
            if (!ts.moveNext()) {
                return;
            }
            Token token = ts.token();
            TokenSequence ts2 = ts.embedded();
            if (ts2 == null) {
                return;
            }
            String mimeTypeOut = ts.language().mimeType();
            String mimeTypeIn = ts2.language().mimeType();
            if (token.id().name().equals("PE")) {
                Color c2 = this.getPreprocessorImportsColor(mimeTypeIn);
                if (c2 != null) {
                    this.attributeSet.addAttribute(StyleConstants.Background, c2);
                    this.attributeSet.addAttribute("org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE);
                    this.endOffset1 = this.tokenSequence.offset() + token.length();
                }
            } else if (!mimeTypeOut.equals(mimeTypeIn) && (c = this.getTokenImportsColor(mimeTypeOut, mimeTypeIn, token.id().name())) != null) {
                this.attributeSet.addAttribute(StyleConstants.Background, c);
                this.attributeSet.addAttribute("org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE);
                this.endOffset1 = this.tokenSequence.offset() + token.length();
            }
            this.mark(ts2);
        }

        private Color getPreprocessorImportsColor(String mimeTypeIn) {
            if (this.preprocessorImportColors == null) {
                this.preprocessorImportColors = new HashMap<String, Color>();
                try {
                    Language l = LanguagesManager.getDefault().getLanguage(this.mimeType);
                    Feature properties = l.getPreprocessorImport();
                    if (properties != null) {
                        String mimeType = (String)properties.getValue("mimeType");
                        Color color = ColorsManager.readColor((String)properties.getValue("background_color"));
                        if (color != null) {
                            this.preprocessorImportColors.put(mimeType, color);
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return this.preprocessorImportColors.get(mimeTypeIn);
        }

        private Color getTokenImportsColor(String mimeTypeOut, String mimeTypeIn, String tokenTypeIn) {
            Map<String, Color> m = this.tokenImportColors.get(mimeTypeOut);
            if (m == null) {
                m = new HashMap<String, Color>();
                this.tokenImportColors.put(mimeTypeOut, m);
                try {
                    Language l = LanguagesManager.getDefault().getLanguage(mimeTypeOut);
                    Map<String, Feature> m2 = l.getTokenImports();
                    for (String tokenType : m2.keySet()) {
                        Feature properties = m2.get(tokenType);
                        Color color = ColorsManager.readColor((String)properties.getValue("background_color"));
                        if (color == null) continue;
                        m.put(tokenType, color);
                    }
                }
                catch (LanguageDefinitionNotFoundException ex) {
                    // empty catch block
                }
            }
            if (m.containsKey(tokenTypeIn)) {
                return m.get(tokenTypeIn);
            }
            return m.get(mimeTypeIn);
        }
    }
}

