/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.common.project.ui.J2EEProjectProperties;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.BaseActionProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class AppClientActionProvider
extends BaseActionProvider {
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "redeploy", "javadoc", "test", "test.single", "debug.test.single", "run.single.method", "debug.single.method", "debug.fix", "debug.stepinto", "verify", "delete", "copy", "move", "rename"};
    private static final String[] platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "javadoc", "test", "test.single", "debug.test.single", "debug.fix", "debug.stepinto", "run.single.method", "debug.single.method"};
    private Set<String> bkgScanSensitiveActions;
    private Set<String> needJavaModelActions;
    private static final String[] actionsDisabledForQuickRun = new String[]{"compile.single", "debug.fix"};
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public AppClientActionProvider(AppClientProject project, UpdateHelper updateHelper) {
        super((Project)project, updateHelper, project.evaluator(), project.getSourceRoots(), project.getTestSourceRoots(), project.getAntProjectHelper(), (BaseActionProvider.Callback)new BaseActionProvider.CallbackImpl(project.getClassPathProvider()));
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("redeploy", new String[]{"run-deploy"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put("debug.stepinto", new String[]{"debug-stepinto"});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.needJavaModelActions = new HashSet<String>(Arrays.asList("debug.fix"));
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single", "debug.stepinto"));
    }

    protected String[] getPlatformSensitiveActions() {
        return platformSensitiveActions;
    }

    protected String[] getActionsDisabledForQuickRun() {
        return actionsDisabledForQuickRun;
    }

    public Map<String, String[]> getCommands() {
        return this.commands;
    }

    protected Set<String> getScanSensitiveActions() {
        return this.bkgScanSensitiveActions;
    }

    protected Set<String> getJavaModelActions() {
        return this.needJavaModelActions;
    }

    protected boolean isCompileOnSaveEnabled() {
        return false;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public String[] getTargetNames(String command, Lookup context, Properties p, boolean doJavaChecks) throws IllegalArgumentException {
        if (command.equals("run") || command.equals("redeploy") || command.equals("debug") || command.equals("debug.single") || command.equals("run.single")) {
            if (!this.isSelectedServer()) {
                String msg = NbBundle.getMessage(AppClientActionProvider.class, (String)"MSG_No_Server_Selected");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
                return null;
            }
            if (this.isDebugged()) {
                p.setProperty("is.debugged", "true");
            }
            if (command.equals("redeploy")) {
                p.setProperty("forceRedeploy", "true");
            } else {
                p.setProperty("forceRedeploy", "false");
            }
        }
        return super.getTargetNames(command, context, p, doJavaChecks);
    }

    public boolean isActionEnabled(String command, Lookup context) {
        boolean res = super.isActionEnabled(command, context);
        if (res && command.equals(COMMAND_VERIFY)) {
            return ((AppClientProject)this.getProject()).getCarModule().hasVerifierSupport();
        }
        if (command.equals("run") || command.equals("debug")) {
            return res && this.isSelectedServer() && !this.isTargetServerRemote();
        }
        return res;
    }

    private boolean isSelectedServer() {
        String instanceID;
        String id;
        String instance = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (instance != null && (id = Deployment.getDefault().getServerID(instance)) != null) {
            return true;
        }
        String serverType = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.type");
        if (serverType != null && (instanceID = J2EEProjectProperties.getMatchingInstance((String)serverType, (J2eeModule.Type)J2eeModule.Type.CAR, (Profile)((AppClientProject)this.getProject()).getAPICar().getJ2eeProfile())) != null) {
            this.setServerInstance(instanceID);
            return true;
        }
        return false;
    }

    private void setServerInstance(String serverInstanceId) {
        AppClientProjectProperties.setServerInstance((AppClientProject)this.getProject(), this.getAntProjectHelper(), serverInstanceId);
    }

    private boolean isDebugged() {
        J2eeModuleProvider jmp = (J2eeModuleProvider)this.getProject().getLookup().lookup(J2eeModuleProvider.class);
        ServerDebugInfo sdi = jmp.getServerDebugInfo();
        if (sdi == null) {
            return false;
        }
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            if (!(sdi.getTransport().equals("dt_shmem") ? attCookie.getSharedMemoryName().equalsIgnoreCase(sdi.getShmemName()) : attCookie.getHostName().equalsIgnoreCase(sdi.getHost()) && attCookie.getPortNumber() == sdi.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean isTargetServerRemote() {
        J2eeModuleProvider module = (J2eeModuleProvider)this.getProject().getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties props = module.getInstanceProperties();
        String domain = props.getProperty("DOMAIN");
        String location = props.getProperty("LOCATION");
        return "".equals(domain) && "".equals(location);
    }
}

