/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.runconfigs.RunConfigInternal;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RunAsInternalServer
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = -4154687891321321147L;
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final SourcesFolderProvider sourcesFolderProvider;
    private JLabel hostnameLabel;
    private JTextField hostnameTextField;
    private JLabel noteLabel;
    private JLabel phpVersionInfoLabel;
    private JLabel portLabel;
    private JTextField portTextField;
    private JButton routerBrowseButton;
    private JLabel routerLabel;
    private JTextField routerTextField;
    private JComboBox runAsComboBox;
    private JLabel runAsLabel;
    private JLabel urlHintLabel;

    public RunAsInternalServer(ConfigManager manager, SourcesFolderProvider sourcesFolderProvider) {
        super(manager);
        this.sourcesFolderProvider = sourcesFolderProvider;
        this.initComponents();
        this.labels = new JLabel[]{this.hostnameLabel, this.portLabel, this.routerLabel};
        this.textFields = new JTextField[]{this.hostnameTextField, this.portTextField, this.routerTextField};
        this.propertyNames = new String[]{"hostname", "port", "router"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater dl = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(dl);
        }
        this.runAsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunAsInternalServer.this.changeSupport.fireChange();
            }
        });
    }

    @Override
    protected PhpProjectProperties.RunAsType getRunAsType() {
        return RunConfigInternal.getRunAsType();
    }

    @Override
    protected String getDisplayName() {
        return RunConfigInternal.getDisplayName();
    }

    @Override
    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    @Override
    protected JComboBox getRunAsCombo() {
        return this.runAsComboBox;
    }

    @Override
    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            String value = this.getValue(this.propertyNames[i]);
            if (value == null) {
                if ("hostname".equals(this.propertyNames[i])) {
                    value = "localhost";
                } else if ("port".equals(this.propertyNames[i])) {
                    value = String.valueOf(8000);
                }
            }
            this.textFields[i].setText(value);
        }
    }

    @Override
    protected void validateFields() {
        this.changeSupport.fireChange();
    }

    public void addRunAsInternalServerListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeRunAsInternalServerListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public RunConfigInternal createRunConfig() {
        return RunConfigInternal.create().setHostname(this.hostnameTextField.getText()).setPort(this.portTextField.getText()).setWorkDir(this.getSources()).setDocumentRoot(this.getSources()).setRouterRelativePath(this.routerTextField.getText());
    }

    public void hideRouter() {
        this.routerLabel.setVisible(false);
        this.routerTextField.setVisible(false);
        this.routerBrowseButton.setVisible(false);
    }

    public void setHostname(String hostname) {
        this.hostnameTextField.setText(hostname);
    }

    public void setPort(String port) {
        this.portTextField.setText(port);
    }

    public void setRouter(String router) {
        this.routerTextField.setText(router);
    }

    private File getSources() {
        return this.sourcesFolderProvider.getSourcesFolder();
    }

    private void initComponents() {
        this.runAsLabel = new JLabel();
        this.runAsComboBox = new JComboBox();
        this.hostnameLabel = new JLabel();
        this.hostnameTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.urlHintLabel = new JLabel();
        this.routerLabel = new JLabel();
        this.routerTextField = new JTextField();
        this.routerBrowseButton = new JButton();
        this.noteLabel = new JLabel();
        this.phpVersionInfoLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsInternalServer.class, (String)"RunAsInternalServer.runAsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.hostnameLabel, (String)NbBundle.getMessage(RunAsInternalServer.class, (String)"RunAsInternalServer.hostnameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(RunAsInternalServer.class, (String)"RunAsInternalServer.portLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.urlHintLabel, (String)" ");
        Mnemonics.setLocalizedText((JLabel)this.routerLabel, (String)NbBundle.getMessage(RunAsInternalServer.class, (String)"RunAsInternalServer.routerLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.routerBrowseButton, (String)NbBundle.getMessage(RunAsInternalServer.class, (String)"RunAsInternalServer.routerBrowseButton.text"));
        this.routerBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsInternalServer.this.routerBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(RunAsInternalServer.class, (String)"RunAsInternalServer.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpVersionInfoLabel, (String)NbBundle.getMessage(RunAsInternalServer.class, (String)"RunAsInternalServer.phpVersionInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.routerLabel).addComponent(this.portLabel).addComponent(this.runAsLabel).addComponent(this.hostnameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.routerTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.routerBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.urlHintLabel).addContainerGap()).addComponent(this.runAsComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.hostnameTextField).addGroup(layout.createSequentialGroup().addComponent(this.portTextField, -2, 50, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.phpVersionInfoLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.noteLabel).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runAsLabel).addComponent(this.runAsComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostnameLabel).addComponent(this.hostnameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.urlHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.routerLabel).addComponent(this.routerTextField, -2, -1, -2).addComponent(this.routerBrowseButton)).addGap(18, 18, 18).addComponent(this.noteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpVersionInfoLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void routerBrowseButtonActionPerformed(ActionEvent evt) {
        try {
            Utils.browseFolderFile(PhpVisibilityQuery.getDefault(), this.getSources(), this.routerTextField);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String propName, JLabel label, JTextField field) {
            super(propName, label, field);
        }

        @Override
        protected final String getDefaultValue() {
            return RunAsInternalServer.this.getDefaultValue(this.getPropName());
        }

        @Override
        protected void processUpdate() {
            super.processUpdate();
            this.updateUrlHint();
        }

        private void updateUrlHint() {
            String url = RunAsInternalServer.this.createRunConfig().getUrlHint();
            RunAsInternalServer.this.urlHintLabel.setText(url != null ? url : " ");
        }
    }
}

