/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpLanguageProperties;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.IncludePathSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.actions.DownloadCommand;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.ui.wizards.Bundle;
import org.netbeans.modules.php.project.ui.wizards.CancelablePanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.PhpFrameworksPanel;
import org.netbeans.modules.php.project.ui.wizards.RemoteConfirmationPanel;
import org.netbeans.modules.php.project.ui.wizards.RunConfigurationPanel;
import org.netbeans.modules.php.project.util.PhpProjectGenerator;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class NewPhpProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(NewPhpProjectWizardIterator.class.getName());
    private final WizardType wizardType;
    private WizardDescriptor descriptor;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private int index;

    public NewPhpProjectWizardIterator() {
        this(WizardType.NEW);
    }

    private NewPhpProjectWizardIterator(WizardType wizardType) {
        this.wizardType = wizardType;
    }

    public static NewPhpProjectWizardIterator existing() {
        return new NewPhpProjectWizardIterator(WizardType.EXISTING);
    }

    public static NewPhpProjectWizardIterator remote() {
        return new NewPhpProjectWizardIterator(WizardType.REMOTE);
    }

    public void initialize(WizardDescriptor wizard) {
        this.descriptor = wizard;
        this.index = 0;
        this.panels = this.createPanels();
        this.initDescriptor(wizard);
    }

    public void uninitialize(WizardDescriptor wizard) {
        WizardDescriptor.Panel<WizardDescriptor> current = this.current();
        if (current instanceof CancelablePanel) {
            ((CancelablePanel)current).cancel();
        }
        this.panels = null;
        this.descriptor = null;
    }

    public Set<FileObject> instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        AntProjectHelper projectHelper;
        final HashSet<FileObject> resultSet = new HashSet<FileObject>();
        final Map<PhpFrameworkProvider, PhpModuleExtender> frameworkExtenders = this.getFrameworkExtenders();
        PhpLanguageProperties.PhpVersion phpVersion = (PhpLanguageProperties.PhpVersion)((Object)this.descriptor.getProperty("phpVersion"));
        if (this.wizardType == WizardType.NEW) {
            PhpOptions.getInstance().setDefaultPhpVersion(phpVersion);
        }
        final PhpProjectGenerator.ProjectProperties createProperties = new PhpProjectGenerator.ProjectProperties().setProjectDirectory(this.getProjectDirectory()).setSourcesDirectory(NewPhpProjectWizardIterator.getSources(this.descriptor)).setName((String)this.descriptor.getProperty("projectName")).setRunAsType(this.wizardType == WizardType.REMOTE ? PhpProjectProperties.RunAsType.REMOTE : this.getRunAsType()).setPhpVersion(phpVersion).setCharset((Charset)this.descriptor.getProperty("encoding")).setUrl(this.getUrl()).setIndexFile(this.wizardType == WizardType.REMOTE ? null : this.getIndexFile(frameworkExtenders)).setDescriptor(this.descriptor).setCopySources(this.isCopyFiles()).setCopySourcesTarget(this.getCopySrcTarget()).setRemoteConfiguration((RemoteConfiguration)this.descriptor.getProperty("remoteConnection")).setRemoteDirectory((String)this.descriptor.getProperty("remoteDirectory")).setUploadFiles(this.wizardType == WizardType.REMOTE ? PhpProjectProperties.UploadFiles.ON_SAVE : (PhpProjectProperties.UploadFiles)((Object)this.descriptor.getProperty("remoteUpload"))).setHostname((String)this.descriptor.getProperty("hostname")).setPort(this.getPort()).setRouter((String)this.descriptor.getProperty("router")).setFrameworkExtenders(frameworkExtenders);
        PhpProjectGenerator.Monitor monitor = null;
        switch (this.wizardType) {
            case NEW: 
            case EXISTING: {
                monitor = new LocalProgressMonitor(handle, frameworkExtenders);
                break;
            }
            case REMOTE: {
                monitor = new RemoteProgressMonitor(handle);
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        try {
            projectHelper = PhpProjectGenerator.createProject(createProperties, monitor);
        }
        catch (IllegalArgumentException ex) {
            FileObject projDir;
            LOGGER.log(Level.WARNING, null, ex);
            this.warnUser(Bundle.NewPhpProjectWizardIterator_project_alreadyExists());
            File projectDirectory = createProperties.getProjectDirectory();
            if (projectDirectory == null) {
                projectDirectory = createProperties.getSourcesDirectory();
            }
            if ((projDir = FileUtil.toFileObject((File)projectDirectory)) != null && projDir.isValid()) {
                resultSet.add(projDir);
            }
            return resultSet;
        }
        final AntProjectHelper helper = projectHelper;
        resultSet.add(helper.getProjectDirectory());
        final Project project = ProjectManager.getDefault().findProject(helper.getProjectDirectory());
        assert (project instanceof PhpProject);
        final PhpModule phpModule = (PhpModule)project.getLookup().lookup(PhpModule.class);
        assert (phpModule != null) : "PHP module must exist!";
        FileObject sources = FileUtil.toFileObject((File)createProperties.getSourcesDirectory());
        resultSet.add(sources);
        switch (this.wizardType) {
            case NEW: {
                this.extendPhpModule(phpModule, frameworkExtenders, monitor, resultSet);
                break;
            }
            case REMOTE: {
                this.downloadRemoteFiles(createProperties, monitor);
                break;
            }
            case EXISTING: {
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws MutexException {
                    try {
                        EditableProperties projectProperties = helper.getProperties("nbproject/project.properties");
                        EditableProperties privateProperties = helper.getProperties("nbproject/private/private.properties");
                        List phpModuleProperties = NewPhpProjectWizardIterator.this.getPhpModuleProperties(phpModule, frameworkExtenders);
                        FileObject indexFile = NewPhpProjectWizardIterator.this.setIndexFile(createProperties, projectProperties, privateProperties, phpModuleProperties);
                        if (indexFile != null && indexFile.isValid()) {
                            resultSet.add(indexFile);
                        }
                        NewPhpProjectWizardIterator.this.setWebRoot(createProperties, projectProperties, privateProperties, phpModuleProperties);
                        NewPhpProjectWizardIterator.this.setTests(createProperties, projectProperties, privateProperties, phpModuleProperties);
                        NewPhpProjectWizardIterator.this.setIncludePath((PhpProject)project, createProperties, projectProperties, privateProperties, phpModuleProperties);
                        helper.putProperties("nbproject/project.properties", projectProperties);
                        helper.putProperties("nbproject/private/private.properties", privateProperties);
                        ProjectManager.getDefault().saveProject(project);
                    }
                    catch (IOException ioe) {
                        throw new MutexException((Exception)ioe);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            Exception ie = e.getException();
            if (ie instanceof IOException) {
                throw (IOException)ie;
            }
            Exceptions.printStackTrace((Throwable)e);
        }
        return resultSet;
    }

    public String name() {
        return NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_IteratorName", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        this.setTitle();
        return this.panels[this.index];
    }

    private void setTitle() {
        if (this.descriptor != null) {
            String msgKey = null;
            switch (this.wizardType) {
                case NEW: {
                    msgKey = "TXT_PhpProject";
                    break;
                }
                case EXISTING: {
                    msgKey = "TXT_ExistingPhpProject";
                    break;
                }
                case REMOTE: {
                    msgKey = "TXT_RemotePhpProject";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown wizard type: " + (Object)((Object)this.wizardType));
                }
            }
            this.descriptor.putProperty("NewProjectWizard_Title", (Object)NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)msgKey));
        }
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
        String step2 = null;
        String step3 = null;
        switch (this.wizardType) {
            case NEW: {
                step2 = "LBL_RunConfiguration";
                step3 = "LBL_Frameworks";
                break;
            }
            case EXISTING: {
                step2 = "LBL_RunConfiguration";
                break;
            }
            case REMOTE: {
                step2 = "LBL_RemoteConfiguration";
                step3 = "LBL_RemoteConfirmation";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown wizard type: " + (Object)((Object)this.wizardType));
            }
        }
        ArrayList<String> steps = new ArrayList<String>(3);
        steps.add(NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_ProjectNameLocation"));
        steps.add(NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)step2));
        if (step3 != null) {
            steps.add(NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)step3));
        }
        String[] stepsArray = steps.toArray(new String[steps.size()]);
        WizardDescriptor.Panel<WizardDescriptor> panel3 = null;
        switch (this.wizardType) {
            case NEW: {
                panel3 = new PhpFrameworksPanel(stepsArray);
                break;
            }
            case EXISTING: {
                break;
            }
            case REMOTE: {
                panel3 = new RemoteConfirmationPanel(stepsArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown wizard type: " + (Object)((Object)this.wizardType));
            }
        }
        ConfigureProjectPanel configureProjectPanel = new ConfigureProjectPanel(stepsArray, this.wizardType);
        ArrayList<Object> pnls = new ArrayList<Object>(steps.size());
        pnls.add(configureProjectPanel);
        pnls.add(new RunConfigurationPanel(stepsArray, configureProjectPanel, this.wizardType));
        if (panel3 != null) {
            pnls.add(panel3);
        }
        WizardDescriptor.Panel[] pnlsArray = (WizardDescriptor.Panel[])Array.newInstance(WizardDescriptor.Panel.class, pnls.size());
        return pnls.toArray(pnlsArray);
    }

    private void initDescriptor(WizardDescriptor settings) {
        settings.putProperty("isProjectDirUsed", null);
        settings.putProperty("projectDir", null);
        settings.putProperty("projectName", null);
        settings.putProperty("sourcesFolder", null);
        settings.putProperty("localServers", null);
        settings.putProperty("phpVersion", null);
        settings.putProperty("encoding", null);
        settings.putProperty("RunConfigurationPanel.valid", null);
        settings.putProperty("run.as", null);
        settings.putProperty("copySrcFiles", null);
        settings.putProperty("copySrcTarget", null);
        settings.putProperty("copySrcTargets", null);
        settings.putProperty("url", null);
        settings.putProperty("indexFile", null);
        settings.putProperty("remoteConnection", null);
        settings.putProperty("remoteDirectory", null);
        settings.putProperty("remoteUpload", null);
        settings.putProperty("hostname", null);
        settings.putProperty("port", null);
        settings.putProperty("router", null);
        settings.putProperty("PhpFrameworksPanel.valid", null);
        settings.putProperty("frameworks", null);
        settings.putProperty("remoteFiles", null);
        settings.putProperty("remoteClient", null);
    }

    private File getProjectDirectory() {
        Boolean isProjectDirUsed = (Boolean)this.descriptor.getProperty("isProjectDirUsed");
        if (isProjectDirUsed != null && isProjectDirUsed.booleanValue()) {
            return (File)this.descriptor.getProperty("projectDir");
        }
        return null;
    }

    static File getSources(WizardDescriptor descriptor) {
        LocalServer localServer = (LocalServer)descriptor.getProperty("sourcesFolder");
        if (localServer != null) {
            return new File(localServer.getSrcRoot());
        }
        return null;
    }

    private PhpProjectProperties.RunAsType getRunAsType() {
        return (PhpProjectProperties.RunAsType)((Object)this.descriptor.getProperty("run.as"));
    }

    private String getUrl() {
        String url = (String)this.descriptor.getProperty("url");
        if (url == null) {
            url = RunConfigurationPanel.getUrlForSources(this.wizardType, this.descriptor);
        }
        return url;
    }

    private String getIndexFile(Map<PhpFrameworkProvider, PhpModuleExtender> frameworkProviders) {
        if (frameworkProviders != null && !frameworkProviders.isEmpty()) {
            return null;
        }
        String indexName = (String)this.descriptor.getProperty("indexFile");
        if (indexName == null) {
            indexName = "index.php";
        }
        return indexName;
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private Boolean isCopyFiles() {
        PhpProjectProperties.RunAsType runAs = this.getRunAsType();
        if (runAs == null) {
            return null;
        }
        boolean copyFiles = false;
        switch (runAs) {
            case LOCAL: {
                Boolean tmp = (Boolean)this.descriptor.getProperty("copySrcFiles");
                if (tmp == null || !tmp.booleanValue()) break;
                copyFiles = true;
                break;
            }
        }
        return copyFiles;
    }

    private File getCopySrcTarget() {
        if (this.getRunAsType() == null) {
            return null;
        }
        LocalServer localServer = (LocalServer)this.descriptor.getProperty("copySrcTarget");
        if (StringUtils.hasText((String)localServer.getSrcRoot())) {
            return new File(localServer.getSrcRoot());
        }
        return null;
    }

    private Integer getPort() {
        String port = (String)this.descriptor.getProperty("port");
        if (port == null) {
            return null;
        }
        return Integer.valueOf(port);
    }

    private void extendPhpModule(PhpModule phpModule, Map<PhpFrameworkProvider, PhpModuleExtender> frameworkExtenders, PhpProjectGenerator.Monitor monitor, Set<FileObject> filesToOpen) {
        assert (this.wizardType == WizardType.NEW) : "Extending not allowed for: " + (Object)((Object)this.wizardType);
        assert (monitor instanceof LocalProgressMonitor);
        LocalProgressMonitor localMonitor = (LocalProgressMonitor)monitor;
        if (!frameworkExtenders.isEmpty()) {
            localMonitor.startingExtending();
            for (Map.Entry<PhpFrameworkProvider, PhpModuleExtender> entry : frameworkExtenders.entrySet()) {
                PhpFrameworkProvider frameworkProvider = entry.getKey();
                assert (frameworkProvider != null);
                localMonitor.extending(frameworkProvider.getName());
                PhpModuleExtender phpModuleExtender = entry.getValue();
                if (phpModuleExtender == null) continue;
                try {
                    Set newFiles = phpModuleExtender.extend(phpModule);
                    assert (newFiles != null);
                    filesToOpen.addAll(newFiles);
                }
                catch (PhpModuleExtender.ExtendingException ex) {
                    this.warnUser(ex.getFailureMessage());
                }
            }
        }
        localMonitor.finishingExtending();
    }

    private void warnUser(String message) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    private Set<TransferFile> getRemoteFiles() {
        return (Set)this.descriptor.getProperty("remoteFiles");
    }

    private RemoteClient getRemoteClient() {
        return (RemoteClient)this.descriptor.getProperty("remoteClient");
    }

    private void downloadRemoteFiles(PhpProjectGenerator.ProjectProperties projectProperties, PhpProjectGenerator.Monitor monitor) {
        assert (this.wizardType == WizardType.REMOTE) : "Download not allowed for: " + (Object)((Object)this.wizardType);
        assert (monitor instanceof RemoteProgressMonitor) : "RemoteProgressMonitor expected but is: " + monitor;
        Set<TransferFile> forDownload = this.getRemoteFiles();
        assert (forDownload != null);
        assert (!forDownload.isEmpty());
        RemoteClient remoteClient = this.getRemoteClient();
        assert (remoteClient != null);
        remoteClient.reset();
        RemoteProgressMonitor remoteMonitor = (RemoteProgressMonitor)monitor;
        remoteMonitor.startingDownload();
        FileObject sources = FileUtil.toFileObject((File)projectProperties.getSourcesDirectory());
        InputOutput remoteLog = RemoteCommand.getRemoteLog(projectProperties.getRemoteConfiguration().getDisplayName());
        DownloadCommand.download(remoteClient, remoteLog, projectProperties.getName(), sources, forDownload);
        remoteMonitor.finishingDownload();
    }

    private Map<PhpFrameworkProvider, PhpModuleExtender> getFrameworkExtenders() {
        Map<PhpFrameworkProvider, PhpModuleExtender> frameworkProviders = (Map<PhpFrameworkProvider, PhpModuleExtender>)this.descriptor.getProperty("frameworks");
        if (frameworkProviders == null) {
            frameworkProviders = Collections.emptyMap();
        }
        return frameworkProviders;
    }

    private List<PhpModuleProperties> getPhpModuleProperties(PhpModule phpModule, Map<PhpFrameworkProvider, PhpModuleExtender> frameworkExtenders) {
        if (frameworkExtenders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PhpModuleProperties> phpModuleProperties = new ArrayList<PhpModuleProperties>(frameworkExtenders.size());
        for (PhpFrameworkProvider frameworkProvider : frameworkExtenders.keySet()) {
            phpModuleProperties.add(frameworkProvider.getPhpModuleProperties(phpModule));
        }
        return phpModuleProperties;
    }

    private FileObject setIndexFile(PhpProjectGenerator.ProjectProperties createProperties, EditableProperties projectProperties, EditableProperties privateProperties, List<PhpModuleProperties> phpModuleProperties) {
        String indexFile = createProperties.getIndexFile();
        block0 : switch (this.wizardType) {
            case NEW: {
                if (indexFile != null) break;
                for (PhpModuleProperties properties : phpModuleProperties) {
                    FileObject frameworkIndex = properties.getIndexFile();
                    if (frameworkIndex == null) continue;
                    indexFile = PropertyUtils.relativizeFile((File)createProperties.getSourcesDirectory(), (File)FileUtil.toFile((FileObject)frameworkIndex));
                    assert (indexFile != null && !indexFile.startsWith("../")) : "Unexpected index file: " + indexFile;
                    break block0;
                }
                break;
            }
            case REMOTE: {
                indexFile = this.getIndexFile(null);
                break;
            }
            case EXISTING: {
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        if (indexFile == null) {
            return null;
        }
        if (!PhpProjectProperties.RunAsType.INTERNAL.equals((Object)this.getRunAsType())) {
            privateProperties.setProperty("index.file", indexFile);
        }
        return FileUtil.toFileObject((File)createProperties.getSourcesDirectory()).getFileObject(indexFile);
    }

    private void setWebRoot(PhpProjectGenerator.ProjectProperties createProperties, EditableProperties projectProperties, EditableProperties privateProperties, List<PhpModuleProperties> phpModuleProperties) {
        for (PhpModuleProperties properties : phpModuleProperties) {
            FileObject webRoot = properties.getWebRoot();
            if (webRoot == null) continue;
            String relPath = PropertyUtils.relativizeFile((File)createProperties.getSourcesDirectory(), (File)FileUtil.toFile((FileObject)webRoot));
            assert (relPath != null && !relPath.startsWith("../")) : "WebRoot must be underneath Sources";
            projectProperties.setProperty("web.root", relPath);
            break;
        }
    }

    private void setTests(PhpProjectGenerator.ProjectProperties createProperties, EditableProperties projectProperties, EditableProperties privateProperties, List<PhpModuleProperties> phpModuleProperties) {
        if (phpModuleProperties.isEmpty()) {
            return;
        }
        File projectDir = createProperties.getProjectDirectory();
        if (projectDir == null) {
            projectDir = createProperties.getSourcesDirectory();
        }
        assert (projectDir != null);
        for (PhpModuleProperties properties : phpModuleProperties) {
            FileObject tests = properties.getTests();
            if (tests == null) continue;
            File testDir = FileUtil.toFile((FileObject)tests);
            String testPath = PropertyUtils.relativizeFile((File)projectDir, (File)testDir);
            if (testPath == null) {
                testPath = testDir.getAbsolutePath();
            }
            projectProperties.setProperty("test.src.dir", testPath);
            break;
        }
    }

    private void setIncludePath(PhpProject project, PhpProjectGenerator.ProjectProperties createProperties, EditableProperties projectProperties, EditableProperties privateProperties, List<PhpModuleProperties> phpModuleProperties) {
        if (phpModuleProperties.isEmpty()) {
            return;
        }
        for (PhpModuleProperties properties : phpModuleProperties) {
            List customIncludePath = properties.getIncludePath();
            if (customIncludePath == null || customIncludePath.isEmpty()) continue;
            LinkedHashSet<String> includePath = new LinkedHashSet<String>();
            String current = projectProperties.getProperty("include.path");
            if (StringUtils.hasText((String)current)) {
                includePath.add(current);
            }
            includePath.addAll(customIncludePath);
            IncludePathSupport includePathSupport = new IncludePathSupport(ProjectPropertiesSupport.getPropertyEvaluator(project), project.getRefHelper(), project.getHelper());
            Iterator<BasePathSupport.Item> itemsIterator = includePathSupport.itemsIterator(StringUtils.implode(new ArrayList(includePath), (String)":"));
            String[] encoded = includePathSupport.encodeToStrings(itemsIterator);
            projectProperties.setProperty("include.path", encoded);
        }
    }

    private static final class RemoteProgressMonitor
    implements PhpProjectGenerator.Monitor {
        private final ProgressHandle handle;

        public RemoteProgressMonitor(ProgressHandle handle) {
            assert (handle != null);
            this.handle = handle;
        }

        @Override
        public void starting() {
            this.handle.start(10);
            String msg = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_CreatingProject");
            this.handle.progress(msg, 2);
        }

        @Override
        public void creatingIndexFile() {
            assert (false) : "Should not get here";
        }

        @Override
        public void finishing() {
        }

        public void startingDownload() {
            String msg = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_StartingDownload");
            this.handle.progress(msg, 5);
        }

        public void finishingDownload() {
            String msg = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_PreparingToOpen");
            this.handle.progress(msg, 10);
        }
    }

    private static final class LocalProgressMonitor
    implements PhpProjectGenerator.Monitor {
        private final ProgressHandle handle;
        private final int units;
        private int unit = 0;

        private LocalProgressMonitor(ProgressHandle handle, Map<PhpFrameworkProvider, PhpModuleExtender> frameworkExtenders) {
            assert (handle != null);
            assert (frameworkExtenders != null);
            this.handle = handle;
            this.units = 5 + 2 * frameworkExtenders.size();
        }

        @Override
        public void starting() {
            this.handle.start(this.units);
            String msg = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_CreatingProject");
            this.handle.progress(msg, 2);
        }

        @Override
        public void creatingIndexFile() {
            String msg = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_CreatingIndexFile");
            this.handle.progress(msg, 4);
        }

        @Override
        public void finishing() {
        }

        public void startingExtending() {
            this.unit = 5;
            String msg = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_StartingExtending");
            this.handle.progress(msg, this.unit);
        }

        public void extending(String framework) {
            this.unit += 2;
            String msg = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_Extending", (Object)framework);
            this.handle.progress(msg, this.unit);
        }

        public void finishingExtending() {
            String msg = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_PreparingToOpen");
            this.handle.progress(msg, this.units);
        }
    }

    public static enum WizardType {
        NEW,
        EXISTING,
        REMOTE;

    }
}

