/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public final class NewFileWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(NewFileWizardIterator.class.getName());
    private static final long serialVersionUID = 2262026971167469147L;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel<WizardDescriptor>[] wizardPanels;
    private int index;

    public Set<FileObject> instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)dir);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        DataObject createdFile = dataTemplate.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.wizard), Collections.singletonMap("freeFileExtension", true));
        try {
            PhpProjectUtils.reformatFile(createdFile);
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, exc.getMessage(), exc);
        }
        return Collections.singleton(createdFile.getPrimaryFile());
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.checkPhpProject();
        this.setTargetFolder();
        this.wizardPanels = this.getPanels();
        String[] beforeSteps = (String[])wizard.getProperty("WizardPanel_contentData");
        int beforeStepLength = beforeSteps.length - 1;
        String[] steps = this.createSteps(beforeSteps);
        for (int i = 0; i < this.wizardPanels.length; ++i) {
            Component c = this.wizardPanels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i + beforeStepLength - 1);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private void checkPhpProject() {
        PhpProject phpProject = this.getPhpProject();
        if (phpProject == null) {
            return;
        }
        if (PhpProjectValidator.isFatallyBroken(phpProject)) {
            Utils.warnInvalidSourcesDirectory(phpProject);
        }
    }

    private void setTargetFolder() {
        if (Templates.getTargetFolder((WizardDescriptor)this.wizard) != null) {
            return;
        }
        PhpProject phpProject = this.getPhpProject();
        if (phpProject == null) {
            return;
        }
        FileObject srcDir = ProjectPropertiesSupport.getSourcesDirectory(phpProject);
        if (srcDir != null && srcDir.isValid()) {
            Templates.setTargetFolder((WizardDescriptor)this.wizard, (FileObject)srcDir);
        }
    }

    private PhpProject getPhpProject() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (project == null) {
            return null;
        }
        if (!(project instanceof PhpProject)) {
            LOGGER.log(Level.WARNING, "PHP project expected but found {0}", project.getClass().getName());
            return null;
        }
        return (PhpProject)project;
    }

    private String[] createSteps(String[] beforeSteps) {
        int beforeStepLength = beforeSteps.length - 1;
        String[] res = new String[beforeStepLength + this.wizardPanels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeStepLength ? beforeSteps[i] : this.wizardPanels[i - beforeStepLength].getComponent().getName();
        }
        return res;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.wizardPanels = null;
    }

    public String name() {
        return "";
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.wizardPanels[this.index];
    }

    public boolean hasNext() {
        return this.index < this.wizardPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        SourceGroup[] groups = PhpProjectUtils.getSourceGroups(project);
        PhpProject phpProject = this.getPhpProject();
        if (phpProject != null && groups != null && groups.length == 0 && !PhpProjectValidator.isFatallyBroken(phpProject)) {
            FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(phpProject);
            FileObject tests = ProjectPropertiesSupport.getTestDirectory(phpProject, false);
            FileObject selenium = ProjectPropertiesSupport.getSeleniumDirectory(phpProject, false);
            SourceRoots sourceRoots = phpProject.getSourceRoots();
            SourceRoots testRoots = phpProject.getTestRoots();
            SourceRoots seleniumRoots = phpProject.getSeleniumRoots();
            StringBuilder sb = new StringBuilder(200);
            this.addDiagnosticForDirs(sb, phpProject, sources, tests, selenium);
            this.addDiagnosticForRoots(sb, sourceRoots, testRoots, seleniumRoots);
            LOGGER.log(Level.WARNING, sb.toString(), new IllegalStateException("No source roots found (attach your IDE log to https://netbeans.org/bugzilla/show_bug.cgi?id=218437)"));
            sourceRoots.fireChange();
            testRoots.fireChange();
            seleniumRoots.fireChange();
            sb = new StringBuilder(200);
            this.addDiagnosticForRoots(sb, sourceRoots, testRoots, seleniumRoots);
            LOGGER.log(Level.WARNING, sb.toString(), new IllegalStateException("Trying to fire changes for all source roots"));
            groups = PhpProjectUtils.getSourceGroups(project);
        }
        WizardDescriptor.Panel simpleTargetChooserPanel = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])groups).freeFileExtension().create();
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{simpleTargetChooserPanel};
        return panels;
    }

    private void addDiagnosticForDirs(StringBuilder sb, PhpProject project, FileObject sources, FileObject tests, FileObject selenium) {
        sb.append("project directory equals sources: ");
        sb.append(project.getProjectDirectory().equals(sources));
        sb.append(";\n sources (not null, valid): ");
        sb.append(sources != null);
        sb.append(", ");
        sb.append(sources != null && sources.isValid());
        sb.append(";\n tests (not null, valid): ");
        sb.append(tests != null);
        sb.append(", ");
        sb.append(tests != null && tests.isValid());
        sb.append(";\n selenium (not null, valid): ");
        sb.append(selenium != null);
        sb.append(", ");
        sb.append(selenium != null && selenium.isValid());
    }

    private void addDiagnosticForRoots(StringBuilder sb, SourceRoots sourceRoots, SourceRoots testRoots, SourceRoots seleniumRoots) {
        sb.append(";\n sourceRoots (fired changes): ");
        sb.append(Arrays.asList(sourceRoots.getRoots()));
        sb.append(" (");
        sb.append(sourceRoots.getFiredChanges());
        sb.append(");\n testRoots (fired changes): ");
        sb.append(Arrays.asList(testRoots.getRoots()));
        sb.append(" (");
        sb.append(testRoots.getFiredChanges());
        sb.append(");\n seleniumRoots (fired changes): ");
        sb.append(Arrays.asList(seleniumRoots.getRoots()));
        sb.append(" (");
        sb.append(seleniumRoots.getFiredChanges());
        sb.append(")");
    }
}

