/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.testrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.input.LineProcessors;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.phpunit.PhpUnitTestRunInfo;
import org.netbeans.modules.php.project.ui.testrunner.PhpTestRunnerNodeFactory;
import org.netbeans.modules.php.project.ui.testrunner.PhpUnitLogParser;
import org.netbeans.modules.php.project.ui.testrunner.TestSessionVO;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.OutputWriter;

public final class UnitTestRunner {
    private static final Logger LOGGER = Logger.getLogger(UnitTestRunner.class.getName());
    private static final Manager MANAGER = Manager.getInstance();
    private static final PhpOutputLineHandler PHP_OUTPUT_LINE_HANDLER = new PhpOutputLineHandler();
    private final PhpProject project;
    private final TestSession testSession;
    private final PhpUnitTestRunInfo info;
    private volatile boolean started = false;

    public UnitTestRunner(PhpProject project, TestSession.SessionType sessionType, RerunHandler rerunHandler, PhpUnitTestRunInfo info) {
        assert (project != null);
        assert (sessionType != null);
        assert (rerunHandler != null);
        assert (info != null);
        this.project = project;
        this.info = info;
        this.testSession = new TestSession(this.getOutputTitle(project, info), (Project)project, sessionType, (TestRunnerNodeFactory)new PhpTestRunnerNodeFactory());
        this.testSession.setRerunHandler(rerunHandler);
        this.testSession.setOutputLineHandler((OutputLineHandler)PHP_OUTPUT_LINE_HANDLER);
    }

    public void start() {
        MANAGER.testStarted(this.testSession);
        this.started = true;
        this.deleteOldLogFiles();
    }

    public void showResults() {
        File customSuite;
        if (!this.started) {
            throw new IllegalStateException("Test runner must be started. Call start() method first.");
        }
        TestSessionVO session = this.createTestSession();
        if (session == null) {
            return;
        }
        if (this.info.allTests() && (customSuite = PhpUnit.getCustomSuite(this.project)) != null) {
            MANAGER.displayOutput(this.testSession, NbBundle.getMessage(UnitTestRunner.class, (String)"MSG_CustomSuiteUsed", (Object)customSuite.getAbsolutePath()), false);
            MANAGER.displayOutput(this.testSession, "", false);
        }
        for (TestSessionVO.TestSuiteVO suite : session.getTestSuites()) {
            MANAGER.displaySuiteRunning(this.testSession, suite.getName());
            TestSuite testSuite = new TestSuite(suite.getName());
            this.testSession.addSuite(testSuite);
            for (TestSessionVO.TestCaseVO kase : suite.getTestCases()) {
                Testcase testCase = new Testcase(kase.getName(), "PHPUnit test case", this.testSession);
                testCase.setTimeMillis(kase.getTime());
                testCase.setStatus(kase.getStatus());
                String[] stacktrace = kase.getStacktrace();
                if (stacktrace.length > 0) {
                    boolean isError = kase.isError();
                    Trouble trouble = new Trouble(isError);
                    trouble.setStackTrace(stacktrace);
                    TestSessionVO.TestCaseVO.Diff diff = kase.getDiff();
                    if (diff.isValid()) {
                        Trouble.ComparisonFailure failure = new Trouble.ComparisonFailure(diff.expected, diff.actual);
                        trouble.setComparisonFailure(failure);
                    }
                    testCase.setTrouble(trouble);
                    MANAGER.displayOutput(this.testSession, suite.getName() + "::" + kase.getName() + "()", isError);
                    this.testSession.addOutput("<u>" + kase.getName() + ":</u>");
                    for (String s : stacktrace) {
                        MANAGER.displayOutput(this.testSession, s, isError);
                        this.testSession.addOutput(s.replace("<", "&lt;"));
                    }
                    MANAGER.displayOutput(this.testSession, "", false);
                    this.testSession.addOutput("");
                }
                this.testSession.addTestCase(testCase);
            }
            MANAGER.displayReport(this.testSession, this.testSession.getReport(suite.getTime()));
        }
        MANAGER.displayOutput(this.testSession, NbBundle.getMessage(UnitTestRunner.class, (String)"MSG_OutputInOutput"), false);
        MANAGER.sessionFinished(this.testSession);
    }

    private void processPhpUnitError() {
        LOGGER.info(String.format("File %s not found or cannot be parsed. If there are no errors in PHPUnit output (verify in Output window), please report an issue (http://www.netbeans.org/issues/).", PhpUnit.XML_LOG));
        MANAGER.displayOutput(this.testSession, NbBundle.getMessage(UnitTestRunner.class, (String)"MSG_PerhapsError"), true);
        MANAGER.sessionFinished(this.testSession);
    }

    private void deleteOldLogFiles() {
        if (PhpUnit.XML_LOG.exists() && !PhpUnit.XML_LOG.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete PHPUnit log {0}", PhpUnit.XML_LOG);
        }
        if (PhpUnit.COVERAGE_LOG.exists() && !PhpUnit.COVERAGE_LOG.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete code coverage log {0}", PhpUnit.COVERAGE_LOG);
        }
    }

    private TestSessionVO createTestSession() {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(PhpUnit.XML_LOG), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (FileNotFoundException ex) {
            this.processPhpUnitError();
            return null;
        }
        TestSessionVO session = new TestSessionVO();
        boolean parsed = PhpUnitLogParser.parse(reader, session);
        if (!PhpUnit.KEEP_LOGS && !PhpUnit.XML_LOG.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete PHPUnit log {0}", PhpUnit.XML_LOG);
        }
        if (!parsed) {
            this.processPhpUnitError();
            return null;
        }
        return session;
    }

    private String getOutputTitle(PhpProject project, PhpUnitTestRunInfo info) {
        StringBuilder sb = new StringBuilder(30);
        sb.append(project.getName());
        String testName = info.getTestName();
        if (testName != null) {
            sb.append(":");
            sb.append(testName);
        }
        return sb.toString();
    }

    private static final class PhpOutputLineHandler
    implements OutputLineHandler {
        private static final LineConvertor CONVERTOR = LineConvertors.filePattern(null, (Pattern)PhpUnit.LINE_PATTERN, null, (int)1, (int)2);

        private PhpOutputLineHandler() {
        }

        public void handleLine(OutputWriter out, String text) {
            LineProcessors.printing((OutputWriter)out, (LineConvertor)CONVERTOR, (boolean)true).processLine(text);
        }
    }
}

