/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.io.IOException;
import java.util.List;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.PhpPreferences;
import org.netbeans.modules.php.project.api.PhpLanguageProperties;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.phpunit.PhpUnitSkelGen;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Exceptions;

public final class PhpOptions {
    private static final String PREFERENCES_PATH = "general";
    public static final int DEFAULT_DEBUGGER_PORT = 9000;
    public static final String DEFAULT_DEBUGGER_SESSION_ID = "netbeans-xdebug";
    public static final int DEFAULT_DEBUGGER_MAX_STRUCTURES_DEPTH = 3;
    public static final int DEFAULT_DEBUGGER_MAX_CHILDREN = 30;
    public static final boolean DEFAULT_DEBUGGER_SHOW_URLS = false;
    public static final boolean DEFAULT_DEBUGGER_SHOW_CONSOLE = false;
    public static final boolean DEFAULT_DEBUGGER_STOP_AT_FIRST_LINE = true;
    public static final boolean DEFAULT_DEBUGGER_WATCHES_AND_EVAL = false;
    public static final String PHP_INTERPRETER = "phpInterpreter";
    public static final String PHP_OPEN_IN_OUTPUT = "phpOpenInOutput";
    public static final String PHP_OPEN_IN_BROWSER = "phpOpenInBrowser";
    public static final String PHP_OPEN_IN_EDITOR = "phpOpenInEditor";
    public static final String PHP_DEBUGGER_PORT = "phpDebuggerPort";
    public static final String PHP_DEBUGGER_SESSION_ID = "phpDebuggerSessionId";
    public static final String PHP_DEBUGGER_MAX_STRUCTURES_DEPTH = "phpDebuggerMaxStructuresDepth";
    public static final String PHP_DEBUGGER_MAX_CHILDREN = "phpDebuggerMaxChildren";
    public static final String PHP_DEBUGGER_STOP_AT_FIRST_LINE = "phpDebuggerStopAtFirstLine";
    public static final String PHP_DEBUGGER_WATCHES_AND_EVAL = "phpDebuggerWatchesAndEval";
    public static final String PHP_DEBUGGER_SHOW_URLS = "phpDebuggerShowUrls";
    public static final String PHP_DEBUGGER_SHOW_CONSOLE = "phpDebuggerShowConsole";
    public static final String PHP_UNIT = "phpUnit";
    public static final String PHP_UNIT_SKEL_GEN = "phpUnitSkelGen.path";
    public static final String PHP_GLOBAL_INCLUDE_PATH = "phpGlobalIncludePath";
    private static final String DEFAULT_PHP_VERSION = "defaultPhpVersion";
    private static final String REMOTE_SYNC_SHOW_SUMMARY = "remote.sync.showSummary";
    private static final PhpOptions INSTANCE = new PhpOptions();
    private volatile boolean phpInterpreterSearched = false;
    private volatile boolean phpUnitSearched = false;
    private volatile boolean phpUnitSkelGenSearched = false;
    private volatile boolean phpGlobalIncludePathEnsured = false;

    private PhpOptions() {
    }

    public static PhpOptions getInstance() {
        return INSTANCE;
    }

    private Preferences getPreferences() {
        return PhpPreferences.getPreferences(true).node(PREFERENCES_PATH);
    }

    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.getPreferences().addPreferenceChangeListener(preferenceChangeListener);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.getPreferences().removePreferenceChangeListener(preferenceChangeListener);
    }

    public synchronized String getPhpInterpreter() {
        String phpInterpreter = this.getPreferences().get(PHP_INTERPRETER, null);
        if (phpInterpreter == null && !this.phpInterpreterSearched) {
            this.phpInterpreterSearched = true;
            phpInterpreter = PhpEnvironment.get().getAnyPhpInterpreter();
            if (phpInterpreter != null) {
                this.setPhpInterpreter(phpInterpreter);
            }
        }
        return phpInterpreter;
    }

    public void setPhpInterpreter(String phpInterpreter) {
        this.getPreferences().put(PHP_INTERPRETER, phpInterpreter);
    }

    public synchronized String getPhpUnit() {
        String phpUnit = this.getPreferences().get(PHP_UNIT, null);
        if (phpUnit == null && !this.phpUnitSearched) {
            this.phpUnitSearched = true;
            phpUnit = PhpEnvironment.get().getAnyPhpUnit();
            if (phpUnit != null) {
                this.setPhpUnit(phpUnit);
            }
        }
        return phpUnit;
    }

    public void setPhpUnit(String phpUnit) {
        this.getPreferences().put(PHP_UNIT, phpUnit);
    }

    public synchronized String getPhpUnitSkelGen() {
        String phpUnitSkelGen = this.getPreferences().get(PHP_UNIT_SKEL_GEN, null);
        if (phpUnitSkelGen == null && !this.phpUnitSkelGenSearched) {
            this.phpUnitSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"phpunit-skelgen", PhpUnitSkelGen.SCRIPT_NAME_LONG});
            if (!scripts.isEmpty()) {
                phpUnitSkelGen = (String)scripts.get(0);
                this.setPhpUnitSkelGen(phpUnitSkelGen);
            }
        }
        return phpUnitSkelGen;
    }

    public void setPhpUnitSkelGen(String phpUnitSkelGen) {
        this.getPreferences().put(PHP_UNIT_SKEL_GEN, phpUnitSkelGen);
    }

    public boolean isOpenResultInOutputWindow() {
        return this.getPreferences().getBoolean(PHP_OPEN_IN_OUTPUT, true);
    }

    public void setOpenResultInOutputWindow(boolean openResultInOutputWindow) {
        this.getPreferences().putBoolean(PHP_OPEN_IN_OUTPUT, openResultInOutputWindow);
    }

    public boolean isOpenResultInBrowser() {
        return this.getPreferences().getBoolean(PHP_OPEN_IN_BROWSER, false);
    }

    public void setOpenResultInBrowser(boolean openResultInBrowser) {
        this.getPreferences().putBoolean(PHP_OPEN_IN_BROWSER, openResultInBrowser);
    }

    public boolean isOpenResultInEditor() {
        return this.getPreferences().getBoolean(PHP_OPEN_IN_EDITOR, false);
    }

    public void setOpenResultInEditor(boolean openResultInEditor) {
        this.getPreferences().putBoolean(PHP_OPEN_IN_EDITOR, openResultInEditor);
    }

    public int getDebuggerPort() {
        return this.getPreferences().getInt(PHP_DEBUGGER_PORT, 9000);
    }

    public void setDebuggerPort(int debuggerPort) {
        this.getPreferences().putInt(PHP_DEBUGGER_PORT, debuggerPort);
    }

    public String getDebuggerSessionId() {
        return this.getPreferences().get(PHP_DEBUGGER_SESSION_ID, DEFAULT_DEBUGGER_SESSION_ID);
    }

    public void setDebuggerSessionId(String sessionId) {
        this.getPreferences().put(PHP_DEBUGGER_SESSION_ID, sessionId);
    }

    public int getDebuggerMaxStructuresDepth() {
        return this.getPreferences().getInt(PHP_DEBUGGER_MAX_STRUCTURES_DEPTH, 3);
    }

    public void setDebuggerMaxStructuresDepth(int debuggerMaxStructuresDepth) {
        this.getPreferences().putInt(PHP_DEBUGGER_MAX_STRUCTURES_DEPTH, debuggerMaxStructuresDepth);
    }

    public int getDebuggerMaxChildren() {
        return this.getPreferences().getInt(PHP_DEBUGGER_MAX_CHILDREN, 30);
    }

    public void setDebuggerMaxChildren(int debuggerMaxChildren) {
        this.getPreferences().putInt(PHP_DEBUGGER_MAX_CHILDREN, debuggerMaxChildren);
    }

    public boolean isDebuggerStoppedAtTheFirstLine() {
        return this.getPreferences().getBoolean(PHP_DEBUGGER_STOP_AT_FIRST_LINE, true);
    }

    public void setDebuggerStoppedAtTheFirstLine(boolean debuggerStoppedAtTheFirstLine) {
        this.getPreferences().putBoolean(PHP_DEBUGGER_STOP_AT_FIRST_LINE, debuggerStoppedAtTheFirstLine);
    }

    public boolean isDebuggerWatchesAndEval() {
        return this.getPreferences().getBoolean(PHP_DEBUGGER_WATCHES_AND_EVAL, false);
    }

    public void setDebuggerWatchesAndEval(boolean debuggerWatchesAndEval) {
        this.getPreferences().putBoolean(PHP_DEBUGGER_WATCHES_AND_EVAL, debuggerWatchesAndEval);
    }

    public boolean isDebuggerShowUrls() {
        return this.getPreferences().getBoolean(PHP_DEBUGGER_SHOW_URLS, false);
    }

    public void setDebuggerShowUrls(boolean debuggerShowUrls) {
        this.getPreferences().putBoolean(PHP_DEBUGGER_SHOW_URLS, debuggerShowUrls);
    }

    public boolean isDebuggerShowConsole() {
        return this.getPreferences().getBoolean(PHP_DEBUGGER_SHOW_CONSOLE, false);
    }

    public void setDebuggerShowConsole(boolean debuggerShowConsole) {
        this.getPreferences().putBoolean(PHP_DEBUGGER_SHOW_CONSOLE, debuggerShowConsole);
    }

    public String getPhpGlobalIncludePath() {
        return this.getPreferences().get(PHP_GLOBAL_INCLUDE_PATH, "");
    }

    public String[] getPhpGlobalIncludePathAsArray() {
        return PropertyUtils.tokenizePath((String)this.getPhpGlobalIncludePath());
    }

    public void setPhpGlobalIncludePath(String phpGlobalIncludePath) {
        this.getPreferences().put(PHP_GLOBAL_INCLUDE_PATH, phpGlobalIncludePath);
        EditableProperties globalProperties = PropertyUtils.getGlobalProperties();
        globalProperties.setProperty("php.global.include.path", phpGlobalIncludePath);
        try {
            PropertyUtils.putGlobalProperties((EditableProperties)globalProperties);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void ensurePhpGlobalIncludePath() {
        if (this.phpGlobalIncludePathEnsured) {
            return;
        }
        this.phpGlobalIncludePathEnsured = true;
        String phpGlobalIncludePath = this.getPhpGlobalIncludePath();
        if (!phpGlobalIncludePath.equals(PropertyUtils.getGlobalProperties().getProperty("php.global.include.path"))) {
            this.setPhpGlobalIncludePath(phpGlobalIncludePath);
        }
    }

    public PhpLanguageProperties.PhpVersion getDefaultPhpVersion() {
        String defaultPhpVersion = this.getPreferences().get(DEFAULT_PHP_VERSION, null);
        if (defaultPhpVersion != null) {
            try {
                return PhpLanguageProperties.PhpVersion.valueOf(defaultPhpVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return PhpLanguageProperties.PhpVersion.getDefault();
    }

    public void setDefaultPhpVersion(PhpLanguageProperties.PhpVersion phpVersion) {
        this.getPreferences().put(DEFAULT_PHP_VERSION, phpVersion.name());
    }

    public boolean getRemoteSyncShowSummary() {
        return this.getPreferences().getBoolean(REMOTE_SYNC_SHOW_SUMMARY, true);
    }

    public void setRemoteSyncShowSummary(boolean showSummary) {
        this.getPreferences().putBoolean(REMOTE_SYNC_SHOW_SUMMARY, showSummary);
    }
}

