/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.annotations.UserAnnotationPanel;
import org.netbeans.modules.php.project.annotations.UserAnnotationTag;
import org.netbeans.modules.php.project.ui.options.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PhpAnnotationsPanel
extends JPanel {
    private static final long serialVersionUID = 89732416546545L;
    static final String[] TABLE_COLUMNS = new String[]{Bundle.PhpAnnotationsPanel_table_column_name_title(), Bundle.PhpAnnotationsPanel_table_column_for_title()};
    final AnnotationsTableModel tableModel;
    List<UserAnnotationTag> annotations = Collections.emptyList();
    private JButton addButton;
    private JLabel annotationsLabel;
    private JScrollPane annotationsScrollPane;
    private JTable annotationsTable;
    private JButton deleteButton;
    private JButton editButton;
    private JLabel infoLabel;
    private JLabel noteLabel;

    public PhpAnnotationsPanel() {
        this.tableModel = new AnnotationsTableModel();
        this.initComponents();
        this.initTable();
        this.initButtons();
    }

    public List<UserAnnotationTag> getAnnotations() {
        assert (EventQueue.isDispatchThread());
        return this.annotations;
    }

    public void setAnnotations(List<UserAnnotationTag> annotations) {
        assert (EventQueue.isDispatchThread());
        this.annotations = annotations;
        this.tableModel.fireAnnotationsChange();
    }

    private void initTable() {
        this.annotationsTable.setModel(this.tableModel);
        this.annotationsTable.getTableHeader().setReorderingAllowed(false);
        this.annotationsTable.setAutoCreateRowSorter(true);
        this.annotationsTable.setColumnSelectionAllowed(false);
        this.annotationsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                PhpAnnotationsPanel.this.setEnabledButtons(PhpAnnotationsPanel.this.annotationsTable.getSelectedRowCount());
            }
        });
        this.annotationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PhpAnnotationsPanel.this.editButton.isEnabled()) {
                    PhpAnnotationsPanel.this.openAnnotationPanel(PhpAnnotationsPanel.this.annotationsTable.getSelectedRow());
                }
            }
        });
    }

    private void initButtons() {
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpAnnotationsPanel.this.openAnnotationPanel(null);
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpAnnotationsPanel.this.openAnnotationPanel(PhpAnnotationsPanel.this.annotationsTable.getSelectedRow());
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpAnnotationsPanel.this.deleteAnnotations();
            }
        });
    }

    void setEnabledButtons(int selectedRowCount) {
        this.deleteButton.setEnabled(selectedRowCount > 0);
        this.editButton.setEnabled(selectedRowCount == 1);
    }

    void openAnnotationPanel(Integer index) {
        assert (EventQueue.isDispatchThread());
        UserAnnotationPanel panel = new UserAnnotationPanel(this.getAnnotation(index));
        if (panel.open()) {
            UserAnnotationTag annotation = panel.getAnnotation();
            if (index == null) {
                this.annotations.add(annotation);
                this.tableModel.fireAnnotationsChange();
            } else {
                this.annotations.set(index, annotation);
                this.tableModel.fireAnnotationChange(index);
            }
        }
    }

    void deleteAnnotations() {
        int[] selectedRows = this.annotationsTable.getSelectedRows();
        assert (selectedRows.length > 0) : "No selected annotations?!";
        if (selectedRows.length == 0) {
            return;
        }
        Arrays.sort(selectedRows);
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.annotations.remove(i);
        }
        this.tableModel.fireAnnotationsChange();
    }

    private UserAnnotationTag getAnnotation(Integer index) {
        assert (EventQueue.isDispatchThread());
        if (index == null) {
            return new UserAnnotationTag(EnumSet.of(UserAnnotationTag.Type.FUNCTION), "sample", "@sample(${param1}, ${param2} = ${value1})", NbBundle.getMessage(PhpAnnotationsPanel.class, (String)"SampleTag.documentation"));
        }
        return this.annotations.get(index);
    }

    private void initComponents() {
        this.annotationsLabel = new JLabel();
        this.annotationsScrollPane = new JScrollPane();
        this.annotationsTable = new JTable();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.noteLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.annotationsLabel.setLabelFor(this.annotationsTable);
        Mnemonics.setLocalizedText((JLabel)this.annotationsLabel, (String)NbBundle.getMessage(PhpAnnotationsPanel.class, (String)"PhpAnnotationsPanel.annotationsLabel.text"));
        this.annotationsScrollPane.setViewportView(this.annotationsTable);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(PhpAnnotationsPanel.class, (String)"PhpAnnotationsPanel.addButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(PhpAnnotationsPanel.class, (String)"PhpAnnotationsPanel.editButton.text"));
        this.editButton.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(PhpAnnotationsPanel.class, (String)"PhpAnnotationsPanel.deleteButton.text"));
        this.deleteButton.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(PhpAnnotationsPanel.class, (String)"PhpAnnotationsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(PhpAnnotationsPanel.class, (String)"PhpAnnotationsPanel.infoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.annotationsScrollPane, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton, GroupLayout.Alignment.TRAILING).addComponent(this.editButton, GroupLayout.Alignment.TRAILING).addComponent(this.deleteButton, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.annotationsLabel).addComponent(this.noteLabel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel).addContainerGap()));
        layout.linkSize(0, this.addButton, this.deleteButton, this.editButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.annotationsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton)).addComponent(this.annotationsScrollPane, -1, 223, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel)));
    }

    private final class AnnotationsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 167686524135456L;

        private AnnotationsTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public int getRowCount() {
            assert (EventQueue.isDispatchThread());
            return PhpAnnotationsPanel.this.annotations.size();
        }

        @Override
        public int getColumnCount() {
            return TABLE_COLUMNS.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            assert (EventQueue.isDispatchThread());
            UserAnnotationTag annotation = PhpAnnotationsPanel.this.annotations.get(rowIndex);
            if (columnIndex == 0) {
                return annotation.getName();
            }
            if (columnIndex == 1) {
                return this.getTypes(annotation.getTypes());
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            return TABLE_COLUMNS[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        public void fireAnnotationChange(int row) {
            for (int i = 0; i < TABLE_COLUMNS.length; ++i) {
                this.fireTableCellUpdated(row, i);
            }
        }

        public void fireAnnotationsChange() {
            this.fireTableDataChanged();
        }

        private String getTypes(EnumSet<UserAnnotationTag.Type> types) {
            ArrayList<String> list = new ArrayList<String>(types.size());
            for (UserAnnotationTag.Type type : types) {
                list.add(type.getTitle());
            }
            return StringUtils.implode(list, (String)Bundle.PhpAnnotationsPanel_value_delimiter());
        }
    }
}

