/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.codecoverage.api.CoverageActionFactory;
import org.netbeans.modules.php.api.documentation.PhpDocumentations;
import org.netbeans.modules.php.api.framework.BadgeIcon;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.spi.documentation.PhpDocumentationProvider;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleActionsExtender;
import org.netbeans.modules.php.spi.framework.actions.RunCommandAction;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;

public class PhpLogicalViewProvider
implements LogicalViewProvider {
    private static final Logger LOGGER = Logger.getLogger(PhpLogicalViewProvider.class.getName());
    static final RequestProcessor RP = new RequestProcessor(PhpLogicalViewProvider.class);
    final PhpProject project;

    public PhpLogicalViewProvider(PhpProject project) {
        assert (project != null);
        this.project = project;
    }

    public Node createLogicalView() {
        return PhpLogicalViewRootNode.createForProject(this.project);
    }

    public Node findPath(Node root, Object target) {
        Node[] children;
        Project p = (Project)root.getLookup().lookup(Project.class);
        if (p == null) {
            return null;
        }
        for (Node node : children = root.getChildren().getNodes(true)) {
            FileObject kidFO;
            if (!(target instanceof DataObject) && !(target instanceof FileObject) || (kidFO = (FileObject)node.getLookup().lookup(FileObject.class)) == null) continue;
            FileObject targetFO = null;
            targetFO = target instanceof DataObject ? ((DataObject)target).getPrimaryFile() : (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)targetFO);
            if (!p.equals(owner)) {
                return null;
            }
            if (kidFO == targetFO) {
                return node;
            }
            if (!FileUtil.isParentOf((FileObject)kidFO, (FileObject)targetFO)) continue;
            String relPath = FileUtil.getRelativePath((FileObject)kidFO, (FileObject)targetFO);
            String[] path = relPath.split("/");
            path[path.length - 1] = targetFO.getName();
            Node found = this.findNode(node, path);
            if (found == null) {
                path[path.length - 1] = targetFO.getNameExt();
                found = this.findNode(node, path);
            }
            if (found == null) continue;
            if (this.hasObject(found, target)) {
                return found;
            }
            Node parent = found.getParentNode();
            Children kids = parent.getChildren();
            for (Node child : children = kids.getNodes()) {
                if (!this.hasObject(child, target)) continue;
                return child;
            }
        }
        return null;
    }

    private Node findNode(Node start, String[] path) {
        Node found = null;
        try {
            found = NodeOp.findPath((Node)start, (String[])path);
        }
        catch (NodeNotFoundException ex) {
            // empty catch block
        }
        return found;
    }

    private boolean hasObject(Node node, Object obj) {
        if (obj == null) {
            return false;
        }
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            return false;
        }
        if (obj instanceof DataObject) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            if (dataObject.equals(obj)) {
                return true;
            }
            return this.hasObject(node, ((DataObject)obj).getPrimaryFile());
        }
        if (obj instanceof FileObject) {
            return obj.equals(fileObject);
        }
        return false;
    }

    private static abstract class BaseSubMenu
    extends JMenu {
        public BaseSubMenu(String name) {
            super(name);
        }

        protected static JMenuItem toMenuItem(Action action) {
            JMenuItem item;
            if (action instanceof Presenter.Menu) {
                item = ((Presenter.Menu)action).getMenuPresenter();
            } else {
                item = new JMenuItem();
                Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            }
            return item;
        }
    }

    private static final class PhpDocAction
    extends AbstractAction {
        private static final long serialVersionUID = 178423135454L;
        private static final RequestProcessor RP = new RequestProcessor("Generating php documentation", 2);
        private final PhpProject phpProject;
        private final PhpDocumentationProvider docProvider;

        public PhpDocAction(PhpProject phpProject, PhpDocumentationProvider docProvider) {
            this(NbBundle.getMessage(PhpDocAction.class, (String)"PhpDoc.action.generate.label"), phpProject, docProvider);
        }

        public PhpDocAction(String name, PhpProject phpProject, PhpDocumentationProvider docProvider) {
            this.phpProject = phpProject;
            this.docProvider = docProvider;
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PhpProjectValidator.isFatallyBroken(this.phpProject)) {
                Utils.warnInvalidSourcesDirectory(this.phpProject);
                return;
            }
            RP.post(new Runnable(){

                @Override
                public void run() {
                    LifecycleManager.getDefault().saveAll();
                    PhpDocAction.this.docProvider.generateDocumentation(PhpDocAction.this.phpProject.getPhpModule());
                }
            });
        }
    }

    private static class DocumentationSubMenu
    extends BaseSubMenu {
        private static final long serialVersionUID = -6764324657641L;

        public DocumentationSubMenu(List<PhpDocAction> docActions) {
            super(NbBundle.getMessage(DocumentationSubMenu.class, (String)"PhpDoc.action.generate.label"));
            for (PhpDocAction action : docActions) {
                this.add(DocumentationSubMenu.toMenuItem(action));
            }
        }
    }

    private static class DocumentationMenu
    extends AbstractAction
    implements Presenter.Popup {
        private static final long serialVersionUID = 1587896543546879L;
        private final PhpProject phpProject;
        private final List<PhpDocumentationProvider> docProviders;

        public DocumentationMenu(PhpProject phpProject, List<PhpDocumentationProvider> docProviders) {
            super(NbBundle.getMessage(DocumentationMenu.class, (String)"PhpDoc.action.generate.label"), null);
            assert (phpProject != null);
            assert (docProviders != null);
            this.putValue("ShortDescription", NbBundle.getMessage(DocumentationMenu.class, (String)"PhpDoc.action.generate.label"));
            this.phpProject = phpProject;
            this.docProviders = docProviders;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public JMenuItem getPopupPresenter() {
            ArrayList<PhpDocAction> docActions = new ArrayList<PhpDocAction>(this.docProviders.size());
            for (PhpDocumentationProvider docProvider : this.docProviders) {
                docActions.add(new PhpDocAction(docProvider.getDisplayName(), this.phpProject, docProvider));
            }
            return new DocumentationSubMenu(docActions);
        }
    }

    public static final class DocumentationActionFactory
    extends AbstractAction
    implements ContextAwareAction {
        private static final long serialVersionUID = 5687856454545L;

        public DocumentationActionFactory() {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            Collection projects = actionContext.lookupAll(Project.class);
            if (projects.size() != 1) {
                return this;
            }
            PhpProject phpProject = (PhpProject)((Project)projects.iterator().next()).getLookup().lookup(PhpProject.class);
            if (phpProject == null) {
                return this;
            }
            List docProviders = PhpDocumentations.getDocumentations();
            if (docProviders.isEmpty()) {
                return this;
            }
            PhpModule phpModule = phpProject.getPhpModule();
            ArrayList<PhpDocumentationProvider> projectDocProviders = new ArrayList<PhpDocumentationProvider>(docProviders.size());
            for (PhpDocumentationProvider docProvider : docProviders) {
                if (!docProvider.isInPhpModule(phpModule)) continue;
                projectDocProviders.add(docProvider);
            }
            if (projectDocProviders.isEmpty()) {
                return this;
            }
            if (projectDocProviders.size() == 1) {
                return new PhpDocAction(phpProject, (PhpDocumentationProvider)projectDocProviders.get(0));
            }
            return new DocumentationMenu(phpProject, projectDocProviders);
        }
    }

    static final class CustomizeProjectAction
    extends AbstractAction {
        private static final long serialVersionUID = 423217315757925129L;
        private final PhpProject project;
        private final String category;

        CustomizeProjectAction(PhpProject project, String category) {
            assert (project != null);
            assert (category != null);
            this.project = project;
            this.category = category;
            String name = NbBundle.getMessage(PhpLogicalViewProvider.class, (String)"LBL_Customize");
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer(this.category);
        }
    }

    private static final class PhpLogicalViewRootNode
    extends AbstractNode
    implements ChangeListener,
    PropertyChangeListener {
        private static final String TOOLTIP = "<img src=\"%s\">&nbsp;%s";
        private final PhpProject project;
        private final ProjectInformation projectInfo;

        private PhpLogicalViewRootNode(PhpProject project) {
            super(PhpLogicalViewRootNode.createChildren(project), PhpLogicalViewRootNode.createLookup(project));
            this.project = project;
            this.projectInfo = ProjectUtils.getInformation((Project)project);
            this.setIconBaseWithExtension("org/netbeans/modules/php/project/ui/resources/phpProject.png");
            this.setName(ProjectUtils.getInformation((Project)project).getDisplayName());
        }

        public static PhpLogicalViewRootNode createForProject(PhpProject project) {
            PhpLogicalViewRootNode rootNode = new PhpLogicalViewRootNode(project);
            rootNode.addListeners();
            return rootNode;
        }

        public Image getIcon(int type) {
            return this.annotateImage(super.getIcon(type));
        }

        public Image getOpenedIcon(int type) {
            return this.annotateImage(super.getOpenedIcon(type));
        }

        private void addListeners() {
            ProjectPropertiesSupport.addWeakProjectPropertyChangeListener(this.project, this);
            this.projectInfo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.projectInfo));
        }

        private static Lookup createLookup(PhpProject project) {
            InstanceContent instanceContent = new InstanceContent();
            instanceContent.add((Object)project);
            instanceContent.add((Object)project, (InstanceContent.Convertor)new InstanceContent.Convertor<PhpProject, FileObject>(){

                public FileObject convert(PhpProject obj) {
                    return obj.getProjectDirectory();
                }

                public Class<? extends FileObject> type(PhpProject obj) {
                    return FileObject.class;
                }

                public String id(PhpProject obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                public String displayName(PhpProject obj) {
                    return obj.toString();
                }
            });
            instanceContent.add((Object)project, (InstanceContent.Convertor)new InstanceContent.Convertor<PhpProject, DataObject>(){

                public DataObject convert(PhpProject obj) {
                    try {
                        FileObject fo = obj.getProjectDirectory();
                        return fo != null && fo.isValid() ? DataObject.find((FileObject)fo) : null;
                    }
                    catch (DataObjectNotFoundException ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                        return null;
                    }
                }

                public Class<? extends DataObject> type(PhpProject obj) {
                    return DataObject.class;
                }

                public String id(PhpProject obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                public String displayName(PhpProject obj) {
                    return obj.toString();
                }
            });
            return new AbstractLookup((AbstractLookup.Content)instanceContent);
        }

        private Image annotateImage(Image image) {
            Image badged = image;
            boolean first = true;
            for (PhpFrameworkProvider frameworkProvider : this.project.getFrameworks()) {
                BadgeIcon badgeIcon = frameworkProvider.getBadgeIcon();
                if (badgeIcon != null) {
                    badged = ImageUtilities.addToolTipToImage((Image)badged, (String)String.format(TOOLTIP, badgeIcon.getUrl(), frameworkProvider.getName()));
                    if (!first) continue;
                    badged = ImageUtilities.mergeImages((Image)badged, (Image)badgeIcon.getImage(), (int)15, (int)0);
                    first = false;
                    continue;
                }
                badged = ImageUtilities.addToolTipToImage((Image)badged, (String)String.format(TOOLTIP, Utils.PLACEHOLDER_BADGE, frameworkProvider.getName()));
            }
            return badged;
        }

        public String getName() {
            return this.projectInfo.getDisplayName();
        }

        public String getShortDescription() {
            String prjDirDispName = FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory());
            return NbBundle.getMessage(PhpLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)prjDirDispName);
        }

        public String getHtmlDisplayName() {
            String dispName = super.getDisplayName();
            try {
                dispName = XMLUtil.toElementContent((String)dispName);
            }
            catch (CharConversionException ex) {
                return dispName;
            }
            return PhpProjectValidator.isBroken(this.project) ? "<font color=\"#" + Integer.toHexString(Utils.getErrorForeground().getRGB() & 0xFFFFFF) + "\">" + dispName + "</font>" : null;
        }

        public Action[] getActions(boolean context) {
            LinkedList<Action> actions = new LinkedList<Action>(Arrays.asList(CommonProjectActions.forType((String)"org-netbeans-modules-php-phpproject")));
            this.addCodeCoverageAction(actions);
            this.addFrameworks(actions);
            return actions.toArray(new Action[actions.size()]);
        }

        private void addCodeCoverageAction(List<Action> actions) {
            if (CommandUtils.getPhpUnit(this.project, false) != null) {
                int activeConfigActionIndex = actions.size();
                for (int i = 0; i < actions.size(); ++i) {
                    Action action = actions.get(i);
                    if (action == null || !action.getClass().getName().equals("org.netbeans.modules.project.ui.actions.ActiveConfigAction")) continue;
                    activeConfigActionIndex = i;
                    break;
                }
                actions.add(++activeConfigActionIndex, CoverageActionFactory.createCollectorAction(null, null));
            }
        }

        private void addFrameworks(List<Action> actions) {
            int documentationIndex = actions.size();
            for (int i = 0; i < actions.size(); ++i) {
                Action action = actions.get(i);
                if (!(action instanceof DocumentationActionFactory)) continue;
                documentationIndex = i;
                break;
            }
            boolean separatorAdded = false;
            PhpModule phpModule = this.project.getPhpModule();
            for (PhpFrameworkProvider frameworkProvider : this.project.getFrameworks()) {
                PhpModuleActionsExtender actionsExtender = frameworkProvider.getActionsExtender(phpModule);
                if (actionsExtender == null) continue;
                RunCommandAction runCommandAction = actionsExtender.getRunCommandAction();
                List frameworkActions = actionsExtender.getActions();
                if (runCommandAction == null && frameworkActions.isEmpty()) continue;
                ArrayList<RunCommandAction> allActions = new ArrayList<RunCommandAction>(frameworkActions.size() + 2);
                if (runCommandAction != null) {
                    allActions.add(runCommandAction);
                    if (!frameworkActions.isEmpty()) {
                        allActions.add(null);
                    }
                }
                allActions.addAll(frameworkActions);
                if (!separatorAdded) {
                    separatorAdded = true;
                    actions.add(++documentationIndex, null);
                }
                actions.add(++documentationIndex, new FrameworkMenu(actionsExtender.getMenuName(), allActions));
            }
            if (separatorAdded) {
                actions.add(++documentationIndex, null);
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider");
        }

        private static Children createChildren(PhpProject project) {
            return NodeFactorySupport.createCompositeChildren((Project)project, (String)"Projects/org-netbeans-modules-php-project/Nodes");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    PhpLogicalViewRootNode.this.fireIconChange();
                    PhpLogicalViewRootNode.this.fireOpenedIconChange();
                    PhpLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            });
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    if ("frameworks".equals(evt.getPropertyName())) {
                        PhpLogicalViewRootNode.this.fireIconChange();
                        PhpLogicalViewRootNode.this.fireOpenedIconChange();
                    } else {
                        PhpLogicalViewRootNode.this.fireNameChange(null, null);
                        PhpLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                    }
                }
            });
        }

        private static class FrameworkSubMenu
        extends BaseSubMenu {
            private static final long serialVersionUID = 9043114612433517414L;

            public FrameworkSubMenu(String name, List<? extends Action> frameworkActions) {
                super(name);
                assert (name != null);
                assert (frameworkActions != null);
                for (Action action : frameworkActions) {
                    if (action != null) {
                        this.add(FrameworkSubMenu.toMenuItem(action));
                        continue;
                    }
                    this.addSeparator();
                }
            }
        }

        private static class FrameworkMenu
        extends AbstractAction
        implements Presenter.Popup {
            private static final long serialVersionUID = -238674120253122435L;
            private final String name;
            private final List<? extends Action> frameworkActions;

            public FrameworkMenu(String name, List<? extends Action> frameworkActions) {
                super(name, null);
                assert (name != null);
                assert (frameworkActions != null);
                this.putValue("ShortDescription", name);
                this.name = name;
                this.frameworkActions = frameworkActions;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (false);
            }

            public JMenuItem getPopupPresenter() {
                return new FrameworkSubMenu(this.name, this.frameworkActions);
            }
        }
    }
}

