/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.runconfigs.RunConfigScript;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigScriptValidator;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsPanel;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

@SuppressWarnings(value={"SE_BAD_FIELD_STORE"})
public final class RunAsScript
extends RunAsPanel.InsidePanel {
    private static final long serialVersionUID = 5468731321321L;
    private final PhpProject project;
    private final JLabel[] labels;
    private final JTextField[] textFields;
    private final String[] propertyNames;
    private final PropertyChangeListener phpInterpreterListener;
    final ProjectCustomizer.Category category;
    private JLabel argsLabel;
    private JTextField argsTextField;
    private JButton configureButton;
    private JCheckBox defaultInterpreterCheckBox;
    private JLabel hintLabel;
    private JButton indexFileBrowseButton;
    private JLabel indexFileLabel;
    private JTextField indexFileTextField;
    private JButton interpreterBrowseButton;
    private JLabel interpreterLabel;
    private JTextField interpreterTextField;
    private JLabel phpOptionsLabel;
    private JTextField phpOptionsTextField;
    private JComboBox runAsCombo;
    private JLabel runAsLabel;
    private JButton workDirBrowseButton;
    private JLabel workDirLabel;
    private JTextField workDirTextField;

    public RunAsScript(PhpProject project, ConfigManager manager, ProjectCustomizer.Category category) {
        super(manager);
        this.project = project;
        this.category = category;
        this.initComponents();
        this.labels = new JLabel[]{this.indexFileLabel, this.interpreterLabel, this.argsLabel, this.workDirLabel, this.phpOptionsLabel};
        this.textFields = new JTextField[]{this.indexFileTextField, this.interpreterTextField, this.argsTextField, this.workDirTextField, this.phpOptionsTextField};
        this.propertyNames = new String[]{"index.file", "interpreter", "script.arguments", "work.dir", "php.arguments"};
        assert (this.labels.length == this.textFields.length && this.labels.length == this.propertyNames.length);
        for (int i = 0; i < this.textFields.length; ++i) {
            FieldUpdater dl = new FieldUpdater(this.propertyNames[i], this.labels[i], this.textFields[i]);
            this.textFields[i].getDocument().addDocumentListener(dl);
        }
        this.defaultInterpreterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = RunAsScript.this.defaultInterpreterCheckBox.isSelected();
                RunAsScript.this.interpreterBrowseButton.setEnabled(!selected);
                RunAsScript.this.interpreterTextField.setEditable(!selected);
                String newValue = null;
                newValue = selected ? RunAsScript.this.getDefaultPhpInterpreter() : RunAsScript.this.interpreterTextField.getText();
                RunAsScript.this.interpreterTextField.setText(newValue + " ");
            }
        });
        this.phpInterpreterListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("propPhpInterpreter".equals(evt.getPropertyName()) && RunAsScript.this.defaultInterpreterCheckBox.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunAsScript.this.interpreterTextField.setText(RunAsScript.this.getDefaultPhpInterpreter());
                            RunAsScript.this.composeHint();
                        }
                    });
                }
            }
        };
        PhpOptions phpOptions = PhpOptions.getInstance();
        phpOptions.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.phpInterpreterListener, (Object)phpOptions));
        this.composeHint();
    }

    private String getDefaultPhpInterpreter() {
        String phpInterpreter = PhpOptions.getInstance().getPhpInterpreter();
        return phpInterpreter != null ? phpInterpreter : "";
    }

    private String initPhpInterpreterFields() {
        String phpInterpreter = this.getValue("interpreter");
        boolean def = phpInterpreter == null || phpInterpreter.length() == 0;
        this.defaultInterpreterCheckBox.setSelected(def);
        this.interpreterBrowseButton.setEnabled(!def);
        this.interpreterTextField.setEditable(!def);
        if (def) {
            return this.getDefaultPhpInterpreter();
        }
        return phpInterpreter;
    }

    @Override
    protected PhpProjectProperties.RunAsType getRunAsType() {
        return RunConfigScript.getRunAsType();
    }

    @Override
    public String getDisplayName() {
        return RunConfigScript.getDisplayName();
    }

    @Override
    protected JLabel getRunAsLabel() {
        return this.runAsLabel;
    }

    @Override
    public JComboBox getRunAsCombo() {
        return this.runAsCombo;
    }

    @Override
    protected void loadFields() {
        for (int i = 0; i < this.textFields.length; ++i) {
            String val = this.getValue(this.propertyNames[i]);
            if ("interpreter".equals(this.propertyNames[i])) {
                val = this.initPhpInterpreterFields();
            }
            this.textFields[i].setText(val);
        }
    }

    @Override
    protected void validateFields() {
        this.category.setErrorMessage(RunConfigScriptValidator.validateCustomizer(this.createRunConfig()));
        this.category.setValid(true);
    }

    private RunConfigScript createRunConfig() {
        return ((RunConfigScript)((RunConfigScript)((RunConfigScript)RunConfigScript.create().setUseDefaultInterpreter(this.defaultInterpreterCheckBox.isSelected()).setInterpreter(this.interpreterTextField.getText().trim()).setOptions(this.phpOptionsTextField.getText().trim()).setIndexParentDir(FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(this.project)))).setIndexRelativePath(this.indexFileTextField.getText().trim())).setArguments(this.argsTextField.getText().trim())).setWorkDir(this.workDirTextField.getText().trim());
    }

    void composeHint() {
        this.hintLabel.setText("<html><body>" + this.createRunConfig().getHint());
    }

    private void initComponents() {
        this.interpreterLabel = new JLabel();
        this.interpreterTextField = new JTextField();
        this.interpreterBrowseButton = new JButton();
        this.defaultInterpreterCheckBox = new JCheckBox();
        this.configureButton = new JButton();
        this.argsLabel = new JLabel();
        this.argsTextField = new JTextField();
        this.runAsLabel = new JLabel();
        this.runAsCombo = new JComboBox();
        this.indexFileLabel = new JLabel();
        this.indexFileTextField = new JTextField();
        this.indexFileBrowseButton = new JButton();
        this.workDirLabel = new JLabel();
        this.workDirTextField = new JTextField();
        this.workDirBrowseButton = new JButton();
        this.phpOptionsLabel = new JLabel();
        this.phpOptionsTextField = new JTextField();
        this.hintLabel = new JLabel();
        this.interpreterLabel.setLabelFor(this.interpreterTextField);
        Mnemonics.setLocalizedText((JLabel)this.interpreterLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_PhpInterpreter"));
        this.interpreterTextField.setEditable(false);
        this.interpreterTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.interpreterBrowseButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_BrowseInterpreter"));
        this.interpreterBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsScript.this.interpreterBrowseButtonActionPerformed(evt);
            }
        });
        this.defaultInterpreterCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultInterpreterCheckBox, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_UseDefaultInterpreter"));
        Mnemonics.setLocalizedText((AbstractButton)this.configureButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Configure"));
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsScript.this.configureButtonActionPerformed(evt);
            }
        });
        this.argsLabel.setLabelFor(this.argsTextField);
        Mnemonics.setLocalizedText((JLabel)this.argsLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Arguments"));
        this.argsTextField.setColumns(20);
        this.runAsLabel.setLabelFor(this.runAsCombo);
        Mnemonics.setLocalizedText((JLabel)this.runAsLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_RunAs"));
        this.indexFileLabel.setLabelFor(this.indexFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.indexFileLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_IndexFile"));
        this.indexFileTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.indexFileBrowseButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"LBL_Browse"));
        this.indexFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsScript.this.indexFileBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.workDirLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.workDirLabel.text"));
        this.workDirTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.workDirBrowseButton, (String)NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.workDirBrowseButton.text"));
        this.workDirBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunAsScript.this.workDirBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.phpOptionsLabel, (String)NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.phpOptionsLabel.text"));
        this.phpOptionsTextField.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.hintLabel, (String)"dummy");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.runAsLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.interpreterLabel).addComponent(this.indexFileLabel).addComponent(this.argsLabel).addComponent(this.workDirLabel).addComponent(this.phpOptionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hintLabel).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.argsTextField, GroupLayout.Alignment.TRAILING, -2, 1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.indexFileTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexFileBrowseButton)).addComponent(this.runAsCombo, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.interpreterTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.interpreterBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.defaultInterpreterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.configureButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.workDirTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workDirBrowseButton)).addComponent(this.phpOptionsTextField, -2, 1, Short.MAX_VALUE)))));
        layout.linkSize(0, this.configureButton, this.indexFileBrowseButton, this.interpreterBrowseButton, this.workDirBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runAsLabel).addComponent(this.runAsCombo, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.interpreterLabel).addComponent(this.interpreterBrowseButton).addComponent(this.interpreterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultInterpreterCheckBox).addComponent(this.configureButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.indexFileTextField, -2, -1, -2).addComponent(this.indexFileLabel).addComponent(this.indexFileBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.argsTextField, -2, -1, -2).addComponent(this.argsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.workDirLabel).addComponent(this.workDirTextField, -2, -1, -2).addComponent(this.workDirBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpOptionsLabel).addComponent(this.phpOptionsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintLabel)));
        this.interpreterLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterLabel.AccessibleContext.accessibleName"));
        this.interpreterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterLabel.AccessibleContext.accessibleDescription"));
        this.interpreterTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterTextField.AccessibleContext.accessibleName"));
        this.interpreterTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterTextField.AccessibleContext.accessibleDescription"));
        this.interpreterBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterBrowseButton.AccessibleContext.accessibleName"));
        this.interpreterBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.interpreterBrowseButton.AccessibleContext.accessibleDescription"));
        this.defaultInterpreterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.defaultInterpreterCheckBox.AccessibleContext.accessibleName"));
        this.defaultInterpreterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.defaultInterpreterCheckBox.AccessibleContext.accessibleDescription"));
        this.configureButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.configureButton.AccessibleContext.accessibleName"));
        this.configureButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.configureButton.AccessibleContext.accessibleDescription"));
        this.argsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.argsLabel.AccessibleContext.accessibleName"));
        this.argsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.argsLabel.AccessibleContext.accessibleDescription"));
        this.argsTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.argsTextField.AccessibleContext.accessibleName"));
        this.argsTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.argsTextField.AccessibleContext.accessibleDescription"));
        this.runAsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsLabel.AccessibleContext.accessibleName"));
        this.runAsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsLabel.AccessibleContext.accessibleDescription"));
        this.runAsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsCombo.AccessibleContext.accessibleName"));
        this.runAsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.runAsCombo.AccessibleContext.accessibleDescription"));
        this.indexFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileLabel.AccessibleContext.accessibleName"));
        this.indexFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileLabel.AccessibleContext.accessibleDescription"));
        this.indexFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileTextField.AccessibleContext.accessibleName"));
        this.indexFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileTextField.AccessibleContext.accessibleDescription"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileBrowseButton.AccessibleContext.accessibleName"));
        this.indexFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.indexFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.hintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.hintLabel.AccessibleContext.accessibleName"));
        this.hintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.hintLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunAsScript.class, (String)"RunAsScript.AccessibleContext.accessibleDescription"));
    }

    private void configureButtonActionPerformed(ActionEvent evt) {
        Utils.showGeneralOptionsPanel();
    }

    private void indexFileBrowseButtonActionPerformed(ActionEvent evt) {
        Utils.browseSourceFile(this.project, this.indexFileTextField);
    }

    private void interpreterBrowseButtonActionPerformed(ActionEvent evt) {
        File file = Utils.browseFileAction("nb.php.interpreter", Bundle.RunAsScript_interpreter_browse_title());
        if (file != null) {
            this.interpreterTextField.setText(file.getAbsolutePath());
        }
    }

    private void workDirBrowseButtonActionPerformed(ActionEvent evt) {
        String workDir = this.createRunConfig().getWorkDir();
        File curDir = StringUtils.hasText((String)workDir) ? new File(workDir) : FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(this.project));
        File selectedFile = new FileChooserBuilder(RunAsScript.class).forceUseOfDefaultWorkingDirectory(true).setTitle(NbBundle.getMessage(RunAsScript.class, (String)"LBL_SelectWorkingDirectory")).setDirectoriesOnly(true).setDefaultWorkingDirectory(curDir).showOpenDialog();
        if (selectedFile != null) {
            this.workDirTextField.setText(FileUtil.normalizeFile((File)selectedFile).getAbsolutePath());
        }
    }

    private class FieldUpdater
    extends RunAsPanel.InsidePanel.TextFieldUpdater {
        public FieldUpdater(String propName, JLabel label, JTextField field) {
            super(propName, label, field);
        }

        @Override
        protected final String getDefaultValue() {
            return RunAsScript.this.getDefaultValue(this.getPropName());
        }

        @Override
        protected void processUpdate() {
            super.processUpdate();
            RunAsScript.this.composeHint();
        }

        @Override
        protected String getPropValue() {
            if ("interpreter".equals(this.getPropName()) && RunAsScript.this.defaultInterpreterCheckBox.isSelected()) {
                return "";
            }
            return super.getPropValue().trim();
        }
    }
}

