/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.classpath.IncludePathSupport;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.IgnorePathSupport;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class PhpProjectProperties
implements ConfigManager.ConfigProvider {
    public static final int DEFAULT_DEBUG_PROXY_PORT = 9001;
    public static final String SRC_DIR = "src.dir";
    public static final String TEST_SRC_DIR = "test.src.dir";
    public static final String SELENIUM_SRC_DIR = "selenium.src.dir";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String COPY_SRC_FILES = "copy.src.files";
    public static final String COPY_SRC_TARGET = "copy.src.target";
    public static final String WEB_ROOT = "web.root";
    public static final String URL = "url";
    public static final String INDEX_FILE = "index.file";
    public static final String INCLUDE_PATH = "include.path";
    public static final String GLOBAL_INCLUDE_PATH = "php.global.include.path";
    public static final String ARGS = "script.arguments";
    public static final String PHP_ARGS = "php.arguments";
    public static final String WORK_DIR = "work.dir";
    public static final String INTERPRETER = "interpreter";
    public static final String HOSTNAME = "hostname";
    public static final String PORT = "port";
    public static final String ROUTER = "router";
    public static final String RUN_AS = "run.as";
    public static final String REMOTE_CONNECTION = "remote.connection";
    public static final String REMOTE_DIRECTORY = "remote.directory";
    public static final String REMOTE_UPLOAD = "remote.upload";
    public static final String REMOTE_PERMISSIONS = "remote.permissions";
    public static final String REMOTE_UPLOAD_DIRECTLY = "remote.upload.directly";
    public static final String DEBUG_URL = "debug.url";
    public static final String DEBUG_PATH_MAPPING_REMOTE = "debug.path.mapping.remote";
    public static final String DEBUG_PATH_MAPPING_LOCAL = "debug.path.mapping.local";
    public static final String DEBUG_PROXY_HOST = "debug.proxy.host";
    public static final String DEBUG_PROXY_PORT = "debug.proxy.port";
    public static final String SHORT_TAGS = "tags.short";
    public static final String ASP_TAGS = "tags.asp";
    public static final String PHP_VERSION = "php.version";
    public static final String IGNORE_PATH = "ignore.path";
    public static final String PHP_UNIT_BOOTSTRAP = "phpunit.bootstrap";
    public static final String PHP_UNIT_BOOTSTRAP_FOR_CREATE_TESTS = "phpunit.bootstrap.create.tests";
    public static final String PHP_UNIT_CONFIGURATION = "phpunit.configuration";
    public static final String PHP_UNIT_SUITE = "phpunit.suite";
    public static final String PHP_UNIT_SCRIPT = "phpunit.script";
    public static final String PHP_UNIT_RUN_TEST_FILES = "phpunit.run.test.files";
    public static final String PHP_UNIT_ASK_FOR_TEST_GROUPS = "phpunit.test.groups.ask";
    public static final String PHP_UNIT_LAST_USED_TEST_GROUPS = "phpunit.test.groups.last.used";
    public static final String DEBUG_PATH_MAPPING_SEPARATOR = "||NB||";
    private static final String[] CFG_PROPS = new String[]{"url", "index.file", "script.arguments", "php.arguments", "work.dir", "interpreter", "hostname", "port", "router", "run.as", "remote.connection", "remote.directory", "remote.upload", "remote.permissions", "remote.upload.directly", "debug.url", "debug.path.mapping.remote", "debug.path.mapping.local", "debug.proxy.host", "debug.proxy.port"};
    static final String CONFIG_PRIVATE_PROPERTIES_PATH = "nbproject/private/config.properties";
    private static final RequestProcessor RP = new RequestProcessor(PhpProjectProperties.class.getName(), 2);
    private final PhpProject project;
    private final IncludePathSupport includePathSupport;
    private final IgnorePathSupport ignorePathSupport;
    private String srcDir;
    private String testDir;
    private boolean testDirRemoved = false;
    private String copySrcFiles;
    private String copySrcTarget;
    private String webRoot;
    private String url;
    private String indexFile;
    private String encoding;
    private String shortTags;
    private String aspTags;
    private String phpVersion;
    private String phpUnitBootstrap;
    private Boolean phpUnitBootstrapForCreateTests;
    private String phpUnitConfiguration;
    private String phpUnitSuite;
    private String phpUnitScript;
    private Boolean phpUnitRunTestFiles;
    private Boolean phpUnitAskForTestGroups;
    private String phpUnitLastUsedTestGroups;
    private Set<PhpModuleCustomizerExtender> customizerExtenders;
    final Map<String, Map<String, String>> runConfigs;
    private final ConfigManager configManager;
    private DefaultListModel includePathListModel = null;
    private ListCellRenderer includePathListRenderer = null;
    private DefaultListModel ignorePathListModel = null;
    private ListCellRenderer ignorePathListRenderer = null;

    public PhpProjectProperties(PhpProject project) {
        this(project, null, null);
    }

    public PhpProjectProperties(PhpProject project, IncludePathSupport includePathSupport, IgnorePathSupport ignorePathSupport) {
        assert (project != null);
        this.project = project;
        this.includePathSupport = includePathSupport;
        this.ignorePathSupport = ignorePathSupport;
        this.runConfigs = this.readRunConfigs();
        String currentConfig = ProjectPropertiesSupport.getPropertyEvaluator(project).getProperty("config");
        this.configManager = new ConfigManager(this, currentConfig);
    }

    @Override
    public String[] getConfigProperties() {
        return (String[])CFG_PROPS.clone();
    }

    @Override
    public Map<String, Map<String, String>> getConfigs() {
        return this.runConfigs;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public String getCopySrcFiles() {
        if (this.copySrcFiles == null) {
            this.copySrcFiles = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(COPY_SRC_FILES);
        }
        return this.copySrcFiles;
    }

    public void setCopySrcFiles(String copySrcFiles) {
        this.copySrcFiles = copySrcFiles;
    }

    public String getCopySrcTarget() {
        if (this.copySrcTarget == null) {
            this.copySrcTarget = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(COPY_SRC_TARGET);
        }
        return this.copySrcTarget;
    }

    public void setCopySrcTarget(String copySrcTarget) {
        this.copySrcTarget = copySrcTarget;
    }

    public void setShortTags(String shortTags) {
        this.shortTags = shortTags;
    }

    public void setAspTags(String aspTags) {
        this.aspTags = aspTags;
    }

    public void setPhpVersion(String phpVersion) {
        this.phpVersion = phpVersion;
    }

    public String getWebRoot() {
        if (this.webRoot == null) {
            this.webRoot = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(WEB_ROOT);
        }
        return this.webRoot != null ? this.webRoot : "";
    }

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(SOURCE_ENCODING);
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getSrcDir() {
        if (this.srcDir == null) {
            this.srcDir = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(SRC_DIR);
        }
        return this.srcDir;
    }

    public void setTestDir(String testDir) {
        this.testDirRemoved = false;
        this.testDir = testDir;
    }

    public void testDirRemoved() {
        this.testDirRemoved = true;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(URL);
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getIndexFile() {
        if (this.indexFile == null) {
            this.indexFile = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(INDEX_FILE);
        }
        return this.indexFile;
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }

    public DefaultListModel getIncludePathListModel() {
        if (this.includePathListModel == null) {
            EditableProperties properties = this.project.getHelper().getProperties("nbproject/project.properties");
            this.includePathListModel = PathUiSupport.createListModel(this.includePathSupport.itemsIterator(properties.getProperty(INCLUDE_PATH)));
        }
        return this.includePathListModel;
    }

    public ListCellRenderer getIncludePathListRenderer() {
        if (this.includePathListRenderer == null) {
            this.includePathListRenderer = new PathUiSupport.ClassPathListCellRenderer(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getProjectDirectory());
        }
        return this.includePathListRenderer;
    }

    public DefaultListModel getIgnorePathListModel() {
        if (this.ignorePathListModel == null) {
            EditableProperties properties = this.project.getHelper().getProperties("nbproject/project.properties");
            this.ignorePathListModel = PathUiSupport.createListModel(this.ignorePathSupport.itemsIterator(properties.getProperty(IGNORE_PATH)));
        }
        return this.ignorePathListModel;
    }

    public ListCellRenderer getIgnorePathListRenderer() {
        if (this.ignorePathListRenderer == null) {
            this.ignorePathListRenderer = new PathUiSupport.ClassPathListCellRenderer(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getProjectDirectory());
        }
        return this.ignorePathListRenderer;
    }

    public String getPhpUnitBootstrap() {
        File bootstrap;
        if (this.phpUnitBootstrap == null && (bootstrap = ProjectPropertiesSupport.getPhpUnitBootstrap(this.project)) != null) {
            this.phpUnitBootstrap = bootstrap.getAbsolutePath();
        }
        return this.phpUnitBootstrap;
    }

    public void setPhpUnitBootstrap(String phpUnitBootstrap) {
        this.phpUnitBootstrap = phpUnitBootstrap;
    }

    public boolean getPhpUnitBootstrapForCreateTests() {
        if (this.phpUnitBootstrapForCreateTests == null) {
            this.phpUnitBootstrapForCreateTests = ProjectPropertiesSupport.usePhpUnitBootstrapForCreateTests(this.project);
        }
        return this.phpUnitBootstrapForCreateTests;
    }

    public void setPhpUnitBootstrapForCreateTests(Boolean phpUnitBootstrapForCreateTests) {
        this.phpUnitBootstrapForCreateTests = phpUnitBootstrapForCreateTests;
    }

    public String getPhpUnitConfiguration() {
        File configuration;
        if (this.phpUnitConfiguration == null && (configuration = ProjectPropertiesSupport.getPhpUnitConfiguration(this.project)) != null) {
            this.phpUnitConfiguration = configuration.getAbsolutePath();
        }
        return this.phpUnitConfiguration;
    }

    public void setPhpUnitConfiguration(String phpUnitConfiguration) {
        this.phpUnitConfiguration = phpUnitConfiguration;
    }

    public String getPhpUnitSuite() {
        File suite;
        if (this.phpUnitSuite == null && (suite = ProjectPropertiesSupport.getPhpUnitSuite(this.project)) != null) {
            this.phpUnitSuite = suite.getAbsolutePath();
        }
        return this.phpUnitSuite;
    }

    public void setPhpUnitSuite(String phpUnitSuite) {
        this.phpUnitSuite = phpUnitSuite;
    }

    public String getPhpUnitScript() {
        File script;
        if (this.phpUnitScript == null && (script = ProjectPropertiesSupport.getPhpUnitScript(this.project)) != null) {
            this.phpUnitScript = script.getAbsolutePath();
        }
        return this.phpUnitScript;
    }

    public void setPhpUnitScript(String phpUnitScript) {
        this.phpUnitScript = phpUnitScript;
    }

    public Boolean getPhpUnitRunTestFiles() {
        if (this.phpUnitRunTestFiles == null) {
            this.phpUnitRunTestFiles = ProjectPropertiesSupport.runAllTestFilesUsingPhpUnit(this.project);
        }
        return this.phpUnitRunTestFiles;
    }

    public void setPhpUnitRunTestFiles(Boolean phpUnitRunTestFiles) {
        this.phpUnitRunTestFiles = phpUnitRunTestFiles;
    }

    public Boolean getPhpUnitAskForTestGroups() {
        if (this.phpUnitAskForTestGroups == null) {
            this.phpUnitAskForTestGroups = ProjectPropertiesSupport.askForTestGroups(this.project);
        }
        return this.phpUnitAskForTestGroups;
    }

    public void setPhpUnitAskForTestGroups(Boolean phpUnitAskForTestGroups) {
        this.phpUnitAskForTestGroups = phpUnitAskForTestGroups;
    }

    public String getPhpUnitLastUsedTestGroups() {
        if (this.phpUnitLastUsedTestGroups == null) {
            this.phpUnitLastUsedTestGroups = ProjectPropertiesSupport.getPhpUnitLastUsedTestGroups(this.project);
        }
        return this.phpUnitLastUsedTestGroups;
    }

    public void setPhpUnitLastUsedTestGroups(String phpUnitLastUsedTestGroups) {
        this.phpUnitLastUsedTestGroups = phpUnitLastUsedTestGroups;
    }

    public void addCustomizerExtender(PhpModuleCustomizerExtender customizerExtender) {
        if (this.customizerExtenders == null) {
            this.customizerExtenders = new HashSet<PhpModuleCustomizerExtender>();
        }
        this.customizerExtenders.add(customizerExtender);
    }

    public void save() {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    PhpProjectProperties.this.saveProperties();
                    PhpProjectProperties.this.saveCustomizerExtenders();
                    ProjectManager.getDefault().saveProject((Project)PhpProjectProperties.this.project);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            Exceptions.printStackTrace((Throwable)((IOException)e.getException()));
        }
    }

    public static void save(final PhpProject project, final Map<String, String> projectProperties, final Map<String, String> privateProperties) {
        assert (!projectProperties.isEmpty() || !privateProperties.isEmpty()) : "Neither project nor private properties to be saved";
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    AntProjectHelper helper = project.getHelper();
                    this.mergeProperties(helper, "nbproject/project.properties", projectProperties);
                    this.mergeProperties(helper, "nbproject/private/private.properties", privateProperties);
                    ProjectManager.getDefault().saveProject((Project)project);
                    return null;
                }

                private void mergeProperties(AntProjectHelper helper, String path, Map<String, String> properties) {
                    if (properties.isEmpty()) {
                        return;
                    }
                    EditableProperties currentProperties = helper.getProperties(path);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        currentProperties.put(entry.getKey(), entry.getValue());
                    }
                    helper.putProperties(path, currentProperties);
                }
            });
        }
        catch (MutexException e) {
            Exceptions.printStackTrace((Throwable)((IOException)e.getException()));
        }
    }

    void saveProperties() throws IOException {
        AntProjectHelper helper = this.project.getHelper();
        String[] includePath = null;
        if (this.includePathListModel != null) {
            includePath = this.includePathSupport.encodeToStrings(PathUiSupport.getIterator(this.includePathListModel));
        }
        String[] ignorePath = null;
        if (this.ignorePathListModel != null) {
            ignorePath = this.ignorePathSupport.encodeToStrings(PathUiSupport.getIterator(this.ignorePathListModel));
        }
        EditableProperties projectProperties = helper.getProperties("nbproject/project.properties");
        EditableProperties privateProperties = helper.getProperties("nbproject/private/private.properties");
        if (this.testDirRemoved) {
            projectProperties.remove((Object)TEST_SRC_DIR);
        } else if (this.testDir != null) {
            projectProperties.setProperty(TEST_SRC_DIR, this.testDir);
        }
        if (this.copySrcFiles != null) {
            privateProperties.setProperty(COPY_SRC_FILES, this.copySrcFiles);
        }
        if (this.copySrcTarget != null) {
            privateProperties.setProperty(COPY_SRC_TARGET, this.copySrcTarget);
        }
        if (this.encoding != null) {
            projectProperties.setProperty(SOURCE_ENCODING, this.encoding);
        }
        if (this.webRoot != null) {
            projectProperties.setProperty(WEB_ROOT, this.webRoot);
        }
        if (this.phpVersion != null) {
            projectProperties.setProperty(PHP_VERSION, this.phpVersion);
        }
        if (this.shortTags != null) {
            projectProperties.setProperty(SHORT_TAGS, this.shortTags);
        }
        if (this.aspTags != null) {
            projectProperties.setProperty(ASP_TAGS, this.aspTags);
        }
        if (includePath != null) {
            projectProperties.setProperty(INCLUDE_PATH, includePath);
        }
        if (ignorePath != null) {
            projectProperties.setProperty(IGNORE_PATH, ignorePath);
        }
        if (this.phpUnitBootstrap != null) {
            projectProperties.setProperty(PHP_UNIT_BOOTSTRAP, this.relativizeFile(this.phpUnitBootstrap));
        }
        if (this.phpUnitBootstrapForCreateTests != null) {
            projectProperties.setProperty(PHP_UNIT_BOOTSTRAP_FOR_CREATE_TESTS, this.phpUnitBootstrapForCreateTests.toString());
        }
        if (this.phpUnitConfiguration != null) {
            projectProperties.setProperty(PHP_UNIT_CONFIGURATION, this.relativizeFile(this.phpUnitConfiguration));
        }
        if (this.phpUnitSuite != null) {
            projectProperties.setProperty(PHP_UNIT_SUITE, this.relativizeFile(this.phpUnitSuite));
        }
        if (this.phpUnitScript != null) {
            projectProperties.setProperty(PHP_UNIT_SCRIPT, this.relativizeFile(this.phpUnitScript));
        }
        if (this.phpUnitRunTestFiles != null) {
            projectProperties.setProperty(PHP_UNIT_RUN_TEST_FILES, this.phpUnitRunTestFiles.toString());
        }
        if (this.phpUnitAskForTestGroups != null) {
            projectProperties.setProperty(PHP_UNIT_ASK_FOR_TEST_GROUPS, this.phpUnitAskForTestGroups.toString());
        }
        if (this.phpUnitLastUsedTestGroups != null) {
            projectProperties.setProperty(PHP_UNIT_LAST_USED_TEST_GROUPS, this.phpUnitLastUsedTestGroups);
        }
        this.storeRunConfigs(projectProperties, privateProperties);
        EditableProperties ep = helper.getProperties(CONFIG_PRIVATE_PROPERTIES_PATH);
        String currentConfig = this.configManager.currentConfiguration().getName();
        if (currentConfig == null) {
            ep.remove((Object)"config");
        } else {
            ep.setProperty("config", currentConfig);
        }
        helper.putProperties(CONFIG_PRIVATE_PROPERTIES_PATH, ep);
        helper.putProperties("nbproject/project.properties", projectProperties);
        helper.putProperties("nbproject/private/private.properties", privateProperties);
        if (this.encoding != null) {
            try {
                FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(this.encoding));
            }
            catch (UnsupportedCharsetException e) {
                // empty catch block
            }
        }
        ProjectSettings.resetLastUpload(this.project);
        ProjectSettings.resetLastDownload(this.project);
        this.logUsage(helper.getProjectDirectory(), ProjectPropertiesSupport.getSourcesDirectory(this.project), this.getActiveRunAsType(), this.getNumOfRunConfigs(), Boolean.valueOf(this.getCopySrcFiles()));
    }

    void saveCustomizerExtenders() {
        if (this.customizerExtenders != null) {
            final EnumSet<PhpModuleCustomizerExtender.Change> changes = EnumSet.noneOf(PhpModuleCustomizerExtender.Change.class);
            PhpModule phpModule = this.project.getPhpModule();
            for (PhpModuleCustomizerExtender customizerExtender : this.customizerExtenders) {
                EnumSet change = customizerExtender.save(phpModule);
                if (change == null) continue;
                changes.addAll(change);
            }
            if (!changes.isEmpty()) {
                RP.execute(new Runnable(){

                    @Override
                    public void run() {
                        block7: for (PhpModuleCustomizerExtender.Change change : changes) {
                            switch (change) {
                                case SOURCES_CHANGE: {
                                    PhpProjectProperties.this.project.getSourceRoots().fireChange();
                                    continue block7;
                                }
                                case TESTS_CHANGE: {
                                    PhpProjectProperties.this.project.getTestRoots().fireChange();
                                    continue block7;
                                }
                                case SELENIUM_CHANGE: {
                                    PhpProjectProperties.this.project.getSeleniumRoots().fireChange();
                                    continue block7;
                                }
                                case IGNORED_FILES_CHANGE: {
                                    PhpProjectProperties.this.project.fireIgnoredFilesChange();
                                    continue block7;
                                }
                                case FRAMEWORK_CHANGE: {
                                    PhpProjectProperties.this.project.resetFrameworks();
                                    continue block7;
                                }
                            }
                            throw new IllegalStateException("Unknown change: " + change);
                        }
                    }
                });
            }
        }
    }

    private String relativizeFile(String filePath) {
        if (StringUtils.hasText((String)filePath)) {
            File file = new File(filePath);
            String path = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
            if (path == null) {
                path = file.getAbsolutePath();
            }
            return path;
        }
        return "";
    }

    private String getActiveRunAsType() {
        return this.configManager.currentConfiguration().getValue(RUN_AS);
    }

    private int getNumOfRunConfigs() {
        int n = 0;
        for (String name : this.configManager.configurationNames()) {
            if (!this.configManager.exists(name)) continue;
            ++n;
        }
        return n;
    }

    private void logUsage(FileObject projectDir, FileObject sourceDir, String activeRunAsType, int numOfConfigs, boolean copyFiles) {
        PhpProjectUtils.logUsage(PhpProjectProperties.class, "USG_PROJECT_CONFIG_PHP", Arrays.asList(FileUtil.isParentOf((FileObject)projectDir, (FileObject)sourceDir) ? "EXTRA_SRC_DIR_NO" : "EXTRA_SRC_DIR_YES", activeRunAsType, Integer.toString(numOfConfigs), copyFiles ? "COPY_FILES_YES" : "COPY_FILES_NO"));
    }

    public PhpProject getProject() {
        return this.project;
    }

    Map<String, Map<String, String>> readRunConfigs() {
        Map<String, Map<String, String>> m = ConfigManager.createEmptyConfigs();
        TreeMap<String, String> def = new TreeMap<String, String>();
        EditableProperties privateProperties = this.getProject().getHelper().getProperties("nbproject/private/private.properties");
        EditableProperties projectProperties = this.getProject().getHelper().getProperties("nbproject/project.properties");
        for (String prop : CFG_PROPS) {
            String v = privateProperties.getProperty(prop);
            if (v == null) {
                v = projectProperties.getProperty(prop);
            }
            if (v == null) continue;
            def.put(prop, v);
        }
        m.put(null, def);
        FileObject configs = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (configs != null) {
            for (FileObject kid : configs.getChildren()) {
                if (!kid.hasExt("properties")) continue;
                String path = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid);
                m.put(kid.getName(), new TreeMap(this.getProject().getHelper().getProperties(path)));
            }
        }
        if ((configs = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject kid : configs.getChildren()) {
                Map<String, String> c;
                if (!kid.hasExt("properties") || (c = m.get(kid.getName())) == null) continue;
                String path = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid);
                c.putAll(new HashMap(this.getProject().getHelper().getProperties(path)));
            }
        }
        return m;
    }

    void storeRunConfigs(EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        ConfigManager.Configuration defaultConfiguration = this.configManager.defaultConfiguration();
        for (String prop : CFG_PROPS) {
            EditableProperties ep;
            String value = defaultConfiguration.getValue(prop);
            EditableProperties editableProperties = ep = this.isPrivateProperty(prop) ? privateProperties : projectProperties;
            if (Utilities.compareObjects((Object)value, (Object)ep.getProperty(prop))) continue;
            if (StringUtils.hasText((String)value)) {
                ep.setProperty(prop, value);
                continue;
            }
            ep.remove((Object)prop);
        }
        for (String name : this.configManager.configurationNames()) {
            if (name == null) continue;
            String sharedPath = "nbproject/configs/" + name + ".properties";
            String privatePath = "nbproject/private/configs/" + name + ".properties";
            if (!this.configManager.exists(name)) {
                this.getProject().getHelper().putProperties(sharedPath, null);
                this.getProject().getHelper().putProperties(privatePath, null);
                continue;
            }
            ConfigManager.Configuration configuration = this.configManager.configurationFor(name);
            for (String prop : CFG_PROPS) {
                String value = configuration.getValue(prop);
                String path = this.isPrivateProperty(prop) ? privatePath : sharedPath;
                EditableProperties ep = this.getProject().getHelper().getProperties(path);
                if (Utilities.compareObjects((Object)value, (Object)ep.getProperty(prop))) continue;
                if (value != null && (value.length() > 0 || StringUtils.hasText((String)defaultConfiguration.getValue(prop)))) {
                    ep.setProperty(prop, value);
                } else {
                    ep.remove((Object)prop);
                }
                this.getProject().getHelper().putProperties(path, ep);
            }
            this.getProject().getHelper().putProperties(sharedPath, this.getProject().getHelper().getProperties(sharedPath));
        }
    }

    private boolean isPrivateProperty(String property) {
        return true;
    }

    public static enum XDebugUrlArguments {
        XDEBUG_SESSION_START,
        XDEBUG_SESSION_STOP,
        XDEBUG_SESSION_STOP_NO_EXEC;

    }

    public static enum DebugUrl {
        DEFAULT_URL,
        ASK_FOR_URL,
        DO_NOT_OPEN_BROWSER;

    }

    public static enum UploadFiles {
        MANUALLY("LBL_UploadFilesManually", "TXT_UploadFilesManually"),
        ON_RUN("LBL_UploadFilesOnRun", "TXT_UploadFilesOnRun"),
        ON_SAVE("LBL_UploadFilesOnSave", "TXT_UploadFilesOnSave");

        private final String label;
        private final String description;

        private UploadFiles(String labelKey, String descriptionKey) {
            this.label = NbBundle.getMessage(PhpProjectProperties.class, (String)labelKey);
            this.description = NbBundle.getMessage(PhpProjectProperties.class, (String)descriptionKey);
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum RunAsType {
        LOCAL(Bundle.RunAsType_local_label()),
        SCRIPT(Bundle.RunAsType_script_label()),
        REMOTE(Bundle.RunAsType_remote_label()),
        INTERNAL(Bundle.RunAsType_internal_label());

        private final String label;

        private RunAsType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

