/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerPhpIncludePath
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 897213245757143454L;
    private final ProjectCustomizer.Category category;
    private final PhpProjectProperties uiProps;
    private final DefaultListModel includePathListModel;
    private JButton addFolderButton;
    private JLabel includePathInfoLabel;
    private JLabel includePathLabel;
    private JList includePathList;
    private JScrollPane includePathScrollPane;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;

    public CustomizerPhpIncludePath(ProjectCustomizer.Category category, PhpProjectProperties uiProps) {
        this.initComponents();
        this.category = category;
        this.uiProps = uiProps;
        this.includePathListModel = uiProps.getIncludePathListModel();
        PathUiSupport.EditMediator.FileChooserDirectoryHandler directoryHandler = new PathUiSupport.EditMediator.FileChooserDirectoryHandler(){

            @Override
            public String getDirKey() {
                return "nb.php.project.includePath";
            }

            @Override
            public File getCurrentDirectory() {
                return null;
            }
        };
        this.includePathList.setModel(this.includePathListModel);
        this.includePathList.setCellRenderer(uiProps.getIncludePathListRenderer());
        this.includePathListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                CustomizerPhpIncludePath.this.validateData();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                CustomizerPhpIncludePath.this.validateData();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                CustomizerPhpIncludePath.this.validateData();
            }
        });
        PathUiSupport.EditMediator.register(uiProps.getProject(), this.includePathList, this.addFolderButton.getModel(), this.removeButton.getModel(), this.moveUpButton.getModel(), this.moveDownButton.getModel(), directoryHandler);
    }

    void validateData() {
        for (int i = 0; i < this.includePathListModel.getSize(); ++i) {
            BasePathSupport.Item item = (BasePathSupport.Item)this.includePathListModel.getElementAt(i);
            if (item.getType() != BasePathSupport.Item.Type.FOLDER || item.isBroken()) continue;
            FileObject fileObject = item.getFileObject(this.uiProps.getProject().getProjectDirectory());
            if (fileObject == null) {
                this.category.setErrorMessage(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"MSG_NotFound", (Object)item.getFilePath()));
                this.category.setValid(false);
                return;
            }
            if (!CommandUtils.isUnderAnySourceGroup(this.uiProps.getProject(), fileObject, false)) continue;
            this.category.setErrorMessage(Bundle.CustomizerPhpIncludePath_error_projectFile(item.getAbsoluteFilePath(this.uiProps.getProject().getProjectDirectory())));
            this.category.setValid(false);
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private void initComponents() {
        this.includePathScrollPane = new JScrollPane();
        this.includePathList = new JList();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.includePathLabel = new JLabel();
        this.includePathInfoLabel = new JLabel();
        this.includePathScrollPane.setViewportView(this.includePathList);
        this.includePathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.includePathList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"LBL_AddFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"LBL_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"LBL_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"LBL_MoveDown"));
        this.includePathLabel.setLabelFor(this.includePathList);
        Mnemonics.setLocalizedText((JLabel)this.includePathLabel, (String)NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"LBL_PhpIncludePath"));
        Mnemonics.setLocalizedText((JLabel)this.includePathInfoLabel, (String)NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.includePathInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.includePathScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveDownButton).addComponent(this.moveUpButton).addComponent(this.removeButton).addComponent(this.addFolderButton))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includePathLabel).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.includePathInfoLabel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.addFolderButton, this.moveDownButton, this.moveUpButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.includePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addFolderButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton)).addComponent(this.includePathScrollPane, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.includePathInfoLabel, -2, -1, -2).addGap(0, 0, 0)));
        this.includePathScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.includePathScrollPane.AccessibleContext.accessibleName"));
        this.includePathScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.includePathScrollPane.AccessibleContext.accessibleDescription"));
        this.addFolderButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.addFolderButton.AccessibleContext.accessibleName"));
        this.addFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.addFolderButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.removeButton.AccessibleContext.accessibleName"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.removeButton.AccessibleContext.accessibleDescription"));
        this.moveUpButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.moveUpButton.AccessibleContext.accessibleName"));
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.moveUpButton.AccessibleContext.accessibleDescription"));
        this.moveDownButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.moveDownButton.AccessibleContext.accessibleName"));
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.moveDownButton.AccessibleContext.accessibleDescription"));
        this.includePathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.includePathLabel.AccessibleContext.accessibleName"));
        this.includePathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.includePathLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpIncludePath.class, (String)"CustomizerPhpIncludePath.AccessibleContext.accessibleDescription"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.ui.customizer.CustomizerPhpIncludePath");
    }
}

