/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.editor.indent.project.api.Customizers;
import org.netbeans.modules.php.api.framework.PhpFrameworks;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.customizer.CustomizerFramework;
import org.netbeans.modules.php.project.ui.customizer.CustomizerIgnorePath;
import org.netbeans.modules.php.project.ui.customizer.CustomizerPhpIncludePath;
import org.netbeans.modules.php.project.ui.customizer.CustomizerPhpUnit;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.CustomizerRun;
import org.netbeans.modules.php.project.ui.customizer.CustomizerSources;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CompositePanelProviderImpl
implements ProjectCustomizer.CompositeCategoryProvider {
    public static final String SOURCES = "Sources";
    public static final String RUN = "Run";
    public static final String PHP_INCLUDE_PATH = "PhpIncludePath";
    public static final String IGNORE_PATH = "IgnorePath";
    public static final String FRAMEWORKS = "Frameworks";
    public static final String PHP_UNIT = "PhpUnit";
    private final String name;
    private final Map<ProjectCustomizer.Category, PhpModuleCustomizerExtender> frameworkCategories;

    public CompositePanelProviderImpl(String name) {
        this.name = name;
        this.frameworkCategories = FRAMEWORKS.equals(name) ? new LinkedHashMap<ProjectCustomizer.Category, PhpModuleCustomizerExtender>() : null;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        ProjectCustomizer.Category toReturn = null;
        ProjectCustomizer.Category[] categories = null;
        if (SOURCES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)SOURCES, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_Sources"), null, categories);
        } else if (RUN.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)RUN, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_RunConfig"), null, categories);
        } else if (PHP_INCLUDE_PATH.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)PHP_INCLUDE_PATH, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_PhpIncludePath"), null, categories);
        } else if (IGNORE_PATH.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)IGNORE_PATH, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_IgnorePath"), null, categories);
        } else if (FRAMEWORKS.equals(this.name)) {
            this.fillFrameworkCategories((PhpProject)context.lookup(PhpProject.class));
            if (this.frameworkCategories.isEmpty()) {
                return null;
            }
            ArrayList<ProjectCustomizer.Category> subcategories = new ArrayList<ProjectCustomizer.Category>(this.frameworkCategories.keySet());
            toReturn = ProjectCustomizer.Category.create((String)FRAMEWORKS, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_Frameworks"), null, (ProjectCustomizer.Category[])subcategories.toArray(new ProjectCustomizer.Category[subcategories.size()]));
        } else if (PHP_UNIT.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)PHP_UNIT, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_PhpUnit"), null, categories);
        }
        assert (toReturn != null) : "No category for name: " + this.name;
        return toReturn;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        PhpModuleCustomizerExtender extender;
        String nm = category.getName();
        PhpProjectProperties uiProps = (PhpProjectProperties)context.lookup(PhpProjectProperties.class);
        if (SOURCES.equals(nm)) {
            return new CustomizerSources(category, uiProps);
        }
        if (RUN.equals(nm)) {
            return new CustomizerRun(uiProps, category);
        }
        if (PHP_INCLUDE_PATH.equals(nm)) {
            return new CustomizerPhpIncludePath(category, uiProps);
        }
        if (IGNORE_PATH.equals(nm)) {
            return new CustomizerIgnorePath(category, uiProps);
        }
        if (FRAMEWORKS.equals(nm)) {
            return new JPanel();
        }
        if (PHP_UNIT.equals(nm)) {
            return new CustomizerPhpUnit(category, uiProps);
        }
        if (this.frameworkCategories != null && (extender = this.frameworkCategories.get(category)) != null) {
            return new CustomizerFramework(category, extender, uiProps);
        }
        assert (false) : "No component found for " + category.getDisplayName();
        return new JPanel();
    }

    public static CompositePanelProviderImpl createSources() {
        return new CompositePanelProviderImpl(SOURCES);
    }

    public static CompositePanelProviderImpl createRunConfig() {
        return new CompositePanelProviderImpl(RUN);
    }

    public static CompositePanelProviderImpl createPhpIncludePath() {
        return new CompositePanelProviderImpl(PHP_INCLUDE_PATH);
    }

    public static CompositePanelProviderImpl createIgnorePath() {
        return new CompositePanelProviderImpl(IGNORE_PATH);
    }

    public static CompositePanelProviderImpl createFrameworks() {
        return new CompositePanelProviderImpl(FRAMEWORKS);
    }

    public static CompositePanelProviderImpl createPhpUnit() {
        return new CompositePanelProviderImpl(PHP_UNIT);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createFormatting() {
        return Customizers.createFormattingCategoryProvider(Collections.singletonMap("allowedMimeTypes", "text/x-php5"));
    }

    private void fillFrameworkCategories(PhpProject project) {
        this.frameworkCategories.clear();
        PhpModule phpModule = project.getPhpModule();
        int i = 0;
        for (PhpFrameworkProvider frameworkProvider : PhpFrameworks.getFrameworks()) {
            PhpModuleCustomizerExtender extender = frameworkProvider.createPhpModuleCustomizerExtender(phpModule);
            if (extender == null) continue;
            String categoryName = extender.getDisplayName();
            if (categoryName == null) {
                categoryName = frameworkProvider.getName();
            }
            ProjectCustomizer.Category category = ProjectCustomizer.Category.create((String)(FRAMEWORKS + i++), (String)categoryName, null, (ProjectCustomizer.Category[])null);
            this.frameworkCategories.put(category, extender);
        }
    }
}

