/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.codecoverage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProviderHelper;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.codecoverage.CoverageVO;
import org.netbeans.modules.php.project.ui.codecoverage.PhpFileCoverageDetails;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class PhpCoverageProvider
implements CoverageProvider {
    private static final Logger LOGGER = Logger.getLogger(PhpCoverageProvider.class.getName());
    private static final Set<String> MIME_TYPES = Collections.singleton("text/x-php5");
    private final Object lock = new Object();
    private final PhpProject project;
    private final PhpVisibilityQuery phpVisibilityQuery;
    private Boolean enabled = null;
    private CoverageVO coverage = null;

    public PhpCoverageProvider(PhpProject project) {
        assert (project != null);
        this.project = project;
        this.phpVisibilityQuery = PhpVisibilityQuery.forProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoverage(CoverageVO coverage) {
        assert (coverage != null);
        assert (this.isEnabled()) : "Coverage provider must be enabled";
        Object object = this.lock;
        synchronized (object) {
            this.coverage = coverage;
        }
        CoverageManager.INSTANCE.resultsUpdated((Project)this.project, (CoverageProvider)this);
    }

    public void updateCoverage(CoverageVO partialCoverage) {
        assert (partialCoverage != null);
        assert (this.isEnabled()) : "Coverage provider must be enabled";
        CoverageVO newCoverage = this.getCoverage();
        if (newCoverage == null) {
            this.setCoverage(partialCoverage);
            return;
        }
        List<CoverageVO.FileVO> originalFiles = newCoverage.getFiles();
        for (CoverageVO.FileVO file : partialCoverage.getFiles()) {
            boolean newFile = true;
            for (int i = 0; i < originalFiles.size(); ++i) {
                if (!file.getPath().equals(originalFiles.get(i).getPath())) continue;
                originalFiles.set(i, file);
                newFile = false;
                break;
            }
            if (!newFile) continue;
            originalFiles.add(file);
        }
        this.setCoverage(newCoverage);
    }

    public static void notifyProjectOpened(Project project) {
        CoverageManager.INSTANCE.setEnabled(project, true);
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return false;
    }

    public synchronized boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = CoverageProviderHelper.isEnabled((Project)this.project);
        }
        return this.enabled;
    }

    public synchronized void setEnabled(boolean on) {
        if (this.enabled != null && on == this.enabled) {
            return;
        }
        this.enabled = on;
        CoverageProviderHelper.setEnabled((Project)this.project, (boolean)on);
    }

    public boolean isAggregating() {
        throw new IllegalStateException("Aggregating is not supported");
    }

    public void setAggregating(boolean on) {
        throw new IllegalStateException("Aggregating is not supported");
    }

    public Set<String> getMimeTypes() {
        return MIME_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.coverage = null;
        }
    }

    public FileCoverageDetails getDetails(FileObject fo, Document doc) {
        assert (fo != null);
        CoverageVO cov = this.getCoverage();
        if (cov == null) {
            return null;
        }
        if (!this.isUnderneathSourcesOnlyAndVisible(fo)) {
            return null;
        }
        String path = FileUtil.toFile((FileObject)fo).getAbsolutePath();
        for (CoverageVO.FileVO file : cov.getFiles()) {
            if (!path.equals(file.getPath())) continue;
            return new PhpFileCoverageDetails(fo, file);
        }
        return null;
    }

    public List<FileCoverageSummary> getResults() {
        CoverageVO cov = this.getCoverage();
        if (cov == null) {
            return null;
        }
        ArrayList<FileCoverageSummary> result = new ArrayList<FileCoverageSummary>(cov.getFiles().size());
        for (CoverageVO.FileVO file : cov.getFiles()) {
            if (!this.isUnderneathSourcesOnlyAndVisible(file.getPath())) continue;
            result.add(PhpCoverageProvider.getFileCoverageSummary(file));
        }
        return result;
    }

    public String getTestAllAction() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoverageVO getCoverage() {
        CoverageVO cov = null;
        Object object = this.lock;
        synchronized (object) {
            cov = this.coverage;
        }
        return cov;
    }

    static FileCoverageSummary getFileCoverageSummary(CoverageVO.FileVO file) {
        assert (file != null);
        FileObject fo = FileUtil.toFileObject((File)new File(file.getPath()));
        return new FileCoverageSummary(fo, fo.getNameExt(), file.getMetrics().statements, file.getMetrics().coveredStatements, -1, -1);
    }

    private boolean isUnderneathSourcesOnlyAndVisible(String path) {
        return this.isUnderneathSourcesOnlyAndVisible(FileUtil.toFileObject((File)new File(path)));
    }

    private boolean isUnderneathSourcesOnlyAndVisible(FileObject fo) {
        return fo != null && fo.isValid() && CommandUtils.isUnderSources(this.project, fo) && !CommandUtils.isUnderTests(this.project, fo, false) && !CommandUtils.isUnderSelenium(this.project, fo, false) && this.phpVisibilityQuery.isVisible(fo);
    }
}

