/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.codecoverage;

import java.util.ArrayList;
import java.util.List;

public final class CoverageVO {
    private final List<FileVO> files = new ArrayList<FileVO>();
    private long generated = -1L;
    private String phpUnitVersion;
    private CoverageMetricsVO metrics;

    public long getGenerated() {
        return this.generated;
    }

    public void setGenerated(long generated) {
        assert (this.generated == -1L);
        this.generated = generated;
    }

    public String getPhpUnitVersion() {
        return this.phpUnitVersion;
    }

    public void setPhpUnitVersion(String phpUnitVersion) {
        assert (this.phpUnitVersion == null);
        this.phpUnitVersion = phpUnitVersion;
    }

    public CoverageMetricsVO getMetrics() {
        return this.metrics;
    }

    public void setMetrics(CoverageMetricsVO metrics) {
        assert (metrics != null);
        assert (this.metrics == null);
        this.metrics = metrics;
    }

    public List<FileVO> getFiles() {
        return this.files;
    }

    public void addFile(FileVO file) {
        assert (file != null);
        this.files.add(file);
    }

    public static class CoverageMetricsVO
    extends FileMetricsVO {
        public final int files;

        public CoverageMetricsVO(int files, int loc, int ncloc, int classes, int methods, int coveredMethods, int statements, int coveredStatements, int elements, int coveredElements) {
            super(loc, ncloc, classes, methods, coveredMethods, statements, coveredStatements, elements, coveredElements);
            this.files = files;
        }

        @Override
        public String toString() {
            return String.format("CoverageMetricsVO{files: %d, loc: %d, ncloc: %d, classes: %d, methods: %d, coveredMethods: %d, statements: %d, coveredStatements: %d, elements: %d, coveredElements: %d}", this.files, this.loc, this.ncloc, this.classes, this.methods, this.coveredMethods, this.statements, this.coveredStatements, this.elements, this.coveredElements);
        }
    }

    public static class FileMetricsVO
    extends ClassMetricsVO {
        public final int loc;
        public final int ncloc;
        public final int classes;

        public FileMetricsVO(int loc, int ncloc, int classes, int methods, int coveredMethods, int statements, int coveredStatements, int elements, int coveredElements) {
            super(methods, coveredMethods, statements, coveredStatements, elements, coveredElements);
            this.loc = loc;
            this.ncloc = ncloc;
            this.classes = classes;
        }

        @Override
        public String toString() {
            return String.format("FileMetricsVO{loc: %d, ncloc: %d, classes: %d, methods: %d, coveredMethods: %d, statements: %d, coveredStatements: %d, elements: %d, coveredElements: %d}", this.loc, this.ncloc, this.classes, this.methods, this.coveredMethods, this.statements, this.coveredStatements, this.elements, this.coveredElements);
        }
    }

    public static class ClassMetricsVO {
        public final int methods;
        public final int coveredMethods;
        public final int statements;
        public final int coveredStatements;
        public final int elements;
        public final int coveredElements;

        public ClassMetricsVO(int methods, int coveredMethods, int statements, int coveredStatements, int elements, int coveredElements) {
            this.methods = methods;
            this.coveredMethods = coveredMethods;
            this.statements = statements;
            this.coveredStatements = coveredStatements;
            this.elements = elements;
            this.coveredElements = coveredElements;
        }

        public String toString() {
            return String.format("ClassMetricsVO{methods: %d, coveredMethods: %d, statements: %d, coveredStatements: %d, elements: %d, coveredElements: %d}", this.methods, this.coveredMethods, this.statements, this.coveredStatements, this.elements, this.coveredElements);
        }
    }

    public static final class LineVO {
        public final int num;
        public final String type;
        public final int count;

        public LineVO(int num, String type, int count) {
            this.num = num;
            this.type = type;
            this.count = count;
        }
    }

    public static final class ClassVO {
        private final String name;
        private final String namespace;
        private ClassMetricsVO metrics;

        public ClassVO(String name, String namespace) {
            assert (name != null);
            assert (namespace != null);
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public ClassMetricsVO getMetrics() {
            return this.metrics;
        }

        public void setMetrics(ClassMetricsVO metrics) {
            assert (metrics != null);
            assert (this.metrics == null);
            this.metrics = metrics;
        }

        public String toString() {
            return String.format("ClassVO{name: %s, namespace: %s, classMetrics: %s}", this.name, this.namespace, this.metrics);
        }
    }

    public static final class FileVO {
        private final String path;
        private final List<ClassVO> classes = new ArrayList<ClassVO>();
        private final List<LineVO> lines = new ArrayList<LineVO>();
        private FileMetricsVO metrics;

        public FileVO(String path) {
            assert (path != null);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public FileMetricsVO getMetrics() {
            return this.metrics;
        }

        public void setMetrics(FileMetricsVO metrics) {
            assert (metrics != null);
            assert (this.metrics == null);
            this.metrics = metrics;
        }

        public List<ClassVO> getClasses() {
            return this.classes;
        }

        public void addClass(ClassVO clazz) {
            assert (clazz != null);
            this.classes.add(clazz);
        }

        public List<LineVO> getLines() {
            return this.lines;
        }

        public void addLine(LineVO line) {
            assert (line != null);
            this.lines.add(line);
        }
    }
}

