/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.phpunit.PhpUnitSkelGen;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public final class CreateTestsAction
extends NodeAction {
    private static final long serialVersionUID = -468532132435473111L;
    private static final Logger LOGGER = Logger.getLogger(CreateTestsAction.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("Generate PHP Unit tests", 1);
    static final Queue<Runnable> RUNNABLES = new ConcurrentLinkedQueue<Runnable>();
    private static final RequestProcessor.Task TASK = RP.create(new Runnable(){

        @Override
        public void run() {
            Runnable toRun = RUNNABLES.poll();
            while (toRun != null) {
                toRun.run();
                toRun = RUNNABLES.poll();
            }
        }
    }, true);

    public CreateTestsAction() {
        this.putValue("noIconInMenu", true);
    }

    public boolean asynchronous() {
        return true;
    }

    protected void performAction(final Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return;
        }
        final PhpProject phpProject = PhpProjectUtils.getPhpProject(activatedNodes[0]);
        assert (phpProject != null) : "PHP project must be found for " + activatedNodes[0];
        PhpUnitSkelGen skelGen = CommandUtils.getPhpUnitSkelGen(false);
        PhpUnit phpUnit = CommandUtils.getPhpUnit(phpProject, false);
        if (skelGen == null && phpUnit == null) {
            CommandUtils.getPhpUnitSkelGen(true);
            return;
        }
        if (ProjectPropertiesSupport.getTestDirectory(phpProject, true) == null) {
            return;
        }
        RUNNABLES.add(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CreateTestsAction.class, (String)"LBL_CreatingTests"));
                handle.start();
                try {
                    LifecycleManager.getDefault().saveAll();
                    CreateTestsAction.this.generateTests(activatedNodes, phpProject);
                }
                finally {
                    handle.finish();
                }
            }
        });
        TASK.schedule(0);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        PhpProject onlyOneProjectAllowed = null;
        for (Node node : activatedNodes) {
            FileObject fileObj = CommandUtils.getFileObject(node);
            if (fileObj == null) {
                return false;
            }
            if (fileObj.isData() && !FileUtils.isPhpFile((FileObject)fileObj)) {
                return false;
            }
            PhpProject phpProject = PhpProjectUtils.getPhpProject(fileObj);
            if (phpProject == null) {
                return false;
            }
            if (PhpProjectValidator.isFatallyBroken(phpProject)) {
                return false;
            }
            if (onlyOneProjectAllowed == null) {
                onlyOneProjectAllowed = phpProject;
            } else if (!onlyOneProjectAllowed.equals(phpProject)) {
                return false;
            }
            if (CommandUtils.isUnderSources(phpProject, fileObj) && !CommandUtils.isUnderTests(phpProject, fileObj, false)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(CreateTestsAction.class, (String)"LBL_CreateTests");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    void generateTests(Node[] activatedNodes, final PhpProject phpProject) {
        assert (phpProject != null);
        final List<FileObject> files = CommandUtils.getFileObjects(activatedNodes);
        assert (!files.isEmpty()) : "No files for tests?!";
        final HashSet proceeded = new HashSet();
        final HashSet<FileObject> failed = new HashSet<FileObject>();
        final HashSet<File> toOpen = new HashSet<File>();
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PhpVisibilityQuery phpVisibilityQuery = PhpVisibilityQuery.forProject(phpProject);
                    for (FileObject fo : files) {
                        CreateTestsAction.this.generateTest(phpProject, phpVisibilityQuery, fo, proceeded, failed, toOpen);
                        Enumeration children = fo.getChildren(true);
                        while (children.hasMoreElements()) {
                            CreateTestsAction.this.generateTest(phpProject, phpVisibilityQuery, (FileObject)children.nextElement(), proceeded, failed, toOpen);
                        }
                    }
                }
                catch (ExecutionException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    UiUtils.processExecutionException((ExecutionException)ex);
                }
            }
        });
        this.showFailures(failed);
        this.reformat(toOpen);
        this.open(toOpen);
        this.refreshTests(ProjectPropertiesSupport.getTestDirectory(phpProject, false));
    }

    private void generateTest(PhpProject phpProject, PhpVisibilityQuery phpVisibilityQuery, FileObject sourceFo, Set<FileObject> proceeded, Set<FileObject> failed, Set<File> toOpen) throws ExecutionException {
        if (sourceFo.isFolder() || !FileUtils.isPhpFile((FileObject)sourceFo) || proceeded.contains(sourceFo) || CommandUtils.isUnderTests(phpProject, sourceFo, false) || CommandUtils.isUnderSelenium(phpProject, sourceFo, false) || !PhpProjectUtils.isVisible(phpVisibilityQuery, sourceFo)) {
            return;
        }
        proceeded.add(sourceFo);
        TestGenerator testGenerator = this.getTestGenerator(phpProject, sourceFo);
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null) : "Editor support must exist";
        Collection classes = editorSupport.getClasses(sourceFo);
        if (classes.isEmpty()) {
            failed.add(sourceFo);
            return;
        }
        for (PhpClass phpClass : classes) {
            File testFile = testGenerator.generateTest(phpClass);
            if (testFile != null) {
                toOpen.add(testFile);
                continue;
            }
            failed.add(sourceFo);
        }
    }

    private TestGenerator getTestGenerator(PhpProject phpProject, FileObject source) {
        PhpUnit.ConfigFiles configFiles = PhpUnit.getConfigFiles(phpProject, false);
        PhpUnitSkelGen skelGen = CommandUtils.getPhpUnitSkelGen(false);
        if (skelGen != null) {
            LOGGER.log(Level.FINE, "Using phpunit-skel-gen for generating a test for {0}", source.getNameExt());
            return new PhpUnitSkelGenTestGenerator(skelGen, phpProject, source, configFiles);
        }
        LOGGER.log(Level.FINE, "Using phpunit-skel-gen for generating a test for {0}", source.getNameExt());
        PhpUnit phpUnit = CommandUtils.getPhpUnit(phpProject, false);
        File parent = FileUtil.toFile((FileObject)source.getParent());
        File workingDirectory = phpUnit.getWorkingDirectory(configFiles, parent);
        return new PhpUnitTestGenerator(phpUnit, phpProject, source, configFiles, workingDirectory);
    }

    private void showFailures(Set<FileObject> files) {
        if (files.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(50);
        for (FileObject file : files) {
            sb.append(file.getNameExt());
            sb.append("\n");
        }
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateTestsAction.class, (String)"MSG_TestNotGenerated", (Object)sb.toString()), 2));
    }

    private void reformat(Set<File> files) {
        for (File file : files) {
            try {
                PhpProjectUtils.reformatFile(file);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Cannot reformat file " + file, ex);
            }
        }
    }

    private void open(Set<File> files) {
        for (File file : files) {
            assert (file.isFile()) : "File must be given to open: " + file;
            PhpProjectUtils.openFile(file);
        }
    }

    private void refreshTests(final FileObject testDir) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])new File[]{FileUtil.toFile((FileObject)testDir)});
            }
        });
    }

    private static final class PhpUnitSkelGenTestGenerator
    implements TestGenerator {
        private final PhpUnitSkelGen skelGen;
        private final PhpProject phpProject;
        private final FileObject source;
        private final PhpUnit.ConfigFiles configFiles;

        public PhpUnitSkelGenTestGenerator(PhpUnitSkelGen skelGen, PhpProject phpProject, FileObject source, PhpUnit.ConfigFiles configFiles) {
            this.skelGen = skelGen;
            this.phpProject = phpProject;
            this.source = source;
            this.configFiles = configFiles;
        }

        @Override
        public File generateTest(PhpClass phpClass) {
            return this.skelGen.generateTest(this.configFiles, phpClass.getFullyQualifiedName(), FileUtil.toFile((FileObject)this.source), phpClass.getFullyQualifiedName() + "Test", PhpUnit.getTestFile(this.phpProject, this.source, phpClass.getName()));
        }
    }

    private static final class PhpUnitTestGenerator
    implements TestGenerator {
        private final PhpUnit phpUnit;
        private final PhpProject phpProject;
        private final FileObject source;
        private final PhpUnit.ConfigFiles configFiles;
        private final File workingDirectory;

        public PhpUnitTestGenerator(PhpUnit phpUnit, PhpProject phpProject, FileObject source, PhpUnit.ConfigFiles configFiles, File workingDirectory) {
            this.phpUnit = phpUnit;
            this.phpProject = phpProject;
            this.source = source;
            this.configFiles = configFiles;
            this.workingDirectory = workingDirectory;
        }

        @Override
        public File generateTest(PhpClass phpClass) {
            return this.phpUnit.generateTest(this.phpProject, this.configFiles, phpClass, this.source, this.workingDirectory);
        }
    }

    private static interface TestGenerator {
        public File generateTest(PhpClass var1);
    }
}

