/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpInterpreter;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.ui.actions.support.FileRunner;
import org.netbeans.modules.php.project.ui.actions.support.RunFilePanel;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public class RunFileActionProvider
implements ActionProvider {
    private static final Map<File, RunFileArgs> ARGS_FOR_FILE = new HashMap<File, RunFileArgs>();

    public String[] getSupportedActions() {
        return new String[]{"run.single", "debug.single"};
    }

    public boolean isActionEnabled(String command, Lookup context) {
        Project p = (Project)context.lookup(Project.class);
        if (p != null) {
            return false;
        }
        Collection files = context.lookupAll(DataObject.class);
        if (files.isEmpty()) {
            return false;
        }
        for (DataObject d : files) {
            if (FileUtils.isPhpFile((FileObject)d.getPrimaryFile())) continue;
            return false;
        }
        return !"debug.single".equals(command) || XDebugStarterFactory.getInstance() != null;
    }

    public void invokeAction(String command, Lookup context) {
        boolean debug = "debug.single".equals(command);
        for (DataObject dataObject : context.lookupAll(DataObject.class)) {
            File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            if (file == null) continue;
            PhpProjectUtils.saveFile(dataObject);
            this.runFile(file, debug);
        }
    }

    private void runFile(File file, boolean debug) {
        RunFileArgs runFileArgs;
        RunFileArgs existing = ARGS_FOR_FILE.get(file);
        if (existing != null && !existing.displayDialog) {
            this.doRun(file, existing, debug);
            return;
        }
        if (existing == null) {
            existing = new RunFileArgs(null, file.getParent(), null, true);
        }
        if ((runFileArgs = RunFilePanel.open(existing, file, debug)) == null) {
            return;
        }
        ARGS_FOR_FILE.put(file, runFileArgs);
        this.doRun(file, runFileArgs, debug);
    }

    private void doRun(File file, RunFileArgs args, boolean debug) {
        FileRunner fileRunner = this.createFileRunner(file, args);
        if (fileRunner == null) {
            return;
        }
        if (debug) {
            fileRunner.debug();
        } else {
            fileRunner.run();
        }
    }

    private FileRunner createFileRunner(File file, RunFileArgs args) {
        PhpInterpreter phpInterpreter;
        try {
            phpInterpreter = PhpInterpreter.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            UiUtils.invalidScriptProvided((String)ex.getLocalizedMessage());
            return null;
        }
        return new FileRunner(file).command(phpInterpreter.getInterpreter()).workDir(args.getWorkDir()).phpArgs(args.getPhpOpts()).fileArgs(args.getRunArgs());
    }

    static final class RunFileArgs {
        private final String runArgs;
        private final String workDir;
        private final String phpOpts;
        private final boolean displayDialog;

        public RunFileArgs(String runArgs, String workDir, String phpOpts, boolean displayDialog) {
            this.runArgs = runArgs;
            this.workDir = workDir;
            this.phpOpts = phpOpts;
            this.displayDialog = displayDialog;
        }

        public String getRunArgs() {
            return this.runArgs;
        }

        public boolean displayDialog() {
            return this.displayDialog;
        }

        public String getWorkDir() {
            return this.workDir;
        }

        public String getPhpOpts() {
            return this.phpOpts;
        }
    }
}

