/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpInterpreter;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.support.Bundle;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public final class FileRunner {
    static final Logger LOGGER = Logger.getLogger(FileRunner.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(FileRunner.class);
    private static final ExecutionDescriptor.LineConvertorFactory PHP_LINE_CONVERTOR_FACTORY = new PhpLineConvertorFactory();
    private static final Project DUMMY_PROJECT = new DummyProject();
    final File file;
    PhpProject project;
    volatile String command;
    volatile String phpArgs;
    volatile String fileArgs;
    volatile String workDir;
    volatile boolean debug = false;

    public FileRunner(File file) {
        this.file = file;
    }

    public synchronized FileRunner project(PhpProject project) {
        this.project = project;
        return this;
    }

    public FileRunner command(String command) {
        this.command = command;
        return this;
    }

    public FileRunner phpArgs(String phpArgs) {
        this.phpArgs = phpArgs;
        return this;
    }

    public FileRunner fileArgs(String fileArgs) {
        this.fileArgs = fileArgs;
        return this;
    }

    public FileRunner workDir(String workDir) {
        this.workDir = workDir;
        return this;
    }

    public void run() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    FileRunner.this.getRunCallable(Bundle.FileRunner_run_displayName(FileRunner.this.getDisplayName()), false).call();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
            }
        });
    }

    public void debug() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    FileRunner.this.debugInternal();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
            }
        });
    }

    Callable<Cancellable> getRunCallable(final String displayName, final boolean debug) {
        return new Callable<Cancellable>(){

            @Override
            public Cancellable call() {
                File tmpFile;
                assert (!EventQueue.isDispatchThread());
                PhpExecutable executable = new PhpExecutable(FileRunner.this.command);
                if (StringUtils.hasText((String)FileRunner.this.workDir)) {
                    executable.workDir(new File(FileRunner.this.workDir));
                } else {
                    executable.workDir(FileRunner.this.file.getParentFile());
                }
                PostExecution postExecution = null;
                if (FileRunner.this.getRedirectToFile() && (tmpFile = FileRunner.this.createTempFile()) != null) {
                    executable.fileOutput(tmpFile, false);
                    postExecution = new PostExecution(tmpFile);
                }
                executable.displayName(displayName).viaAutodetection(false).viaPhpInterpreter(false).additionalParameters(FileRunner.this.getParams());
                if (debug) {
                    executable.environmentVariables(Collections.singletonMap("XDEBUG_CONFIG", "idekey=" + PhpOptions.getInstance().getDebuggerSessionId()));
                }
                final Future result = executable.run(FileRunner.this.getDescriptor(postExecution, !debug));
                return new Cancellable(){

                    public boolean cancel() {
                        return result.cancel(true);
                    }
                };
            }
        };
    }

    private void debugInternal() {
        XDebugStarter dbgStarter = XDebugStarterFactory.getInstance();
        assert (dbgStarter != null);
        if (dbgStarter.isAlreadyRunning()) {
            if (CommandUtils.warnNoMoreDebugSession()) {
                dbgStarter.stop();
                this.debugInternal();
            }
        } else {
            Callable<Cancellable> callable = this.getRunCallable(Bundle.FileRunner_debug_displayName(this.getDisplayName()), true);
            XDebugStarter.Properties props = XDebugStarter.Properties.create(FileUtil.toFileObject((File)this.file), true, Collections.<Pair<String, String>>emptyList(), null, this.getEncoding());
            dbgStarter.start(this.project != null ? this.project : DUMMY_PROJECT, callable, props);
        }
    }

    synchronized String getDisplayName() {
        return this.project != null ? this.project.getName() : this.file.getName();
    }

    private List<String> getParams() {
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.hasText((String)this.phpArgs)) {
            params.addAll(Arrays.asList(Utilities.parseParameters((String)this.phpArgs)));
        }
        params.add(this.file.getAbsolutePath());
        if (StringUtils.hasText((String)this.fileArgs)) {
            params.addAll(Arrays.asList(Utilities.parseParameters((String)this.fileArgs)));
        }
        return params;
    }

    ExecutionDescriptor getDescriptor(Runnable postExecution, boolean controllable) {
        ExecutionDescriptor descriptor = PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.charset(Charset.forName(this.getEncoding())).controllable(controllable).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory").outConvertorFactory(PHP_LINE_CONVERTOR_FACTORY);
        if (!this.getPhpOptions().isOpenResultInOutputWindow()) {
            descriptor = descriptor.inputOutput(InputOutput.NULL).frontWindow(false).frontWindowOnError(false);
        }
        if (postExecution != null) {
            descriptor = descriptor.postExecution(postExecution);
        }
        return descriptor;
    }

    private String getEncoding() {
        return this.project != null ? ProjectPropertiesSupport.getEncoding(this.project) : FileEncodingQuery.getDefaultEncoding().name();
    }

    boolean getRedirectToFile() {
        return this.getPhpOptions().isOpenResultInBrowser() || this.getPhpOptions().isOpenResultInEditor();
    }

    File createTempFile() {
        try {
            File tmpFile = File.createTempFile(this.file.getName(), ".html");
            tmpFile.deleteOnExit();
            return tmpFile;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    private PhpOptions getPhpOptions() {
        return PhpOptions.getInstance();
    }

    private static final class DummyProject
    implements Project {
        private DummyProject() {
        }

        public FileObject getProjectDirectory() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    }

    private static final class PostExecution
    implements Runnable {
        private final File tmpFile;

        public PostExecution(File tmpFile) {
            this.tmpFile = tmpFile;
        }

        @Override
        public void run() {
            PhpOptions options = PhpOptions.getInstance();
            try {
                if (options.isOpenResultInBrowser()) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(Utilities.toURI((File)this.tmpFile).toURL());
                }
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            if (options.isOpenResultInEditor()) {
                PhpProjectUtils.openFile(this.tmpFile);
            }
        }
    }

    private static final class PhpLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        private PhpLineConvertorFactory() {
        }

        public LineConvertor newLineConvertor() {
            LineConvertor[] lineConvertors = new LineConvertor[PhpInterpreter.LINE_PATTERNS.length];
            int i = 0;
            for (Pattern linePattern : PhpInterpreter.LINE_PATTERNS) {
                lineConvertors[i++] = LineConvertors.filePattern(null, (Pattern)linePattern, null, (int)1, (int)2);
            }
            return LineConvertors.proxy((LineConvertor[])lineConvertors);
        }
    }
}

