/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.deprecated.PhpProgram;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.phpunit.PhpUnitTestGroupsFetcher;
import org.netbeans.modules.php.project.phpunit.PhpUnitTestRunInfo;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.DebugScript;
import org.netbeans.modules.php.project.ui.actions.support.RunScript;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.codecoverage.CoverageVO;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.netbeans.modules.php.project.ui.codecoverage.PhpUnitCoverageLogParser;
import org.netbeans.modules.php.project.ui.testrunner.UnitTestRunner;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class ConfigActionTest
extends ConfigAction {
    static final ExecutionDescriptor.LineConvertorFactory PHPUNIT_LINE_CONVERTOR_FACTORY = new PhpUnitLineConvertorFactory();
    final PhpCoverageProvider coverageProvider;

    protected ConfigActionTest(PhpProject project) {
        super(project);
        this.coverageProvider = (PhpCoverageProvider)project.getLookup().lookup(PhpCoverageProvider.class);
        assert (this.coverageProvider != null);
    }

    protected FileObject getTestDirectory(boolean showCustomizer) {
        return ProjectPropertiesSupport.getTestDirectory(this.project, showCustomizer);
    }

    protected boolean isCoverageEnabled() {
        return this.coverageProvider.isEnabled();
    }

    @Override
    public boolean isProjectValid() {
        throw new IllegalStateException("Validation is not needed for tests");
    }

    @Override
    public boolean isFileValid() {
        throw new IllegalStateException("Validation is not needed for tests");
    }

    @Override
    public boolean isDebugProjectEnabled() {
        throw new IllegalStateException("Debug project tests action is not supported");
    }

    @Override
    public boolean isRunFileEnabled(Lookup context) {
        FileObject file = CommandUtils.fileForContextOrSelectedNodes(context);
        return file != null && FileUtils.isPhpFile((FileObject)file);
    }

    @Override
    public boolean isDebugFileEnabled(Lookup context) {
        if (XDebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(context);
    }

    @Override
    public void runProject() {
        FileObject testDirectory = this.getTestDirectory(true);
        if (testDirectory == null) {
            return;
        }
        if (!this.isPhpUnitValid()) {
            return;
        }
        this.run(this.getPhpUnitTestRunInfo(null));
    }

    @Override
    public void debugProject() {
        throw new IllegalStateException("Debug project tests action is not supported");
    }

    @Override
    public void runFile(Lookup context) {
        if (!this.isPhpUnitValid()) {
            return;
        }
        this.run(this.getPhpUnitTestRunInfo(context));
    }

    @Override
    public void debugFile(Lookup context) {
        if (!this.isPhpUnitValid()) {
            return;
        }
        this.debug(this.getPhpUnitTestRunInfo(context));
    }

    private boolean isPhpUnitValid() {
        return CommandUtils.getPhpUnit(this.project, true) != null;
    }

    void run(PhpUnitTestRunInfo info) {
        if (info == null) {
            return;
        }
        if (!info.isRerun() && ProjectPropertiesSupport.askForTestGroups(this.project)) {
            PhpUnit.ConfigFiles configFiles;
            PhpUnitTestGroupsFetcher testGroupsFetcher = new PhpUnitTestGroupsFetcher(this.project);
            PhpUnit phpUnit = CommandUtils.getPhpUnit(this.project, false);
            boolean success = testGroupsFetcher.fetch(phpUnit.getWorkingDirectory(configFiles = PhpUnit.getConfigFiles(this.project, false), FileUtil.toFile((FileObject)info.getWorkingDirectory())), configFiles);
            if (!success) {
                return;
            }
            if (testGroupsFetcher.wasInterrupted()) {
                return;
            }
            testGroupsFetcher.saveSelectedTestGroups();
        }
        new RunScript(new RunScriptProvider(info)).run();
    }

    void debug(PhpUnitTestRunInfo info) {
        if (info == null) {
            return;
        }
        new DebugScript(new DebugScriptProvider(info)).run();
    }

    private PhpUnitTestRunInfo getPhpUnitTestRunInfo(Lookup context) {
        PhpUnit phpUnit = CommandUtils.getPhpUnit(this.project, true);
        if (phpUnit == null) {
            return null;
        }
        if (context == null) {
            FileObject testDirectory = this.getTestDirectory(true);
            if (testDirectory == null) {
                return null;
            }
            return this.getProjectPhpUnitRunInfo(testDirectory);
        }
        return this.getFilePhpUnitRunInfo(context);
    }

    private PhpUnitTestRunInfo getProjectPhpUnitRunInfo(FileObject testDirectory) {
        return new PhpUnitTestRunInfo(testDirectory, testDirectory, null);
    }

    private PhpUnitTestRunInfo getFilePhpUnitRunInfo(Lookup context) {
        String name;
        FileObject workDir;
        assert (context != null);
        FileObject testDirectory = null;
        if (!ProjectPropertiesSupport.runAllTestFilesUsingPhpUnit(this.project) && (testDirectory = this.getTestDirectory(true)) == null) {
            return null;
        }
        FileObject fileObj = null;
        fileObj = testDirectory != null ? CommandUtils.fileForContextOrSelectedNodes(context, testDirectory) : CommandUtils.fileForContextOrSelectedNodes(context);
        assert (fileObj != null) : "Fileobject not found for context: " + context + " and test directory: " + testDirectory;
        if (!fileObj.isValid()) {
            return null;
        }
        if (fileObj.isFolder()) {
            workDir = fileObj;
            name = fileObj.getNameExt();
        } else {
            workDir = fileObj.getParent();
            name = fileObj.getName();
        }
        return new PhpUnitTestRunInfo(workDir, fileObj, name);
    }

    static final class PhpUnitLineConvertorFactory
    implements ExecutionDescriptor.LineConvertorFactory {
        PhpUnitLineConvertorFactory() {
        }

        public LineConvertor newLineConvertor() {
            return LineConvertors.filePattern(null, (Pattern)PhpUnit.LINE_PATTERN, null, (int)1, (int)2);
        }
    }

    private class RedebugUnitTestHandler
    extends RerunUnitTestHandler {
        public RedebugUnitTestHandler(PhpUnitTestRunInfo info) {
            super(info);
        }

        @Override
        protected void rerunInternal() {
            ConfigActionTest.this.debug(this.info);
        }
    }

    private class RerunUnitTestHandler
    implements RerunHandler {
        protected final PhpUnitTestRunInfo info;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private volatile boolean enabled = false;

        public RerunUnitTestHandler(PhpUnitTestRunInfo info) {
            assert (info != null);
            this.info = info;
            info.setRerun(true);
        }

        public final void rerun() {
            PhpActionProvider.submitTask(new Runnable(){

                @Override
                public void run() {
                    RerunUnitTestHandler.this.rerunInternal();
                }
            });
        }

        protected void rerunInternal() {
            ConfigActionTest.this.run(this.info);
        }

        public void rerun(Set<Testcase> tests) {
            this.info.setCustomTests(tests);
            this.rerun();
        }

        public boolean enabled(RerunType type) {
            boolean supportedType = false;
            switch (type) {
                case ALL: 
                case CUSTOM: {
                    supportedType = true;
                    break;
                }
                default: {
                    assert (false) : "Unknown RerunType: " + type;
                    break;
                }
            }
            return supportedType && this.enabled;
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        void enable() {
            if (!this.enabled) {
                this.enabled = true;
                this.changeSupport.fireChange();
            }
        }

        void disable() {
            if (this.enabled) {
                this.enabled = false;
                this.changeSupport.fireChange();
            }
        }
    }

    private final class DebugScriptProvider
    extends RunScriptProvider
    implements DebugScript.Provider {
        public DebugScriptProvider(PhpUnitTestRunInfo info) {
            super(info);
        }

        @Override
        public PhpProject getProject() {
            return ConfigActionTest.this.project;
        }

        @Override
        public FileObject getStartFile() {
            return this.info.getStartFile();
        }

        @Override
        protected RerunUnitTestHandler getRerunUnitTestHandler() {
            return new RedebugUnitTestHandler(this.info);
        }

        @Override
        protected UnitTestRunner getTestRunner() {
            assert (this.rerunUnitTestHandler instanceof RedebugUnitTestHandler);
            return new UnitTestRunner(ConfigActionTest.this.project, TestSession.SessionType.DEBUG, this.rerunUnitTestHandler, this.info);
        }

        @Override
        public List<Pair<String, String>> getDebugPathMapping() {
            return Collections.emptyList();
        }

        @Override
        public Pair<String, Integer> getDebugProxy() {
            return null;
        }
    }

    private class RunScriptProvider
    implements RunScript.Provider {
        protected final PhpUnitTestRunInfo info;
        protected final PhpUnit phpUnit;
        protected final UnitTestRunner testRunner;
        protected final RerunUnitTestHandler rerunUnitTestHandler;

        public RunScriptProvider(PhpUnitTestRunInfo info) {
            assert (info != null);
            this.info = info;
            this.rerunUnitTestHandler = this.getRerunUnitTestHandler();
            this.testRunner = this.getTestRunner();
            this.phpUnit = CommandUtils.getPhpUnit(ConfigActionTest.this.project, false);
            assert (this.phpUnit != null);
        }

        @Override
        public ExecutionDescriptor getDescriptor() throws IOException {
            ExecutionDescriptor executionDescriptor = PhpProgram.getExecutionDescriptor().optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/PhpUnit").frontWindow(false).outConvertorFactory(PHPUNIT_LINE_CONVERTOR_FACTORY).inputVisible(false).preExecution(new Runnable(){

                @Override
                public void run() {
                    RunScriptProvider.this.rerunUnitTestHandler.disable();
                    RunScriptProvider.this.testRunner.start();
                }
            }).postExecution(new Runnable(){

                @Override
                public void run() {
                    RunScriptProvider.this.testRunner.showResults();
                    RunScriptProvider.this.rerunUnitTestHandler.enable();
                    RunScriptProvider.this.handleCodeCoverage();
                }
            });
            return executionDescriptor;
        }

        @Override
        public ExternalProcessBuilder getProcessBuilder() {
            List<Testcase> customTests;
            File startFile = FileUtil.toFile((FileObject)this.info.getStartFile());
            PhpUnit.ConfigFiles configFiles = PhpUnit.getConfigFiles(ConfigActionTest.this.project, this.info.allTests());
            ExternalProcessBuilder externalProcessBuilder = this.phpUnit.getProcessBuilder().workingDirectory(this.phpUnit.getWorkingDirectory(configFiles, FileUtil.toFile((FileObject)this.info.getWorkingDirectory()))).addArgument("--log-junit").addArgument(PhpUnit.XML_LOG.getAbsolutePath());
            if (configFiles.bootstrap != null) {
                externalProcessBuilder = externalProcessBuilder.addArgument("--bootstrap").addArgument(configFiles.bootstrap.getAbsolutePath());
            }
            if (configFiles.configuration != null) {
                externalProcessBuilder = externalProcessBuilder.addArgument("--configuration").addArgument(configFiles.configuration.getAbsolutePath());
            }
            if (ConfigActionTest.this.isCoverageEnabled()) {
                externalProcessBuilder = externalProcessBuilder.addArgument("--coverage-clover").addArgument(PhpUnit.COVERAGE_LOG.getAbsolutePath());
            }
            if (ProjectPropertiesSupport.askForTestGroups(ConfigActionTest.this.project)) {
                if (this.info.getTestGroups() == null) {
                    this.info.setTestGroups(ProjectPropertiesSupport.getPhpUnitLastUsedTestGroups(ConfigActionTest.this.project));
                }
                externalProcessBuilder = externalProcessBuilder.addArgument("--group").addArgument(this.info.getTestGroups());
            }
            if (!(customTests = this.info.getCustomTests()).isEmpty()) {
                StringBuilder buffer = new StringBuilder(200);
                boolean first = true;
                for (Testcase test : customTests) {
                    if (!first) {
                        buffer.append("|");
                    }
                    buffer.append(test.getName());
                    first = false;
                }
                externalProcessBuilder = externalProcessBuilder.addArgument("--filter").addArgument(buffer.toString());
                this.info.resetCustomTests();
            }
            externalProcessBuilder = configFiles.suite != null ? externalProcessBuilder.addArgument(configFiles.suite.getAbsolutePath()) : externalProcessBuilder.addArgument(PhpUnit.getNbSuite().getAbsolutePath()).addArgument(String.format("--run=%s", startFile.getAbsolutePath()));
            return externalProcessBuilder;
        }

        @Override
        public String getOutputTabTitle() {
            File suite;
            String title = null;
            title = this.info.allTests() ? ((suite = PhpUnit.getCustomSuite(ConfigActionTest.this.project)) == null ? NbBundle.getMessage(ConfigActionTest.class, (String)"LBL_UnitTestsForTestSourcesSuffix") : NbBundle.getMessage(ConfigActionTest.class, (String)"LBL_UnitTestsForTestSourcesWithCustomSuiteSuffix", (Object)suite.getName())) : this.info.getTestName();
            return String.format("%s - %s", this.phpUnit.getProgram(), title);
        }

        @Override
        public boolean isValid() {
            return this.phpUnit.isValid() && this.info.getStartFile() != null;
        }

        protected RerunUnitTestHandler getRerunUnitTestHandler() {
            return new RerunUnitTestHandler(this.info);
        }

        protected UnitTestRunner getTestRunner() {
            return new UnitTestRunner(ConfigActionTest.this.project, TestSession.SessionType.TEST, this.rerunUnitTestHandler, this.info);
        }

        void handleCodeCoverage() {
            if (!ConfigActionTest.this.isCoverageEnabled()) {
                return;
            }
            CoverageVO coverage = new CoverageVO();
            try {
                PhpUnitCoverageLogParser.parse(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(PhpUnit.COVERAGE_LOG), "UTF-8")), coverage);
            }
            catch (FileNotFoundException ex) {
                ConfigAction.LOGGER.info(String.format("File %s not found. If there are no errors in PHPUnit output (verify in Output window), please report an issue (http://www.netbeans.org/issues/).", PhpUnit.COVERAGE_LOG));
                return;
            }
            catch (IOException ex) {
                ConfigAction.LOGGER.log(Level.WARNING, null, ex);
                return;
            }
            if (!PhpUnit.KEEP_LOGS && !PhpUnit.COVERAGE_LOG.delete()) {
                ConfigAction.LOGGER.log(Level.INFO, "Cannot delete code coverage log {0}", PhpUnit.COVERAGE_LOG);
            }
            if (this.info.allTests()) {
                ConfigActionTest.this.coverageProvider.setCoverage(coverage);
            } else {
                ConfigActionTest.this.coverageProvider.updateCoverage(coverage);
            }
        }
    }
}

