/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.runconfigs.RunConfigLocal;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigLocalValidator;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.support.AskForUrlPanel;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

class ConfigActionLocal
extends ConfigAction {
    private final FileObject webRoot;

    protected ConfigActionLocal(PhpProject project) {
        super(project);
        this.webRoot = ProjectPropertiesSupport.getWebRootDirectory(project);
    }

    @Override
    public boolean isProjectValid() {
        return this.isValid(RunConfigLocalValidator.validateConfigAction(RunConfigLocal.forProject(this.project), true) == null);
    }

    @Override
    public boolean isFileValid() {
        return this.isValid(RunConfigLocalValidator.validateConfigAction(RunConfigLocal.forProject(this.project), false) == null);
    }

    protected boolean isValid(boolean valid) {
        if (!valid) {
            this.showCustomizer();
        }
        return valid;
    }

    @Override
    public boolean isRunFileEnabled(Lookup context) {
        FileObject file = CommandUtils.fileForContextOrSelectedNodes(context, this.webRoot);
        return file != null;
    }

    @Override
    public boolean isDebugFileEnabled(Lookup context) {
        if (XDebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(context);
    }

    @Override
    public void runProject() {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(CommandUtils.urlForProject(this.project));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void debugProject() {
        final URL[] urlToShow = new URL[2];
        try {
            URL urlForProject = this.getUrlToShow(CommandUtils.urlForProject(this.project));
            if (urlForProject != null) {
                urlToShow[0] = CommandUtils.createDebugUrl(urlForProject, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_START);
                urlToShow[1] = CommandUtils.createDebugUrl(urlForProject, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_STOP_NO_EXEC);
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (StopDebuggingException exc) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (urlToShow[0] != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(urlToShow[0]);
                }
            }
        };
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (urlToShow[1] != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(urlToShow[1]);
                }
                return true;
            }
        };
        XDebugStarter dbgStarter = XDebugStarterFactory.getInstance();
        if (dbgStarter != null) {
            if (dbgStarter.isAlreadyRunning()) {
                if (CommandUtils.warnNoMoreDebugSession()) {
                    dbgStarter.stop();
                    this.debugProject();
                }
            } else {
                this.startDebugger(dbgStarter, runnable, cancellable, FileUtil.toFileObject((File)RunConfigLocal.forProject(this.project).getIndexFile()));
            }
        }
    }

    @Override
    public void runFile(Lookup context) {
        try {
            URL url = CommandUtils.urlForContext(this.project, context);
            assert (url != null);
            this.preShowUrl(context);
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void debugFile(Lookup context) {
        URL urlForStartDebugging = null;
        URL urlForStopDebugging = null;
        try {
            URL urlForContext = this.getUrlToShow(CommandUtils.urlForContext(this.project, context));
            if (urlForContext != null) {
                urlForStartDebugging = CommandUtils.createDebugUrl(urlForContext, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_START);
                urlForStopDebugging = CommandUtils.createDebugUrl(urlForContext, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_STOP_NO_EXEC);
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        catch (StopDebuggingException exc) {
            return;
        }
        this.preShowUrl(context);
        this.debugFile(CommandUtils.fileForContextOrSelectedNodes(context, this.webRoot), urlForStartDebugging, urlForStopDebugging);
    }

    URL getUrlToShow(URL defaultRunUrl) throws MalformedURLException, StopDebuggingException {
        URL urlToShow = null;
        PhpProjectProperties.DebugUrl debugUrl = ProjectPropertiesSupport.getDebugUrl(this.project);
        switch (debugUrl) {
            case DEFAULT_URL: {
                urlToShow = defaultRunUrl;
                assert (urlToShow != null);
                break;
            }
            case ASK_FOR_URL: {
                AskForUrlPanel askForUrlPanel = new AskForUrlPanel(this.project, defaultRunUrl);
                if (!askForUrlPanel.open()) {
                    throw new StopDebuggingException();
                }
                urlToShow = askForUrlPanel.getUrl();
                assert (urlToShow != null);
                break;
            }
            case DO_NOT_OPEN_BROWSER: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state for debug URL: " + (Object)((Object)debugUrl));
            }
        }
        return urlToShow;
    }

    void debugFile(FileObject selectedFile, final URL urlForStartDebugging, final URL urlForStopDebugging) {
        assert (selectedFile != null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (urlForStartDebugging != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(urlForStartDebugging);
                }
            }
        };
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (urlForStopDebugging != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(urlForStopDebugging);
                }
                return true;
            }
        };
        XDebugStarter dbgStarter = XDebugStarterFactory.getInstance();
        if (dbgStarter != null) {
            if (dbgStarter.isAlreadyRunning()) {
                if (CommandUtils.warnNoMoreDebugSession()) {
                    dbgStarter.stop();
                    this.debugFile(selectedFile, urlForStartDebugging, urlForStopDebugging);
                }
            } else {
                this.startDebugger(dbgStarter, runnable, cancellable, selectedFile);
            }
        }
    }

    protected void preShowUrl(Lookup context) {
    }

    private void startDebugger(XDebugStarter dbgStarter, Runnable initDebuggingCode, Cancellable cancellable, FileObject debuggedFile) {
        Callable<Cancellable> initDebuggingCallable = Executors.callable(initDebuggingCode, cancellable);
        XDebugStarter.Properties props = XDebugStarter.Properties.create(debuggedFile, false, ProjectPropertiesSupport.getDebugPathMapping(this.project), ProjectPropertiesSupport.getDebugProxy(this.project), ProjectPropertiesSupport.getEncoding(this.project));
        dbgStarter.start(this.project, initDebuggingCallable, props);
    }

    private static final class StopDebuggingException
    extends Exception {
        private static final long serialVersionUID = -22807171434417714L;

        private StopDebuggingException() {
        }
    }
}

