/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.transfer.TransferInfo;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooser;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class DownloadCommand
extends RemoteCommand
implements Displayable {
    public static final String ID = "download";
    public static final String DISPLAY_NAME = NbBundle.getMessage(DownloadCommand.class, (String)"LBL_DownloadCommand");

    public DownloadCommand(PhpProject project) {
        super(project);
    }

    @Override
    public boolean saveRequired() {
        return false;
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    protected Runnable getContextRunnable(final Lookup context) {
        return new Runnable(){

            @Override
            public void run() {
                DownloadCommand.this.invokeActionImpl(context);
            }
        };
    }

    void invokeActionImpl(Lookup context) {
        FileObject[] selectedFiles = CommandUtils.filesForContextOrSelectedNodes(context);
        if (selectedFiles.length == 0) {
            return;
        }
        FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(this.getProject());
        if (!this.sourcesFilesOnly(sources, selectedFiles)) {
            return;
        }
        InputOutput remoteLog = DownloadCommand.getRemoteLog(RunConfigRemote.forProject(this.getProject()).getRemoteConfiguration().getDisplayName());
        RemoteClient remoteClient = this.getRemoteClient(remoteLog);
        String projectName = this.getProject().getName();
        DownloadCommand.download(remoteClient, remoteLog, projectName, true, sources, selectedFiles, null, this.getProject());
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public static void download(RemoteClient remoteClient, InputOutput remoteLog, String projectName, FileObject sources, Set<TransferFile> forDownload) {
        DownloadCommand.download(remoteClient, remoteLog, projectName, false, sources, null, forDownload, null);
    }

    private static void download(RemoteClient remoteClient, InputOutput remoteLog, String projectName, boolean showDownloadDialog, FileObject sources, FileObject[] filesToDownload, Set<TransferFile> transferFilesToDownload, PhpProject project) {
        Set<TransferFile> forDownload = DownloadCommand.prepareDownload(transferFilesToDownload, sources, filesToDownload, project, projectName, showDownloadDialog, remoteClient);
        DownloadCommand.download(forDownload, project, projectName, sources, filesToDownload, remoteLog, remoteClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<TransferFile> prepareDownload(Set<TransferFile> transferFilesToDownload, FileObject sources, FileObject[] filesToDownload, PhpProject project, String projectName, boolean showDownloadDialog, RemoteClient remoteClient) {
        Set<TransferFile> forDownload = Collections.emptySet();
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DownloadCommand.class, (String)"MSG_DownloadingFiles", (Object)projectName), (Cancellable)remoteClient);
        try {
            progressHandle.start();
            Set<TransferFile> set = forDownload = transferFilesToDownload != null ? transferFilesToDownload : remoteClient.prepareDownload(sources, filesToDownload);
            if (showDownloadDialog) {
                boolean reallyShowDialog = true;
                if (forDownload.size() == 1 && forDownload.iterator().next().isFile()) {
                    reallyShowDialog = false;
                }
                if (reallyShowDialog) {
                    long timestamp = project != null ? ProjectSettings.getLastDownload(project) : -1L;
                    forDownload = TransferFilesChooser.forDownload(forDownload, timestamp).showDialog();
                }
            }
        }
        catch (RemoteException ex) {
            RemoteUtils.processRemoteException(ex);
        }
        finally {
            progressHandle.finish();
        }
        return forDownload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(Set<TransferFile> forDownload, PhpProject project, String projectName, FileObject sources, FileObject[] filesToDownload, InputOutput remoteLog, RemoteClient remoteClient) {
        TransferInfo transferInfo = null;
        try {
            if (forDownload.size() > 0) {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DownloadCommand.class, (String)"MSG_DownloadingFiles", (Object)projectName), (Cancellable)remoteClient);
                RemoteCommand.DefaultOperationMonitor downloadOperationMonitor = new RemoteCommand.DefaultOperationMonitor(progressHandle, forDownload);
                remoteClient.setOperationMonitor(downloadOperationMonitor);
                transferInfo = remoteClient.download(forDownload);
                remoteClient.setOperationMonitor(null);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DownloadCommand.class, (String)"MSG_DownloadFinished", (Object)projectName));
                if (project != null && !remoteClient.isCancelled() && transferInfo.hasAnyTransfered()) {
                    DownloadCommand.rememberLastDownload(project, sources, filesToDownload);
                }
            }
        }
        catch (RemoteException ex) {
            RemoteUtils.processRemoteException(ex);
        }
        finally {
            try {
                remoteClient.disconnect();
            }
            catch (RemoteException ex) {
                RemoteUtils.processRemoteException(ex);
            }
            if (transferInfo != null) {
                DownloadCommand.processTransferInfo(transferInfo, remoteLog);
            }
        }
    }

    private static void rememberLastDownload(PhpProject project, FileObject sources, FileObject[] selectedFiles) {
        for (FileObject fo : selectedFiles) {
            if (!sources.equals(fo)) continue;
            ProjectSettings.setLastDownload(project, TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
            return;
        }
    }
}

