/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.util.logging.Logger;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class Command {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private final PhpProject project;

    public Command(PhpProject project) {
        assert (project != null);
        this.project = project;
    }

    public abstract String getCommandId();

    public abstract boolean isActionEnabledInternal(Lookup var1);

    public abstract void invokeActionInternal(Lookup var1);

    public final boolean isActionEnabled(Lookup context) {
        if (PhpProjectValidator.isFatallyBroken(this.project)) {
            return true;
        }
        return this.isActionEnabledInternal(context);
    }

    public final void invokeAction(Lookup context) {
        if (PhpProjectValidator.isFatallyBroken(this.project)) {
            Utils.warnInvalidSourcesDirectory(this.project);
            return;
        }
        this.invokeActionInternal(context);
    }

    public boolean asyncCallRequired() {
        return true;
    }

    public boolean saveRequired() {
        return true;
    }

    public boolean isFileSensitive() {
        return false;
    }

    public final PhpProject getProject() {
        return this.project;
    }

    protected ConfigAction getConfigAction() {
        return ConfigAction.get(ConfigAction.convert(ProjectPropertiesSupport.getRunAs(this.project)), this.project);
    }

    protected boolean isTestFile(FileObject fileObj) {
        if (fileObj == null) {
            return false;
        }
        if (fileObj.getName().endsWith("Test") && ProjectPropertiesSupport.runAllTestFilesUsingPhpUnit(this.project)) {
            return true;
        }
        return CommandUtils.isUnderTests(this.project, fileObj, false);
    }

    protected boolean isSeleniumFile(FileObject fileObj) {
        if (fileObj == null) {
            return false;
        }
        return CommandUtils.isUnderSelenium(this.project, fileObj, false);
    }
}

