/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.LocalServerController;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class CopyFilesVisual
extends JPanel {
    private static final long serialVersionUID = 16907251064819776L;
    final LocalServerController localServerController;
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton copyFilesButton;
    private JCheckBox copyFilesCheckBox;
    private JComboBox copyFilesComboBox;
    private JLabel localServerLabel;

    public CopyFilesVisual(SourcesFolderProvider sourcesFolderProvider, LocalServer ... defaultLocalServers) {
        this.initComponents();
        this.localServerController = LocalServerController.create(this.copyFilesComboBox, this.copyFilesButton, sourcesFolderProvider, new BrowseCopyFiles(), NbBundle.getMessage(CopyFilesVisual.class, (String)"LBL_SelectFolderLocation"), defaultLocalServers);
        this.localServerController.setEnabled(false);
        this.copyFilesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyFilesVisual.this.copyFilesCheckBoxChanged();
                CopyFilesVisual.this.changeSupport.fireChange();
            }
        });
        this.localServerController.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CopyFilesVisual.this.changeSupport.fireChange();
            }
        });
    }

    void copyFilesCheckBoxChanged() {
        boolean selected = this.copyFilesCheckBox.isSelected();
        this.localServerLabel.setEnabled(selected);
        this.localServerController.setEnabled(selected);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public boolean isCopyFiles() {
        return this.copyFilesCheckBox.isSelected();
    }

    public void setCopyFiles(boolean copyFiles) {
        this.copyFilesCheckBox.setSelected(copyFiles);
        this.copyFilesCheckBoxChanged();
    }

    public LocalServer getLocalServer() {
        return this.localServerController.getLocalServer();
    }

    public MutableComboBoxModel getLocalServerModel() {
        return this.localServerController.getLocalServerModel();
    }

    public void setLocalServerModel(MutableComboBoxModel localServers) {
        this.localServerController.setLocalServerModel(localServers);
    }

    public void selectLocalServer(LocalServer localServer) {
        this.localServerController.selectLocalServer(localServer);
    }

    public void setState(boolean enabled) {
        this.copyFilesCheckBox.setEnabled(enabled);
    }

    public boolean getState() {
        return this.copyFilesCheckBox.isEnabled();
    }

    private void initComponents() {
        this.copyFilesCheckBox = new JCheckBox();
        this.localServerLabel = new JLabel();
        this.copyFilesComboBox = new JComboBox();
        this.copyFilesButton = new JButton();
        this.setFocusTraversalPolicy(null);
        Mnemonics.setLocalizedText((AbstractButton)this.copyFilesCheckBox, (String)NbBundle.getMessage(CopyFilesVisual.class, (String)"LBL_CopyFiles"));
        this.localServerLabel.setLabelFor(this.copyFilesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.localServerLabel, (String)NbBundle.getMessage(CopyFilesVisual.class, (String)"LBL_CopyFileToFolder"));
        this.localServerLabel.setEnabled(false);
        this.copyFilesComboBox.setEditable(true);
        this.copyFilesComboBox.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.copyFilesButton, (String)NbBundle.getMessage(CopyFilesVisual.class, (String)"LBL_Browse"));
        this.copyFilesButton.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.copyFilesCheckBox).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.localServerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyFilesComboBox, 0, 141, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyFilesButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.copyFilesCheckBox).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.copyFilesButton).addComponent(this.copyFilesComboBox, -2, -1, -2).addComponent(this.localServerLabel))));
        this.copyFilesCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.copyFilesCheckBox.AccessibleContext.accessibleName"));
        this.copyFilesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.copyFilesCheckBox.AccessibleContext.accessibleDescription"));
        this.localServerLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.localServerLabel.AccessibleContext.accessibleName"));
        this.localServerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.localServerLabel.AccessibleContext.accessibleDescription"));
        this.copyFilesComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.copyFilesComboBox.AccessibleContext.accessibleName"));
        this.copyFilesComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.copyFilesComboBox.AccessibleContext.accessibleDescription"));
        this.copyFilesButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.copyFilesButton.AccessibleContext.accessibleName"));
        this.copyFilesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.copyFilesButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CopyFilesVisual.class, (String)"CopyFilesVisual.AccessibleContext.accessibleDescription"));
    }

    private static class BrowseCopyFiles
    implements LocalServerController.BrowseHandler {
        private BrowseCopyFiles() {
        }

        @Override
        public String getDirKey() {
            return "nb.php.localServer.copyTarget";
        }
    }
}

