/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.runconfigs;

import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.runconfigs.BaseRunConfig;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public final class RunConfigScript
extends BaseRunConfig<RunConfigScript> {
    private boolean useDefaultInterpreter;
    private String interpreter;
    private String options;
    private String workDir;

    private RunConfigScript() {
    }

    public static PhpProjectProperties.RunAsType getRunAsType() {
        return PhpProjectProperties.RunAsType.SCRIPT;
    }

    public static String getDisplayName() {
        return RunConfigScript.getRunAsType().getLabel();
    }

    public static RunConfigScript create() {
        return new RunConfigScript();
    }

    public static RunConfigScript forProject(final PhpProject project) {
        return (RunConfigScript)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<RunConfigScript>(){

            public RunConfigScript run() {
                return ((RunConfigScript)((RunConfigScript)((RunConfigScript)new RunConfigScript().setUseDefaultInterpreter(false).setInterpreter(ProjectPropertiesSupport.getPhpInterpreter(project)).setOptions(ProjectPropertiesSupport.getPhpArguments(project)).setIndexParentDir(FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(project)))).setIndexRelativePath(ProjectPropertiesSupport.getIndexFile(project))).setArguments(ProjectPropertiesSupport.getArguments(project))).setWorkDir(ProjectPropertiesSupport.getWorkDir(project));
            }
        });
    }

    public String getHint() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.interpreter);
        if (StringUtils.hasText((String)this.options)) {
            sb.append(" ");
            sb.append(this.options);
        }
        if (StringUtils.hasText((String)this.indexRelativePath)) {
            sb.append(" ");
            sb.append(this.indexRelativePath);
        }
        if (StringUtils.hasText((String)this.arguments)) {
            sb.append(" ");
            sb.append(this.arguments);
        }
        return sb.toString();
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public RunConfigScript setInterpreter(String interpreter) {
        this.interpreter = interpreter;
        return this;
    }

    public String getOptions() {
        return this.options;
    }

    public RunConfigScript setOptions(String options) {
        this.options = options;
        return this;
    }

    public boolean getUseDefaultInterpreter() {
        return this.useDefaultInterpreter;
    }

    public RunConfigScript setUseDefaultInterpreter(boolean useDefaultInterpreter) {
        this.useDefaultInterpreter = useDefaultInterpreter;
        return this;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public RunConfigScript setWorkDir(String workDir) {
        this.workDir = workDir;
        return this;
    }
}

