/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.IncludePathSupport;
import org.netbeans.modules.php.project.problems.Bundle;
import org.netbeans.modules.php.project.problems.CustomizerProblemResolver;
import org.netbeans.modules.php.project.problems.DirectoryProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public final class ProjectPropertiesProblemProvider
implements ProjectProblemsProvider {
    static final List<String> WATCHED_PROPERTIES = new CopyOnWriteArrayList<String>(Arrays.asList("src.dir", "test.src.dir", "selenium.src.dir", "web.root", "include.path"));
    final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    private final PhpProject project;
    private final PropertyChangeListener projectPropertiesListener = new ProjectPropertiesListener();
    private volatile FileChangeListener fileChangesListener = new FileChangesListener();

    private ProjectPropertiesProblemProvider(PhpProject project) {
        this.project = project;
    }

    public static ProjectPropertiesProblemProvider createForProject(PhpProject project) {
        ProjectPropertiesProblemProvider projectProblems = new ProjectPropertiesProblemProvider(project);
        projectProblems.addProjectPropertiesListeners();
        projectProblems.addFileChangesListeners();
        return projectProblems;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<ProjectProblemsProvider.ProjectProblem> collectProblems() {
                ArrayList<ProjectProblemsProvider.ProjectProblem> currentProblems = new ArrayList<ProjectProblemsProvider.ProjectProblem>(5);
                ProjectPropertiesProblemProvider.this.checkSrcDir(currentProblems);
                if (currentProblems.isEmpty()) {
                    ProjectPropertiesProblemProvider.this.checkTestDir(currentProblems);
                    ProjectPropertiesProblemProvider.this.checkSeleniumDir(currentProblems);
                    ProjectPropertiesProblemProvider.this.checkWebRoot(currentProblems);
                    ProjectPropertiesProblemProvider.this.checkIncludePath(currentProblems);
                }
                return currentProblems;
            }
        });
    }

    void checkSrcDir(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File invalidDirectory = this.getInvalidDirectory(ProjectPropertiesSupport.getSourcesDirectory(this.project), "src.dir");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidSrcDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidSrcDir_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new DirectoryProblemResolver(this.project, "src.dir", Bundle.ProjectPropertiesProblemProvider_invalidSrcDir_dialog_title(this.project.getName())));
            currentProblems.add(problem);
        }
    }

    void checkTestDir(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File invalidDirectory = this.getInvalidDirectory(ProjectPropertiesSupport.getTestDirectory(this.project, false), "test.src.dir");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidTestDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidTestDir_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "Sources", "test.src.dir"));
            currentProblems.add(problem);
        }
    }

    void checkSeleniumDir(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File invalidDirectory = this.getInvalidDirectory(ProjectPropertiesSupport.getSeleniumDirectory(this.project, false), "selenium.src.dir");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidSeleniumDir_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidSeleniumDir_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new DirectoryProblemResolver(this.project, "selenium.src.dir", Bundle.ProjectPropertiesProblemProvider_invalidSeleniumDir_dialog_title(this.project.getName())));
            currentProblems.add(problem);
        }
    }

    void checkWebRoot(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        File webRoot = this.getWebRoot();
        if (webRoot == null) {
            return;
        }
        File invalidDirectory = this.getInvalidDirectory(FileUtil.toFileObject((File)webRoot), "web.root");
        if (invalidDirectory != null) {
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidWebRoot_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidWebRoot_description(invalidDirectory.getAbsolutePath()), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "Sources", "web.root"));
            currentProblems.add(problem);
        }
    }

    void checkIncludePath(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems) {
        IncludePathSupport includePathSupport = new IncludePathSupport(ProjectPropertiesSupport.getPropertyEvaluator(this.project), this.project.getRefHelper(), this.project.getHelper());
        for (BasePathSupport.Item item : includePathSupport.itemsList(ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty("include.path"))) {
            if (!item.isBroken()) continue;
            ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ProjectPropertiesProblemProvider_invalidIncludePath_title(), (String)Bundle.ProjectPropertiesProblemProvider_invalidIncludePath_description(), (ProjectProblemResolver)new CustomizerProblemResolver(this.project, "PhpIncludePath", "include.path"));
            currentProblems.add(problem);
            return;
        }
    }

    private File getInvalidDirectory(FileObject directory, String propertyName) {
        assert (WATCHED_PROPERTIES.contains(propertyName)) : "Property '" + propertyName + "' should be watched for changes";
        if (directory != null) {
            if (directory.isValid()) {
                return null;
            }
            return FileUtil.toFile((FileObject)directory);
        }
        String propValue = ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty(propertyName);
        if (propValue == null) {
            return null;
        }
        File dir = ProjectPropertiesSupport.getSubdirectory(this.project, this.project.getProjectDirectory(), propValue);
        if (dir.isDirectory()) {
            return null;
        }
        return dir;
    }

    private File getWebRoot() {
        if (PhpProjectValidator.isFatallyBroken(this.project)) {
            return null;
        }
        return ProjectPropertiesSupport.getSourceSubdirectory(this.project, ProjectPropertiesSupport.getPropertyEvaluator(this.project).getProperty("web.root"));
    }

    private void addProjectPropertiesListeners() {
        ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(this.project, this.projectPropertiesListener);
    }

    private void addFileChangesListeners() {
        this.addFileChangesListener(this.project.getSourceRoots());
        this.addFileChangesListener(this.project.getTestRoots());
        this.addFileChangesListener(this.project.getSeleniumRoots());
        File webRoot = this.getWebRoot();
        if (webRoot != null) {
            this.addFileChangeListener(webRoot);
        }
    }

    private void addFileChangesListener(SourceRoots sourceRoots) {
        for (FileObject root : sourceRoots.getRoots()) {
            File file = FileUtil.toFile((FileObject)root);
            if (file == null) continue;
            this.addFileChangeListener(file);
        }
    }

    private void addFileChangeListener(File file) {
        try {
            FileUtil.addFileChangeListener((FileChangeListener)this.fileChangesListener, (File)file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void propertiesChanged() {
        this.fileChangesListener = new FileChangesListener();
        this.addFileChangesListeners();
    }

    private final class FileChangesListener
    implements FileChangeListener {
        private FileChangesListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private final class ProjectPropertiesListener
    implements PropertyChangeListener {
        private ProjectPropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (WATCHED_PROPERTIES.contains(evt.getPropertyName())) {
                ProjectPropertiesProblemProvider.this.problemsProviderSupport.fireProblemsChange();
                ProjectPropertiesProblemProvider.this.propertiesChanged();
            }
        }
    }
}

