/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.problems;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.Future;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.problems.Bundle;
import org.netbeans.modules.php.project.problems.Done;
import org.netbeans.modules.php.project.problems.ProjectPropertiesProblemProvider;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DirectoryProblemResolver
implements ProjectProblemResolver {
    private final PhpProject project;
    private final String propertyName;
    private final String dialogTitle;

    public DirectoryProblemResolver(PhpProject project, String propertyName, String dialogTitle) {
        this.project = project;
        this.propertyName = propertyName;
        this.dialogTitle = dialogTitle;
    }

    public Future<ProjectProblemsProvider.Result> resolve() {
        File projectDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        File selectedDir = new FileChooserBuilder(ProjectPropertiesProblemProvider.class).setTitle(this.dialogTitle).setDefaultWorkingDirectory(projectDir).forceUseOfDefaultWorkingDirectory(true).setDirectoriesOnly(true).setFileHiding(true).setApproveText(Bundle.DirectoryProblemResolver_dialog_choose()).showOpenDialog();
        if (selectedDir == null) {
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
        }
        String relPath = ProjectPropertiesSupport.relativizeFile(projectDir, selectedDir);
        PhpProjectProperties.save(this.project, Collections.singletonMap(this.propertyName, relPath), Collections.<String, String>emptyMap());
        return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.project != null ? this.project.hashCode() : 0);
        hash = 19 * hash + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectoryProblemResolver other = (DirectoryProblemResolver)obj;
        if (!(this.project == other.project || this.project != null && this.project.equals(other.project))) {
            return false;
        }
        return !(this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName));
    }
}

