/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.io.File;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.deprecated.PhpProgram;
import org.netbeans.modules.php.project.phpunit.Bundle;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.filesystems.FileUtil;

public final class PhpUnitSkelGen
extends PhpProgram {
    public static final String SCRIPT_NAME = "phpunit-skelgen";
    public static final String SCRIPT_NAME_LONG = "phpunit-skelgen" + FileUtils.getScriptExtension((boolean)true);
    private static final String BOOTSTRAP_PARAM = "--bootstrap";
    private static final String TEST_PARAM = "--test";
    private static final String SEPARATOR_PARAM = "--";

    private PhpUnitSkelGen(String command) {
        super(command);
    }

    public static PhpUnitSkelGen getDefault() throws PhpProgram.InvalidPhpProgramException {
        String script = PhpOptions.getInstance().getPhpUnitSkelGen();
        String error = PhpUnitSkelGen.validate(script);
        if (error != null) {
            throw new PhpProgram.InvalidPhpProgramException(error);
        }
        return new PhpUnitSkelGen(script);
    }

    public static String validate(String command) {
        return new PhpUnitSkelGen(command).validate();
    }

    @Override
    public String validate() {
        return FileUtils.validateFile((String)Bundle.PhpUnitSkelGen_script_label(), (String)this.getProgram(), (boolean)false);
    }

    public File generateTest(PhpUnit.ConfigFiles configFiles, String sourceClassName, File sourceClassFile, String testClassName, File testClassFile) {
        if (testClassFile.isFile()) {
            return testClassFile;
        }
        if (!this.ensureTestFolderExists(testClassFile)) {
            return null;
        }
        ExternalProcessBuilder processBuilder = this.getProcessBuilder();
        if (configFiles.bootstrap != null && configFiles.useBootstrapForCreateTests) {
            processBuilder = processBuilder.addArgument(BOOTSTRAP_PARAM).addArgument(configFiles.bootstrap.getAbsolutePath());
        }
        processBuilder = processBuilder.addArgument(TEST_PARAM).addArgument(SEPARATOR_PARAM).addArgument(this.sanitizeClassName(sourceClassName)).addArgument(sourceClassFile.getAbsolutePath()).addArgument(this.sanitizeClassName(testClassName)).addArgument(testClassFile.getAbsolutePath());
        ExecutionDescriptor executionDescriptor = PhpUnitSkelGen.getExecutionDescriptor().inputVisible(false).frontWindow(true).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/PhpUnit");
        try {
            int status = PhpUnitSkelGen.executeAndWait(processBuilder, executionDescriptor, Bundle.PhpUnitSkelGen_test_generating(sourceClassName));
            if (status == 0) {
                FileUtil.refreshFor((File[])new File[]{testClassFile.getParentFile()});
                return testClassFile;
            }
        }
        catch (CancellationException ex) {
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)"PhpUnit");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private String sanitizeClassName(String className) {
        if (className.startsWith("\\")) {
            className = className.substring(1);
        }
        return className;
    }

    private boolean ensureTestFolderExists(File testClassFile) {
        File parent = testClassFile.getParentFile();
        if (!parent.isDirectory()) {
            if (!parent.mkdirs()) {
                return false;
            }
            FileUtil.refreshFor((File[])new File[]{parent});
        }
        return true;
    }
}

