/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.deprecated.PhpProgram;
import org.netbeans.modules.php.project.phpunit.Bundle;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public final class PhpUnit
extends PhpProgram {
    private static final Logger LOGGER = Logger.getLogger(PhpUnit.class.getName());
    public static final String SCRIPT_NAME = "phpunit";
    public static final String SCRIPT_NAME_LONG = "phpunit" + FileUtils.getScriptExtension((boolean)true);
    public static final boolean KEEP_LOGS = Boolean.getBoolean("nb.php.phpunit.keeplogs");
    public static final String OPTIONS_SUB_PATH = "PhpUnit";
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/PhpUnit";
    public static final String TEST_CLASS_SUFFIX = "Test";
    private static final String TEST_FILE_SUFFIX = "Test.php";
    private static final String SUITE_CLASS_SUFFIX = "Suite";
    private static final String SUITE_FILE_SUFFIX = "Suite.php";
    private static final String REQUIRE_ONCE_TPL_START = "require_once '";
    private static final String REQUIRE_ONCE_TPL_END = "%s';";
    private static final String REQUIRE_ONCE_TPL = "require_once '%s';";
    private static final String DIRNAME_FILE = ".dirname(__FILE__).'/";
    static final String REQUIRE_ONCE_REL_PART = "'.dirname(__FILE__).'/";
    public static final String PARAM_JUNIT_LOG = "--log-junit";
    public static final String PARAM_FILTER = "--filter";
    public static final String PARAM_COVERAGE_LOG = "--coverage-clover";
    public static final String PARAM_SKELETON = "--skeleton-test";
    public static final String PARAM_LIST_GROUPS = "--list-groups";
    public static final String PARAM_GROUP = "--group";
    public static final String PARAM_BOOTSTRAP = "--bootstrap";
    private static final String BOOTSTRAP_FILENAME = "bootstrap%s.php";
    public static final String PARAM_CONFIGURATION = "--configuration";
    private static final String CONFIGURATION_FILENAME = "configuration%s.xml";
    public static final File XML_LOG;
    public static final File COVERAGE_LOG;
    public static final String SUITE_NAME = "NetBeansSuite";
    public static final String SUITE_RUN = "--run=%s";
    private static final String SUITE_REL_PATH = "phpunit/NetBeansSuite.php";
    private static final char DIRECTORY_SEPARATOR = '/';
    public static final Pattern LINE_PATTERN;
    private static volatile File suite;

    private PhpUnit(String command) {
        super(command);
    }

    public static File getNbSuite() {
        if (suite == null) {
            suite = InstalledFileLocator.getDefault().locate(SUITE_REL_PATH, "org.netbeans.modules.php.project", false);
        }
        return suite;
    }

    public static PhpUnit getDefault() throws PhpProgram.InvalidPhpProgramException {
        return PhpUnit.getCustom(PhpOptions.getInstance().getPhpUnit());
    }

    public static PhpUnit forProject(PhpProject project) throws PhpProgram.InvalidPhpProgramException {
        File script = ProjectPropertiesSupport.getPhpUnitScript(project);
        if (script == null) {
            return null;
        }
        return PhpUnit.getCustom(script.getAbsolutePath());
    }

    public static PhpUnit getCustom(String command) throws PhpProgram.InvalidPhpProgramException {
        String error = PhpUnit.validate(command);
        if (error != null) {
            throw new PhpProgram.InvalidPhpProgramException(error);
        }
        return new PhpUnit(command);
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpUnit.getExecutionDescriptor().controllable(false).frontWindow(false);
    }

    public File generateTest(PhpProject phpProject, ConfigFiles configFiles, PhpClass phpClass, FileObject sourceFo, File workingDirectory) {
        String className = phpClass.getName();
        File testFile = PhpUnit.getTestFile(phpProject, sourceFo, className);
        if (testFile.isFile()) {
            return testFile;
        }
        File sourceFile = FileUtil.toFile((FileObject)sourceFo);
        File parent = FileUtil.toFile((FileObject)sourceFo.getParent());
        File generatedFile = this.getGeneratedFile(className, parent);
        if (generatedFile.isFile()) {
            if (!this.useExistingTestInSources(generatedFile)) {
                return null;
            }
        } else {
            String fullyQualifiedName = phpClass.getFullyQualifiedName();
            assert (fullyQualifiedName != null) : "No FQN for php class: " + phpClass.getName();
            if (!this.generateTestInternal(configFiles, fullyQualifiedName, sourceFo, workingDirectory)) {
                return null;
            }
        }
        if (!generatedFile.isFile()) {
            LOGGER.log(Level.WARNING, "Generated PHPUnit test file {0} was not found.", generatedFile.getName());
            return null;
        }
        return this.moveAndAdjustGeneratedFile(generatedFile, testFile, sourceFile);
    }

    private boolean generateTestInternal(ConfigFiles configFiles, String className, FileObject sourceFo, File workingDirectory) {
        ExternalProcessBuilder externalProcessBuilder = this.getProcessBuilder().workingDirectory(workingDirectory);
        if (configFiles.bootstrap != null && configFiles.useBootstrapForCreateTests) {
            externalProcessBuilder = externalProcessBuilder.addArgument(PARAM_BOOTSTRAP).addArgument(configFiles.bootstrap.getAbsolutePath());
        }
        if (configFiles.configuration != null) {
            externalProcessBuilder = externalProcessBuilder.addArgument(PARAM_CONFIGURATION).addArgument(configFiles.configuration.getAbsolutePath());
        }
        if (className.startsWith("\\")) {
            className = className.substring(1);
        }
        externalProcessBuilder = externalProcessBuilder.addArgument(PARAM_SKELETON).addArgument(className).addArgument(FileUtil.toFile((FileObject)sourceFo).getAbsolutePath());
        try {
            int status = PhpUnit.executeAndWait(externalProcessBuilder, this.getDescriptor(), String.format("%s %s %s %s", this.getProgram(), PARAM_SKELETON, className, sourceFo.getNameExt()));
            return status == 0;
        }
        catch (CancellationException ex) {
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)OPTIONS_SUB_PATH);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    private File moveAndAdjustGeneratedFile(File generatedFile, File testFile, File sourceFile) {
        assert (generatedFile.isFile()) : "Generated files must exist: " + generatedFile;
        assert (!testFile.exists()) : "Test file cannot exist: " + testFile;
        try {
            FileUtil.createFolder((File)testFile.getParentFile());
        }
        catch (IOException exc) {
            LOGGER.log(Level.WARNING, null, exc);
            return generatedFile;
        }
        testFile = this.adjustFileContent(generatedFile, testFile, sourceFile, PhpUnit.getRequireOnce(testFile, sourceFile));
        if (testFile == null) {
            return null;
        }
        assert (testFile.isFile()) : "Test file must exist: " + testFile;
        try {
            PhpProjectUtils.reformatFile(testFile);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot reformat file " + testFile, ex);
        }
        return testFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File adjustFileContent(File generatedFile, File testFile, File sourceFile, String requireOnce) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(generatedFile), "UTF-8"));
            try {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(testFile), "UTF-8"));
                try {
                    String line;
                    boolean requireWritten = false;
                    String filename = sourceFile.getName();
                    while ((line = in.readLine()) != null) {
                        if (!requireWritten && PhpUnit.isRequireOnceSourceFile(line.trim(), filename)) {
                            out.write(String.format(REQUIRE_ONCE_TPL, requireOnce).replace("''.", ""));
                            requireWritten = true;
                        } else {
                            out.write(line);
                        }
                        out.newLine();
                    }
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
        if (!generatedFile.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete generated file {0}", generatedFile);
        }
        return testFile;
    }

    public static File getTestFile(PhpProject project, FileObject source, String className) {
        assert (project != null);
        assert (source != null);
        FileObject sourcesDirectory = ProjectPropertiesSupport.getSourcesDirectory(project);
        String relativeSourcePath = FileUtil.getRelativePath((FileObject)sourcesDirectory, (FileObject)source.getParent());
        assert (relativeSourcePath != null) : String.format("Relative path must be found for sources %s and folder %s", sourcesDirectory, source.getParent());
        File relativeTestDirectory = PhpProjectUtils.resolveFile(PhpUnit.getTestDirectory(project), relativeSourcePath);
        return new File(relativeTestDirectory, PhpUnit.makeTestFile(className));
    }

    private static File getTestDirectory(PhpProject phpProject) {
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(phpProject, false);
        assert (testDirectory != null && testDirectory.isValid()) : "Valid folder for tests must be found for " + phpProject;
        return FileUtil.toFile((FileObject)testDirectory);
    }

    private File getGeneratedFile(String className, File parent) {
        return new File(parent, PhpUnit.makeTestFile(className));
    }

    private boolean useExistingTestInSources(File testFile) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)Bundle.PhpUnit_useTestFileInSources(testFile.getName()), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION;
    }

    public static boolean isRequireOnceSourceFile(String line, String filename) {
        return line.startsWith(REQUIRE_ONCE_TPL_START) && line.endsWith(String.format(REQUIRE_ONCE_TPL_END, filename));
    }

    public static boolean isTestFile(String fileName) {
        return !fileName.equals(TEST_FILE_SUFFIX) && fileName.endsWith(TEST_FILE_SUFFIX);
    }

    public static boolean isTestClass(String className) {
        return !className.equals(TEST_CLASS_SUFFIX) && className.endsWith(TEST_CLASS_SUFFIX);
    }

    public static boolean isSuiteFile(String fileName) {
        return !fileName.equals(SUITE_FILE_SUFFIX) && fileName.endsWith(SUITE_FILE_SUFFIX);
    }

    public static boolean isSuiteClass(String className) {
        return !className.equals(SUITE_CLASS_SUFFIX) && className.endsWith(SUITE_CLASS_SUFFIX);
    }

    public static boolean isTestOrSuiteFile(String fileName) {
        return PhpUnit.isTestFile(fileName) || PhpUnit.isSuiteFile(fileName);
    }

    public static boolean isTestOrSuiteClass(String className) {
        return PhpUnit.isTestClass(className) || PhpUnit.isSuiteClass(className);
    }

    public static String getTestedClass(String testOrSuiteClass) {
        assert (PhpUnit.isTestOrSuiteClass(testOrSuiteClass)) : "Not Test or Suite class: " + testOrSuiteClass;
        int lastIndexOf = -1;
        if (PhpUnit.isTestClass(testOrSuiteClass)) {
            lastIndexOf = testOrSuiteClass.lastIndexOf(TEST_CLASS_SUFFIX);
        } else if (PhpUnit.isSuiteClass(testOrSuiteClass)) {
            lastIndexOf = testOrSuiteClass.lastIndexOf(SUITE_CLASS_SUFFIX);
        }
        assert (lastIndexOf != -1);
        return testOrSuiteClass.substring(0, lastIndexOf);
    }

    public static String makeTestFile(String testedFileName) {
        return testedFileName + TEST_FILE_SUFFIX;
    }

    public static String makeTestClass(String testedClass) {
        return testedClass + TEST_CLASS_SUFFIX;
    }

    public static String makeSuiteFile(String testedFileName) {
        return testedFileName + SUITE_FILE_SUFFIX;
    }

    public static String makeSuiteClass(String testedClass) {
        return testedClass + SUITE_CLASS_SUFFIX;
    }

    @Override
    public ExternalProcessBuilder getProcessBuilder() {
        return super.getProcessBuilder().workingDirectory(new File(this.getProgram()).getParentFile());
    }

    public File getWorkingDirectory(ConfigFiles configFiles, File defaultWorkingDirectory) {
        if (configFiles.configuration != null) {
            return configFiles.configuration.getParentFile();
        }
        return defaultWorkingDirectory;
    }

    public static ConfigFiles getConfigFiles(PhpProject project, boolean withSuite) {
        File configuration;
        LinkedList<Pair<String, File>> missingFiles = new LinkedList<Pair<String, File>>();
        File bootstrap = ProjectPropertiesSupport.getPhpUnitBootstrap(project);
        if (bootstrap != null && !bootstrap.isFile()) {
            missingFiles.add(Pair.of((Object)NbBundle.getMessage(PhpUnit.class, (String)"LBL_Bootstrap"), (Object)bootstrap));
            bootstrap = null;
        }
        if ((configuration = ProjectPropertiesSupport.getPhpUnitConfiguration(project)) != null && !configuration.isFile()) {
            missingFiles.add((Pair<String, File>)Pair.of((Object)NbBundle.getMessage(PhpUnit.class, (String)"LBL_XmlConfiguration"), (Object)configuration));
            configuration = null;
        }
        File suite = null;
        if (withSuite && (suite = ProjectPropertiesSupport.getPhpUnitSuite(project)) != null && !suite.isFile()) {
            missingFiles.add((Pair<String, File>)Pair.of((Object)NbBundle.getMessage(PhpUnit.class, (String)"LBL_TestSuite"), (Object)suite));
            suite = null;
        }
        PhpUnit.warnAboutMissingFiles(missingFiles);
        return new ConfigFiles(bootstrap, ProjectPropertiesSupport.usePhpUnitBootstrapForCreateTests(project), configuration, suite);
    }

    public static File getCustomSuite(PhpProject project) {
        File suite = ProjectPropertiesSupport.getPhpUnitSuite(project);
        if (suite != null && suite.isFile()) {
            return suite;
        }
        return null;
    }

    public static File createBootstrapFile(final PhpProject project) {
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(project, false);
        assert (testDirectory != null) : "Test directory must already be set";
        final FileObject configFile = FileUtil.getConfigFile((String)"Templates/PHPUnit/PHPUnitBootstrap");
        final DataFolder dataFolder = DataFolder.findFolder((FileObject)testDirectory);
        final File bootstrapFile = new File(PhpUnit.getBootstrapFilepath(project));
        final File[] files = new File[1];
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DataObject dataTemplate = DataObject.find((FileObject)configFile);
                    DataObject bootstrap = dataTemplate.createFromTemplate(dataFolder, bootstrapFile.getName() + "~");
                    assert (bootstrap != null);
                    PhpUnit.moveAndAdjustBootstrap(project, FileUtil.toFile((FileObject)bootstrap.getPrimaryFile()), bootstrapFile);
                    assert (bootstrapFile.isFile());
                    files[0] = bootstrapFile;
                    PhpUnit.informAboutGeneratedFile(bootstrapFile.getName());
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Cannot create PHPUnit bootstrap file", ex);
                }
            }
        });
        if (files[0] == null) {
            PhpUnit.warnAboutNotGeneratedFile(bootstrapFile.getName());
        }
        return files[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveAndAdjustBootstrap(PhpProject project, File tmpBootstrap, File finalBootstrap) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpBootstrap), "UTF-8"));
            try {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(finalBootstrap), "UTF-8"));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        if (line.contains("%INCLUDE_PATH%")) {
                            if (line.startsWith("//")) continue;
                            String includePath = ProjectPropertiesSupport.getPropertyEvaluator(project).getProperty("include.path");
                            assert (includePath != null) : "Include path should be always present";
                            line = PhpUnit.processIncludePath(finalBootstrap, line, includePath, FileUtil.toFile((FileObject)project.getProjectDirectory()));
                        }
                        out.write(line);
                        out.newLine();
                    }
                }
                finally {
                    out.flush();
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        if (!tmpBootstrap.delete()) {
            LOGGER.log(Level.INFO, "Cannot delete temporary file {0}", tmpBootstrap);
            tmpBootstrap.deleteOnExit();
        }
        FileUtil.refreshFor((File[])new File[]{finalBootstrap.getParentFile()});
    }

    static String processIncludePath(File bootstrap, String line, String includePath, File projectDir) {
        if (StringUtils.hasText((String)includePath)) {
            if (includePath.startsWith(":")) {
                includePath = includePath.substring(1);
            }
            StringBuilder buffer = new StringBuilder(200);
            for (String path : PropertyUtils.tokenizePath((String)includePath)) {
                File reference = PropertyUtils.resolveFile((File)projectDir, (String)path);
                buffer.append(".PATH_SEPARATOR");
                buffer.append(PhpUnit.getDirnameFile(bootstrap, reference));
            }
            includePath = buffer.toString();
        } else {
            line = "//" + line;
        }
        line = line.replace("%INCLUDE_PATH%", includePath);
        return line;
    }

    public static File createConfigurationFile(PhpProject project) {
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(project, false);
        assert (testDirectory != null) : "Test directory must already be set";
        FileObject configFile = FileUtil.getConfigFile((String)"Templates/PHPUnit/PHPUnitConfiguration.xml");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)testDirectory);
        File configurationFile = new File(PhpUnit.getConfigurationFilepath(project));
        File file = null;
        try {
            DataObject dataTemplate = DataObject.find((FileObject)configFile);
            DataObject configuration = dataTemplate.createFromTemplate(dataFolder, configurationFile.getName().replace(".xml", ""));
            assert (configuration != null);
            file = configurationFile;
            PhpUnit.informAboutGeneratedFile(configurationFile.getName());
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Cannot create PHPUnit configuration file", ex);
        }
        if (file == null) {
            PhpUnit.warnAboutNotGeneratedFile(configurationFile.getName());
        }
        return file;
    }

    public static void informAboutGeneratedFile(String generatedFile) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpUnit.class, (String)"MSG_FileGenerated", (Object)generatedFile)));
    }

    private static void warnAboutNotGeneratedFile(String file) {
        NotifyDescriptor.Message warning = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpUnit.class, (String)"MSG_NotGenerated", (Object)file), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)warning);
    }

    private static void warnAboutMissingFiles(List<Pair<String, File>> missingFiles) {
        if (missingFiles.isEmpty()) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        for (Pair<String, File> pair : missingFiles) {
            buffer.append(NbBundle.getMessage(PhpUnit.class, (String)"LBL_MissingFile", (Object)pair.first, (Object)((File)pair.second).getAbsolutePath()));
            buffer.append("\n");
        }
        NotifyDescriptor.Message warning = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpUnit.class, (String)"MSG_MissingFiles", (Object)buffer.toString()), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)warning);
    }

    private static String getDirnameFile(File testFile, File sourceFile) {
        return PhpUnit.getRelPath(testFile, sourceFile, ".'", DIRNAME_FILE, "'");
    }

    public static String getRequireOnce(File testFile, File sourceFile) {
        return PhpUnit.getRelPath(testFile, sourceFile, "", REQUIRE_ONCE_REL_PART, "");
    }

    private static String getRelPath(File testFile, File sourceFile, String absolutePrefix, String relativePrefix, String suffix) {
        return PhpUnit.getRelPath(testFile, sourceFile, absolutePrefix, relativePrefix, suffix, false);
    }

    static String getRelPath(File testFile, File sourceFile, String absolutePrefix, String relativePrefix, String suffix, boolean forceAbsolute) {
        File parentFile = testFile.getParentFile();
        String relPath = PropertyUtils.relativizeFile((File)parentFile, (File)sourceFile);
        relPath = relPath == null || forceAbsolute ? absolutePrefix + sourceFile.getAbsolutePath() + suffix : relativePrefix + relPath + suffix;
        return relPath.replace(File.separatorChar, '/');
    }

    private static String getBootstrapFilepath(PhpProject project) {
        return PhpUnit.getFilepath(project, BOOTSTRAP_FILENAME);
    }

    private static String getConfigurationFilepath(PhpProject project) {
        return PhpUnit.getFilepath(project, CONFIGURATION_FILENAME);
    }

    private static String getFilepath(PhpProject project, String filename) {
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(project, false);
        assert (testDirectory != null) : "Test directory must already be set";
        File tests = FileUtil.toFile((FileObject)testDirectory);
        File file = null;
        int i = 0;
        while ((file = new File(tests, PhpUnit.getFilename(filename, i++))).isFile()) {
        }
        assert (!file.isFile());
        return file.getAbsolutePath();
    }

    private static String getFilename(String filename, int i) {
        return String.format(filename, i == 0 ? "" : Integer.valueOf(i));
    }

    @Override
    public String validate() {
        return FileUtils.validateFile((String)Bundle.PhpUnit_script_label(), (String)this.getProgram(), (boolean)false);
    }

    public static String validate(String command) {
        return new PhpUnit(command).validate();
    }

    static {
        LINE_PATTERN = Pattern.compile("(?:.+\\(\\) )?(.+):(\\d+)");
        String logDirName = System.getProperty("java.io.tmpdir");
        String userLogDirName = System.getProperty("nb.php.phpunit.logdir");
        if (userLogDirName != null) {
            LOGGER.log(Level.INFO, "Custom directory for PhpUnit logs provided: {0}", userLogDirName);
            File userLogDir = new File(userLogDirName);
            if (userLogDir.isDirectory() && FileUtils.isDirectoryWritable((File)userLogDir)) {
                logDirName = userLogDirName;
            } else {
                LOGGER.log(Level.WARNING, "Directory for PhpUnit logs {0} is not writable directory", userLogDirName);
            }
        }
        LOGGER.log(Level.FINE, "Directory for PhpUnit logs: {0}", logDirName);
        XML_LOG = new File(logDirName, "nb-phpunit-log.xml");
        COVERAGE_LOG = new File(logDirName, "nb-phpunit-coverage.xml");
    }

    public static final class ConfigFiles {
        public final File bootstrap;
        public final boolean useBootstrapForCreateTests;
        public final File configuration;
        public final File suite;

        public ConfigFiles(File bootstrap, boolean useBootstrapForCreateTests, File configuration, File suite) {
            this.bootstrap = bootstrap;
            this.useBootstrapForCreateTests = useBootstrapForCreateTests;
            this.configuration = configuration;
            this.suite = suite;
        }
    }
}

