/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.copysupport;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.copysupport.FileOperationFactory;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

@SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
final class LocalOperationFactory
extends FileOperationFactory {
    private static final Logger LOGGER = Logger.getLogger(LocalOperationFactory.class.getName());

    LocalOperationFactory(PhpProject project) {
        super(project);
    }

    @Override
    protected boolean isEnabled() {
        return this.isEnabled(true);
    }

    private boolean isEnabled(boolean verbose) {
        boolean copySourcesEnabled = ProjectPropertiesSupport.isCopySourcesEnabled(this.project);
        if (verbose) {
            LOGGER.log(Level.FINE, "LOCAL copying enabled for project {0}: {1}", new Object[]{this.project.getName(), copySourcesEnabled});
        }
        return copySourcesEnabled;
    }

    private boolean isEnabledAndValidConfig() {
        boolean isWritable;
        File writableFolder;
        if (!this.isEnabled(false)) {
            LOGGER.log(Level.FINE, "LOCAL copying not enabled for project {0}", this.project.getName());
            return false;
        }
        if (this.isInvalid()) {
            LOGGER.log(Level.FINE, "LOCAL copying invalid for project {0}", this.project.getName());
            return false;
        }
        if (this.getSources() == null) {
            LOGGER.log(Level.WARNING, "LOCAL copying disabled for project {0}. Reason: source root is null", this.project.getName());
            return false;
        }
        File targetRoot = this.getTargetRoot();
        if (targetRoot == null) {
            LOGGER.log(Level.INFO, "LOCAL copying disabled for project {0}. Reason: target folder is null", this.project.getName());
            if (this.askUser(NbBundle.getMessage(LocalOperationFactory.class, (String)"MSG_NoTargetFolder", (Object)this.project.getName()))) {
                this.showCustomizer("Sources");
            }
            this.invalidate();
            return false;
        }
        for (writableFolder = targetRoot; writableFolder != null && !writableFolder.exists(); writableFolder = writableFolder.getParentFile()) {
        }
        boolean bl = isWritable = writableFolder != null && FileUtils.isDirectoryWritable((File)writableFolder);
        if (!isWritable) {
            LOGGER.log(Level.INFO, "LOCAL copying disabled for project {0}. Reason: target folder {1} is not writable", new Object[]{this.project.getName(), writableFolder});
            if (this.askUser(NbBundle.getMessage(LocalOperationFactory.class, (String)"MSG_TargetFolderNotWritable", (Object)this.project.getName(), (Object)writableFolder))) {
                this.showCustomizer("Sources");
            }
            this.invalidate();
            return false;
        }
        return true;
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected Callable<Boolean> createInitHandlerInternal(FileObject source) {
        LOGGER.log(Level.FINE, "Creating INIT handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(source), this.project.getName()});
        return this.createCopyFolderHandler(source);
    }

    @Override
    protected Callable<Boolean> createCopyHandlerInternal(FileObject source, FileEvent fileEvent) {
        LOGGER.log(Level.FINE, "Creating COPY handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(source), this.project.getName()});
        return source.isFolder() ? this.createCopyFolderHandler(source) : this.createCopyFileHandler(source);
    }

    private Callable<Boolean> createCopyFolderHandler(final FileObject source) {
        assert (source.isFolder());
        LOGGER.log(Level.FINE, "Creating COPY FOLDER handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(source), this.project.getName()});
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.FINE, "Running COPY FOLDER handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(source), LocalOperationFactory.this.project.getName()});
                File target = LocalOperationFactory.this.getTarget(source);
                if (target == null) {
                    LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(source));
                    return null;
                }
                if (!target.exists()) {
                    FileUtil.createFolder((File)target);
                    if (!target.isDirectory()) {
                        LOGGER.log(Level.FINE, "Failed for {0}, cannot create directory {1}", new Object[]{FileOperationFactory.getPath(source), target});
                        return false;
                    }
                    LOGGER.log(Level.FINE, "Directory {0} created", target);
                }
                Boolean work = null;
                String[] list = target.list();
                if (list != null) {
                    Enumeration children = source.getChildren(true);
                    while (children.hasMoreElements()) {
                        FileObject child = (FileObject)children.nextElement();
                        if (!LocalOperationFactory.this.isSourceFileValid(child)) {
                            LOGGER.log(Level.FINE, "Ignored for {0} (not valid)", FileOperationFactory.getPath(child));
                            continue;
                        }
                        target = LocalOperationFactory.this.getTarget(child, false);
                        if (target == null) {
                            LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(child));
                            continue;
                        }
                        if (!LocalOperationFactory.this.doCopy(child, target)) {
                            return false;
                        }
                        work = true;
                    }
                }
                return work;
            }
        };
    }

    private Callable<Boolean> createCopyFileHandler(final FileObject source) {
        assert (source.isData());
        LOGGER.log(Level.FINE, "Creating COPY FILE handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(source), this.project.getName()});
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.FINE, "Running COPY FILE handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(source), LocalOperationFactory.this.project.getName()});
                File target = LocalOperationFactory.this.getTarget(source);
                if (target == null) {
                    LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(source));
                    return null;
                }
                return LocalOperationFactory.this.doCopy(source, target);
            }
        };
    }

    @Override
    protected Callable<Boolean> createRenameHandlerInternal(final FileObject source, final String oldName, FileRenameEvent fileRenameEvent) {
        LOGGER.log(Level.FINE, "Creating RENAME handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(source), this.project.getName()});
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                File parent;
                LOGGER.log(Level.FINE, "Running RENAME handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(source), LocalOperationFactory.this.project.getName()});
                File target = LocalOperationFactory.this.getTarget(source);
                if (target == null) {
                    LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(source));
                    return null;
                }
                if (source.isFolder()) {
                    Enumeration children = source.getChildren(true);
                    while (children.hasMoreElements()) {
                        FileObject child = (FileObject)children.nextElement();
                        if (!LocalOperationFactory.this.isSourceFileValid(child)) {
                            LOGGER.log(Level.FINE, "Ignored for {0} (not valid)", FileOperationFactory.getPath(child));
                            continue;
                        }
                        File childTarget = LocalOperationFactory.this.getTarget(child, false);
                        if (childTarget == null || LocalOperationFactory.this.doCopy(child, childTarget)) continue;
                        return false;
                    }
                } else if (!LocalOperationFactory.this.doCopy(source, target)) {
                    return false;
                }
                if ((parent = target.getParentFile()) != null) {
                    File oldTarget = new File(parent, oldName);
                    return LocalOperationFactory.this.doDelete(oldTarget);
                }
                return true;
            }
        };
    }

    @Override
    protected Callable<Boolean> createDeleteHandlerInternal(final FileObject source, FileEvent fileEvent) {
        LOGGER.log(Level.FINE, "Creating DELETE handler for {0} (project {1})", new Object[]{LocalOperationFactory.getPath(source), this.project.getName()});
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.FINE, "Running DELETE handler for {0} (project {1})", new Object[]{FileOperationFactory.getPath(source), LocalOperationFactory.this.project.getName()});
                File target = LocalOperationFactory.this.getTarget(source);
                if (target == null) {
                    LOGGER.log(Level.FINE, "Ignored for {0} (no target)", FileOperationFactory.getPath(source));
                    return null;
                }
                return LocalOperationFactory.this.doDelete(target);
            }
        };
    }

    private File getTargetRoot() {
        return ProjectPropertiesSupport.getCopySourcesTarget(this.project);
    }

    private Pair<FileObject, File> getConfigPair() {
        return Pair.of((Object)this.getSources(), (Object)this.getTargetRoot());
    }

    private File getTarget(FileObject source) {
        return this.getTarget(source, true);
    }

    private File getTarget(FileObject source, boolean deepCheck) {
        LOGGER.log(Level.FINE, "Getting target for {0} (project {1}, deep check: {2})", new Object[]{LocalOperationFactory.getPath(source), this.project.getName(), deepCheck});
        Pair<FileObject, File> cfgPair = this.getConfigPair();
        if (deepCheck) {
            if (!this.isEnabledAndValidConfig()) {
                LOGGER.fine("\t-> null (invalid config)");
                return null;
            }
            if (!LocalOperationFactory.isPairValid(cfgPair)) {
                LOGGER.fine("\t-> null (invalid config pair)");
                return null;
            }
        }
        if (!this.isSourceFileValid(source)) {
            LOGGER.fine("\t-> null (invalid source)");
            return null;
        }
        FileObject sourceRoot = (FileObject)cfgPair.first;
        File targetRoot = (File)cfgPair.second;
        assert (sourceRoot != null);
        assert (targetRoot != null);
        String relativePath = FileUtil.getRelativePath((FileObject)sourceRoot, (FileObject)source);
        assert (relativePath != null) : String.format("Relative path be found because isSourceFileValid() was already called for %s", LocalOperationFactory.getPath(source));
        LOGGER.fine("\t-> found");
        return FileUtil.normalizeFile((File)new File(targetRoot, relativePath));
    }

    private boolean doCopy(FileObject source, File target) throws IOException {
        LOGGER.log(Level.FINE, "Copying file {0} -> {1}", new Object[]{LocalOperationFactory.getPath(source), target});
        File targetParent = target.getParentFile();
        if (source.isData()) {
            this.doDelete(target);
            FileObject parent = FileUtil.createFolder((File)targetParent);
            FileUtil.copyFile((FileObject)source, (FileObject)parent, (String)source.getName(), (String)source.getExt());
            LOGGER.log(Level.FINE, "File {0} copied to {1}", new Object[]{LocalOperationFactory.getPath(source), target});
        } else {
            String[] childs = target.list();
            if (childs == null || childs.length == 0) {
                this.doDelete(target);
            }
            FileUtil.createFolder((File)target);
            LOGGER.log(Level.FINE, "Folder {0} created", target);
        }
        return target.exists();
    }

    private boolean doDelete(File target) throws IOException {
        LOGGER.log(Level.FINE, "Deleting file {0}", target);
        if (!target.exists()) {
            LOGGER.log(Level.FINE, "File {0} does not exists, nothing to delete", target);
            return true;
        }
        FileObject targetFo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)target));
        assert (targetFo != null) : "FileObject must be found for " + target;
        if (!targetFo.isValid()) {
            LOGGER.log(Level.FINE, "FileObject {0} is not valid, nothing to delete", LocalOperationFactory.getPath(targetFo));
        } else {
            targetFo.delete();
            LOGGER.log(Level.FINE, "File {0} deleted", LocalOperationFactory.getPath(targetFo));
        }
        return !target.exists();
    }

    private static boolean isPairValid(Pair<FileObject, File> pair) {
        return pair != null && pair.first != null && pair.second != null;
    }

    @Override
    protected boolean isValid(FileEvent fileEvent) {
        return true;
    }
}

