/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooser;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserPanel;
import org.netbeans.modules.php.project.connections.ui.transfer.tree.CheckListener;
import org.netbeans.modules.php.project.connections.ui.transfer.tree.CheckRenderer;
import org.netbeans.modules.php.project.connections.ui.transfer.tree.TransferSelectorModel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

@SuppressWarnings(value={"SE_BAD_FIELD_STORE", "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
public final class TransferSelector
extends TransferFilesChooserPanel
implements ExplorerManager.Provider {
    private static final long serialVersionUID = 875487456455313L;
    static final Comparator<TransferFile> TRANSFER_FILE_COMPARATOR = new TransferFileComparator();
    final TransferSelectorModel model;
    private final TransferFilesChooser.TransferType transferType;
    private final ExplorerManager explorerManager;
    private final ItemListener checkAllItemListener;
    private JCheckBox checkAllCheckBox;
    private JPanel treePanel;

    public TransferSelector(Set<TransferFile> transferFiles, TransferFilesChooser.TransferType transferType, long timestamp) {
        this.transferType = transferType;
        this.model = new TransferSelectorModel(transferFiles, timestamp);
        this.explorerManager = new ExplorerManager();
        RootChildren rootChildren = new RootChildren(transferFiles);
        this.explorerManager.setRootContext((Node)new RootNode(rootChildren));
        this.initComponents();
        CheckTreeView treeView = new CheckTreeView(this.model);
        treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransferSelector.class, (String)"ACSN_TransferFilesTree"));
        treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransferSelector.class, (String)"ACSD_TransferFilesTree"));
        this.treePanel.add((Component)((Object)treeView), "Center");
        this.checkAllCheckBox.setSelected(this.model.isAllSelected());
        this.checkAllItemListener = new CheckAllItemListener(this.model, treeView);
        this.checkAllCheckBox.addItemListener(this.checkAllItemListener);
        this.model.addChangeListener(new TransferFilesChooserPanel.TransferFilesChangeListener(){

            @Override
            public void selectedFilesChanged() {
                TransferSelector.this.checkAllCheckBox.removeItemListener(TransferSelector.this.checkAllItemListener);
                TransferSelector.this.checkAllCheckBox.setSelected(TransferSelector.this.model.isAllSelected());
                TransferSelector.this.checkAllCheckBox.addItemListener(TransferSelector.this.checkAllItemListener);
            }

            @Override
            public void filterChanged() {
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void addChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
        this.model.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(TransferFilesChooserPanel.TransferFilesChangeListener listener) {
        this.model.removeChangeListener(listener);
    }

    @Override
    public Set<TransferFile> getSelectedFiles() {
        return this.model.getSelected();
    }

    @Override
    public TransferFilesChooserPanel getEmbeddablePanel() {
        return this;
    }

    @Override
    public boolean hasAnyTransferableFiles() {
        return !this.model.getData().isEmpty();
    }

    Node create(TransferFile transferFile) {
        if (transferFile.isDirectory()) {
            return new FolderNode(transferFile);
        }
        return new FileNode(transferFile);
    }

    private void initComponents() {
        this.treePanel = new JPanel();
        this.checkAllCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.treePanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.checkAllCheckBox, (String)NbBundle.getMessage(TransferSelector.class, (String)"TransferSelector.checkAllCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.checkAllCheckBox).addContainerGap(212, Short.MAX_VALUE)).addComponent(this.treePanel, -1, 310, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.treePanel, -1, 217, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAllCheckBox)));
    }

    private static final class CheckAllItemListener
    implements ItemListener {
        private final TransferSelectorModel model;
        private final CheckTreeView treeView;

        public CheckAllItemListener(TransferSelectorModel model, CheckTreeView treeView) {
            this.model = model;
            this.treeView = treeView;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.model.selectAll();
                this.treeView.repaintTree();
            } else if (e.getStateChange() == 2) {
                this.model.unselectAll();
                this.treeView.repaintTree();
            }
        }
    }

    private static class TransferFileComparator
    implements Comparator<TransferFile> {
        private TransferFileComparator() {
        }

        @Override
        public int compare(TransferFile o1, TransferFile o2) {
            boolean isDir1 = o1.isDirectory();
            boolean isDir2 = o2.isDirectory();
            if (isDir1 && isDir2 || !isDir1 && !isDir2) {
                return o1.getName().compareTo(o2.getName());
            }
            if (isDir1) {
                return -1;
            }
            return 1;
        }
    }

    private class FileChildFactory
    extends ChildFactory<TransferFile> {
        private final TransferFile transferFile;

        public FileChildFactory(TransferFile transferFile) {
            this.transferFile = transferFile;
        }

        protected boolean createKeys(List<TransferFile> transferFiles) {
            transferFiles.addAll(this.transferFile.getChildren());
            Collections.sort(transferFiles, TRANSFER_FILE_COMPARATOR);
            return true;
        }

        protected Node createNodeForKey(TransferFile file) {
            Node node = TransferSelector.this.create(file);
            TransferSelector.this.model.addNode(node);
            return node;
        }
    }

    private class RootChildren
    extends Children.Keys<TransferFile> {
        private final boolean projectRoot;

        public RootChildren(Set<TransferFile> transferFiles) {
            boolean projRoot = false;
            LinkedList<TransferFile> roots = new LinkedList<TransferFile>();
            for (TransferFile file : transferFiles) {
                if (file.isProjectRoot()) {
                    roots.clear();
                    roots.addAll(file.getChildren());
                    projRoot = true;
                    break;
                }
                if (!file.isRoot()) continue;
                roots.add(file);
            }
            this.projectRoot = projRoot;
            Collections.sort(roots, TRANSFER_FILE_COMPARATOR);
            this.setKeys(roots);
        }

        public boolean hasProjectRoot() {
            return this.projectRoot;
        }

        protected Node[] createNodes(TransferFile file) {
            return new Node[]{TransferSelector.this.create(file)};
        }
    }

    private class RootNode
    extends FolderNode {
        public RootNode(RootChildren children) {
            super((Children)children);
            String nameKey = null;
            nameKey = children.hasProjectRoot() ? "LBL_SourceFiles" : "LBL_SelectFilesForTransfer";
            this.setDisplayName(NbBundle.getMessage(TransferSelector.class, (String)nameKey));
        }
    }

    private class FolderNode
    extends FileNode {
        private static final String EXPLORER_FOLDER_ICON = "Nb.Explorer.Folder.icon";
        private static final String EXPLORER_FOLDER_OPENED_ICON = "Nb.Explorer.Folder.openedIcon";
        private static final String RESOURCE_ICON_FOLDER = "org/netbeans/modules/php/project/ui/resources/folder.gif";
        private static final String RESOURCE_ICON_FOLDER_OPENED = "org/netbeans/modules/php/project/ui/resources/folderOpen.gif";

        protected FolderNode(TransferFile transferFile) {
            super(transferFile, Children.create((ChildFactory)new FileChildFactory(transferFile), (!transferFile.hasChildrenFetched() ? 1 : 0) != 0), Lookups.singleton((Object)transferFile));
        }

        protected FolderNode(Children children) {
            super(children);
        }

        @Override
        public Image getIcon(int type) {
            Object icon = UIManager.get(EXPLORER_FOLDER_ICON);
            if (icon instanceof Image) {
                return (Image)icon;
            }
            return ImageUtilities.loadImage((String)RESOURCE_ICON_FOLDER, (boolean)false);
        }

        @Override
        public Image getOpenedIcon(int type) {
            Object icon = UIManager.get(EXPLORER_FOLDER_OPENED_ICON);
            if (icon instanceof Image) {
                return (Image)icon;
            }
            return ImageUtilities.loadImage((String)RESOURCE_ICON_FOLDER_OPENED, (boolean)false);
        }
    }

    private class FileNode
    extends AbstractNode {
        private static final String RESOURCE_ICON_FILE_DOWNLOAD = "org/netbeans/modules/php/project/ui/resources/fileDownload.gif";
        private static final String RESOURCE_ICON_FILE_UPLOAD = "org/netbeans/modules/php/project/ui/resources/fileUpload.gif";

        protected FileNode(TransferFile transferFile, Children children, Lookup lookup) {
            super(children, lookup);
            this.setDisplayName(transferFile.getName());
        }

        protected FileNode(TransferFile transferFile) {
            this(transferFile, Children.LEAF, Lookups.singleton((Object)transferFile));
        }

        protected FileNode(Children children) {
            super(children);
        }

        public boolean canCopy() {
            return false;
        }

        public Image getIcon(int type) {
            return this.getIcon();
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon();
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public Action getPreferredAction() {
            return null;
        }

        private Image getIcon() {
            if (TransferSelector.this.transferType.equals((Object)TransferFilesChooser.TransferType.UPLOAD)) {
                return ImageUtilities.loadImage((String)RESOURCE_ICON_FILE_UPLOAD, (boolean)false);
            }
            return ImageUtilities.loadImage((String)RESOURCE_ICON_FILE_DOWNLOAD, (boolean)false);
        }
    }

    private static class CheckTreeView
    extends BeanTreeView {
        private static final long serialVersionUID = 9856432132154L;

        public CheckTreeView(TransferSelectorModel model) {
            CheckListener listener = new CheckListener(model);
            this.tree.addMouseListener(listener);
            this.tree.addKeyListener(listener);
            CheckRenderer renderer = new CheckRenderer(model);
            this.tree.setCellRenderer(renderer);
            this.tree.setEditable(false);
        }

        public void repaintTree() {
            this.tree.repaint();
        }
    }
}

