/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sync.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TmpLocalFile;
import org.netbeans.modules.php.project.connections.sync.SyncItem;
import org.netbeans.modules.php.project.connections.sync.diff.Bundle;
import org.netbeans.modules.php.project.connections.sync.diff.DiffFileEncodingQueryImpl;
import org.netbeans.modules.php.project.connections.sync.diff.EditableTmpLocalFileStreamSource;
import org.netbeans.modules.php.project.connections.sync.diff.NullStreamSource;
import org.netbeans.modules.php.project.connections.sync.diff.TmpLocalFileStreamSource;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class DiffPanel
extends JPanel {
    private static final long serialVersionUID = 54678645646768L;
    static final Logger LOGGER = Logger.getLogger(DiffPanel.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(DiffPanel.class);
    final SyncItem syncItem;
    final RemoteClient remoteClient;
    final String charsetName;
    volatile TmpLocalFile remoteTmpFile = null;
    volatile TmpLocalFile localTmpFile = null;
    volatile EditableTmpLocalFileStreamSource editableTmpLocalFileStreamSource = null;
    DialogDescriptor descriptor;
    private NotificationLineSupport notificationLineSupport = null;
    private JLabel loadingLabel;

    public DiffPanel(RemoteClient remoteClient, SyncItem syncItem, String charsetName) {
        this.remoteClient = remoteClient;
        this.syncItem = syncItem;
        this.charsetName = charsetName;
        this.initComponents();
        this.setPreferredSize(new Dimension(600, 450));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() throws IOException {
        assert (SwingUtilities.isEventDispatchThread());
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)Bundle.DiffPanel_button_titleWithMnemonics());
        this.descriptor = new DialogDescriptor((Object)this, Bundle.DiffPanel_title(this.syncItem.getPath()), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        this.notificationLineSupport = this.descriptor.createNotificationLineSupport();
        this.descriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.setDiffView();
        try {
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
            DiffFileEncodingQueryImpl.clear();
        }
        boolean ok = this.descriptor.getValue() == okButton;
        boolean fileModified = false;
        try {
            if (this.editableTmpLocalFileStreamSource != null) {
                fileModified = this.editableTmpLocalFileStreamSource.save();
            }
        }
        finally {
            if (ok) {
                if (fileModified) {
                    this.syncItem.cleanupTmpLocalFile();
                    this.syncItem.setTmpLocalFile(this.localTmpFile);
                } else {
                    this.localTmpFile.cleanup();
                }
            } else if (this.localTmpFile != null) {
                this.localTmpFile.cleanup();
            }
            if (this.remoteTmpFile != null) {
                this.remoteTmpFile.cleanup();
            }
        }
        return ok;
    }

    void showError(final String msg) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (msg != null) {
                    DiffPanel.this.notificationLineSupport.setErrorMessage(msg);
                    DiffPanel.this.descriptor.setValid(false);
                } else {
                    DiffPanel.this.notificationLineSupport.clearMessages();
                    DiffPanel.this.descriptor.setValid(true);
                }
            }
        });
    }

    private void setDiffView() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                String mimeType;
                String name = DiffPanel.this.syncItem.getName();
                final StreamSource remoteStream = DiffPanel.this.getRemoteStreamSource(name, mimeType = DiffPanel.this.getMimeType());
                if (remoteStream == null) {
                    return;
                }
                DiffPanel.this.editableTmpLocalFileStreamSource = DiffPanel.this.getLocalStreamSource(name, mimeType);
                if (DiffPanel.this.editableTmpLocalFileStreamSource == null) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DiffController diffController = DiffController.createEnhanced((StreamSource)remoteStream, (StreamSource)DiffPanel.this.editableTmpLocalFileStreamSource);
                            DiffPanel.this.remove(DiffPanel.this.loadingLabel);
                            DiffPanel.this.add((Component)diffController.getJComponent(), "Center");
                            DiffPanel.this.revalidate();
                            DiffPanel.this.repaint();
                            DiffPanel.this.descriptor.setValid(true);
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.INFO, null, ex);
                            DiffPanel.this.showError(Bundle.DiffPanel_error_cannotReadFiles());
                        }
                    }
                });
            }
        });
    }

    String getMimeType() {
        FileObject fileObject;
        TransferFile localTransferFile = this.syncItem.getLocalTransferFile();
        if (localTransferFile != null && (fileObject = FileUtil.toFileObject((File)localTransferFile.resolveLocalFile())) != null) {
            return fileObject.getMIMEType();
        }
        return this.getMimeType(this.syncItem.getName());
    }

    private String getMimeType(String filename) {
        try {
            return FileUtil.createMemoryFileSystem().getRoot().createData(filename).getMIMEType();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return "content/unknown";
        }
    }

    StreamSource getRemoteStreamSource(String name, String mimeType) {
        TransferFile transferFile = this.syncItem.getRemoteTransferFile();
        if (transferFile == null) {
            return new NullStreamSource(name, mimeType, true);
        }
        this.remoteTmpFile = TmpLocalFile.onDisk(this.getExtension(name));
        try {
            if (this.remoteClient.downloadTemporary(this.remoteTmpFile, transferFile)) {
                this.rememberEncoding(this.remoteTmpFile);
                return new TmpLocalFileStreamSource(name, this.remoteTmpFile, mimeType, this.charsetName, true);
            }
            this.showError(Bundle.DiffPanel_error_cannotDownload(name));
        }
        catch (RemoteException ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.showError(ex.getLocalizedMessage());
        }
        return null;
    }

    EditableTmpLocalFileStreamSource getLocalStreamSource(String name, String mimeType) {
        this.localTmpFile = TmpLocalFile.onDisk(this.getExtension(name));
        try {
            TmpLocalFile currentTmpLocalFile = this.syncItem.getTmpLocalFile();
            if (currentTmpLocalFile != null) {
                this.copyContent(new File(currentTmpLocalFile.getAbsolutePath()), this.localTmpFile);
            } else {
                TransferFile localTransferFile = this.syncItem.getLocalTransferFile();
                if (localTransferFile != null) {
                    this.copyContent(localTransferFile.resolveLocalFile(), this.localTmpFile);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            this.showError(Bundle.DiffPanel_error_copyContent());
            return null;
        }
        try {
            this.rememberEncoding(this.localTmpFile);
            return new EditableTmpLocalFileStreamSource(name, this.localTmpFile, mimeType, this.charsetName, false);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            this.showError(Bundle.DiffPanel_error_opening());
            return null;
        }
    }

    private String getExtension(String filename) {
        List parts = StringUtils.explode((String)filename, (String)".");
        if (parts.isEmpty()) {
            return null;
        }
        return (String)parts.get(parts.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyContent(File file, TmpLocalFile localTmpFile) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return;
        }
        InputStream inputStream = fileObject.getInputStream();
        try {
            OutputStream outputStream = localTmpFile.getOutputStream();
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
    }

    void rememberEncoding(TmpLocalFile tmpLocalFile) {
        if (tmpLocalFile != null) {
            String path = tmpLocalFile.getAbsolutePath();
            assert (path != null) : "Path for local tmp file should be present";
            FileObject fo = FileUtil.toFileObject((File)new File(path));
            assert (fo != null) : "Fileobject for " + path + " should exist";
            DiffFileEncodingQueryImpl.addCharset(fo, Charset.forName(this.charsetName));
        }
    }

    private void initComponents() {
        this.loadingLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.loadingLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.loadingLabel, (String)NbBundle.getMessage(DiffPanel.class, (String)"DiffPanel.loadingLabel.text"));
        this.add((Component)this.loadingLabel, "Center");
        this.add((Component)this.loadingLabel, "Center");
    }
}

