/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.connections.sftp.Bundle;
import org.netbeans.modules.php.project.connections.sftp.SftpConfiguration;

public class SftpConfigurationValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return new ValidationResult(this.result);
    }

    public SftpConfigurationValidator validate(SftpConfiguration configuration) {
        return this.validate(configuration.getHost(), String.valueOf(configuration.getPort()), configuration.getUserName(), configuration.getIdentityFile(), configuration.getKnownHostsFile(), configuration.getInitialDirectory(), String.valueOf(configuration.getTimeout()), String.valueOf(configuration.getKeepAliveInterval()));
    }

    public SftpConfigurationValidator validate(String host, String port, String user, String identityFile, String knownHostsFile, String initialDirectory, String timeout, String keepAliveInterval) {
        String err = RemoteValidator.validateHost(host);
        if (err != null) {
            this.result.addError(new ValidationResult.Message("host", err));
        }
        if ((err = RemoteValidator.validatePort(port)) != null) {
            this.result.addError(new ValidationResult.Message("port", err));
        }
        if ((err = RemoteValidator.validateUser(user)) != null) {
            this.result.addError(new ValidationResult.Message("user", err));
        }
        if (StringUtils.hasText((String)identityFile) && (err = FileUtils.validateFile((String)Bundle.SftpConfigurationValidator_identityFile(), (String)identityFile, (boolean)false)) != null) {
            this.result.addError(new ValidationResult.Message("identityFile", err));
        }
        if (StringUtils.hasText((String)knownHostsFile) && (err = FileUtils.validateFile((String)Bundle.SftpConfigurationValidator_knownHosts(), (String)knownHostsFile, (boolean)false)) != null) {
            this.result.addError(new ValidationResult.Message("knownHostsFile", err));
        }
        if ((err = RemoteValidator.validateUploadDirectory(initialDirectory)) != null) {
            this.result.addError(new ValidationResult.Message("initialDirectory", err));
        }
        if ((err = RemoteValidator.validateTimeout(timeout)) != null) {
            this.result.addError(new ValidationResult.Message("timeout", err));
        }
        if ((err = RemoteValidator.validateKeepAliveInterval(keepAliveInterval)) != null) {
            this.result.addError(new ValidationResult.Message("keepAliveInterval", err));
        }
        return this;
    }
}

