/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.sftp.SftpConfiguration;
import org.netbeans.modules.php.project.connections.sftp.SftpConfigurationValidator;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SftpConfigurationPanel
extends JPanel
implements RemoteConfigurationPanel {
    private static final long serialVersionUID = 2815423138730L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String error = null;
    private String warning = null;
    private boolean passwordRead = false;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JButton identityFileBrowseButton;
    private JLabel identityFileLabel;
    private JTextField identityFileTextField;
    private JLabel initialDirectoryLabel;
    private JTextField initialDirectoryTextField;
    private JLabel keepAliveInfoLabel;
    private JLabel keepAliveLabel;
    private JTextField keepAliveTextField;
    private JButton knownHostsFileBrowseButton;
    private JLabel knownHostsFileLabel;
    private JTextField knownHostsFileTextField;
    private JLabel passwordLabel;
    private JLabel passwordLabelInfo;
    private JPasswordField passwordTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel timeoutLabel;
    private JTextField timeoutTextField;
    private JLabel userLabel;
    private JTextField userTextField;

    public SftpConfigurationPanel() {
        this.initComponents();
        this.registerListeners();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isValidConfiguration() {
        this.setError(null);
        this.setWarning(null);
        ValidationResult validationResult = new SftpConfigurationValidator().validate(this.getHostName(), this.getPort(), this.getUserName(), this.getIdentityFile(), this.getKnownHostsFile(), this.getInitialDirectory(), this.getTimeout(), this.getKeepAliveInterval()).getResult();
        if (validationResult.hasErrors()) {
            this.setError(((ValidationResult.Message)validationResult.getErrors().get(0)).getMessage());
            return false;
        }
        if (validationResult.hasWarnings()) {
            this.setWarning(((ValidationResult.Message)validationResult.getWarnings().get(0)).getMessage());
        }
        return true;
    }

    @Override
    public String getError() {
        return this.error;
    }

    protected void setError(String error) {
        this.error = error;
    }

    @Override
    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    private void registerListeners() {
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.hostTextField.getDocument().addDocumentListener(documentListener);
        this.portTextField.getDocument().addDocumentListener(documentListener);
        this.userTextField.getDocument().addDocumentListener(documentListener);
        this.passwordTextField.getDocument().addDocumentListener(documentListener);
        this.knownHostsFileTextField.getDocument().addDocumentListener(documentListener);
        this.identityFileTextField.getDocument().addDocumentListener(documentListener);
        this.initialDirectoryTextField.getDocument().addDocumentListener(documentListener);
        this.timeoutTextField.getDocument().addDocumentListener(documentListener);
        this.keepAliveTextField.getDocument().addDocumentListener(documentListener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.knownHostsFileLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.passwordLabelInfo = new JLabel();
        this.identityFileLabel = new JLabel();
        this.identityFileTextField = new JTextField();
        this.identityFileBrowseButton = new JButton();
        this.knownHostsFileTextField = new JTextField();
        this.knownHostsFileBrowseButton = new JButton();
        this.initialDirectoryLabel = new JLabel();
        this.initialDirectoryTextField = new JTextField();
        this.timeoutLabel = new JLabel();
        this.timeoutTextField = new JTextField();
        this.keepAliveLabel = new JLabel();
        this.keepAliveTextField = new JTextField();
        this.keepAliveInfoLabel = new JLabel();
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostLabel.text"));
        this.knownHostsFileLabel.setLabelFor(this.knownHostsFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.knownHostsFileLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileLabel.text"));
        this.hostTextField.setMinimumSize(new Dimension(150, 19));
        this.hostTextField.setMinimumSize(new Dimension(150, 19));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portLabel.text"));
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userLabel.text"));
        this.passwordLabel.setLabelFor(this.passwordTextField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabel.text"));
        this.passwordLabelInfo.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabelInfo, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabelInfo.text"));
        this.identityFileLabel.setLabelFor(this.identityFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.identityFileLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.identityFileBrowseButton, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileBrowseButton.text"));
        this.identityFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SftpConfigurationPanel.this.identityFileBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.knownHostsFileBrowseButton, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileBrowseButton.text"));
        this.knownHostsFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SftpConfigurationPanel.this.knownHostsFileBrowseButtonActionPerformed(evt);
            }
        });
        this.initialDirectoryLabel.setLabelFor(this.initialDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.initialDirectoryLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryLabel.text"));
        this.timeoutLabel.setLabelFor(this.timeoutTextField);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutLabel.text"));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        this.keepAliveLabel.setLabelFor(this.keepAliveTextField);
        Mnemonics.setLocalizedText((JLabel)this.keepAliveLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.keepAliveLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.keepAliveInfoLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.keepAliveInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.passwordLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.userLabel).addComponent(this.initialDirectoryLabel).addComponent(this.timeoutLabel).addComponent(this.identityFileLabel).addComponent(this.knownHostsFileLabel).addComponent(this.keepAliveLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.keepAliveInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.passwordLabelInfo, -2, -1, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.knownHostsFileTextField).addComponent(this.identityFileTextField, GroupLayout.Alignment.LEADING).addComponent(this.userTextField, GroupLayout.Alignment.LEADING).addComponent(this.hostTextField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.timeoutTextField, GroupLayout.Alignment.LEADING, -2, 185, -2).addComponent(this.passwordTextField).addComponent(this.initialDirectoryTextField).addComponent(this.keepAliveTextField, GroupLayout.Alignment.LEADING, -2, 185, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.portLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portTextField)).addComponent(this.identityFileBrowseButton)).addComponent(this.knownHostsFileBrowseButton, GroupLayout.Alignment.TRAILING))))));
        layout.linkSize(0, this.identityFileBrowseButton, this.knownHostsFileBrowseButton);
        layout.linkSize(0, this.keepAliveTextField, this.timeoutTextField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2).addComponent(this.hostTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.userTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordLabelInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.identityFileTextField, -2, -1, -2).addComponent(this.identityFileLabel).addComponent(this.identityFileBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.knownHostsFileTextField, -2, -1, -2).addComponent(this.knownHostsFileBrowseButton).addComponent(this.knownHostsFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialDirectoryLabel).addComponent(this.initialDirectoryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeoutTextField, -2, -1, -2).addComponent(this.timeoutLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keepAliveLabel).addComponent(this.keepAliveTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keepAliveInfoLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.hostLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostLabel.AccessibleContext.accessibleName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostLabel.AccessibleContext.accessibleDescription"));
        this.knownHostsFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileLabel.AccessibleContext.accessibleName"));
        this.knownHostsFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileLabel.AccessibleContext.accessibleDescription"));
        this.hostTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostTextField.AccessibleContext.accessibleName"));
        this.hostTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostTextField.AccessibleContext.accessibleDescription"));
        this.portLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portLabel.AccessibleContext.accessibleName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portLabel.AccessibleContext.accessibleDescription"));
        this.portTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portTextField.AccessibleContext.accessibleName"));
        this.portTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portTextField.AccessibleContext.accessibleDescription"));
        this.userLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userLabel.AccessibleContext.accessibleName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userLabel.AccessibleContext.accessibleDescription"));
        this.userTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userTextField.AccessibleContext.accessibleName"));
        this.userTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userTextField.AccessibleContext.accessibleDescription"));
        this.passwordLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabel.AccessibleContext.accessibleName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabel.AccessibleContext.accessibleDescription"));
        this.passwordTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordTextField.AccessibleContext.accessibleName"));
        this.passwordTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordTextField.AccessibleContext.accessibleDescription"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleName"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleDescription"));
        this.identityFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileLabel.AccessibleContext.accessibleName"));
        this.identityFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileLabel.AccessibleContext.accessibleDescription"));
        this.identityFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileTextField.AccessibleContext.accessibleName"));
        this.identityFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileTextField.AccessibleContext.accessibleDescription"));
        this.identityFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileBrowseButton.AccessibleContext.accessibleName"));
        this.identityFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.knownHostsFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileTextField.AccessibleContext.accessibleName"));
        this.knownHostsFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileTextField.AccessibleContext.accessibleDescription"));
        this.knownHostsFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileBrowseButton.AccessibleContext.accessibleName"));
        this.knownHostsFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleName"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleName"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.timeoutLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleName"));
        this.timeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleDescription"));
        this.timeoutTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleName"));
        this.timeoutTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleDescription"));
        this.keepAliveLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.keepAliveLabel.AccessibleContext.accessibleName"));
        this.keepAliveLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.keepAliveLabel.AccessibleContext.accessibleDescription"));
        this.keepAliveTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.keepAliveTextField.AccessibleContext.accessibleName"));
        this.keepAliveTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.keepAliveTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.AccessibleContext.accessibleDescription"));
    }

    private void identityFileBrowseButtonActionPerformed(ActionEvent evt) {
        File newFile = Utils.browseFileAction("nb.php.remote.sftp.identityFile", NbBundle.getMessage(SftpConfigurationPanel.class, (String)"LBL_SelectIdentityFile"));
        if (newFile != null) {
            this.setIdentityFile(newFile.getAbsolutePath());
        }
    }

    private void knownHostsFileBrowseButtonActionPerformed(ActionEvent evt) {
        File newFile = Utils.browseFileAction("nb.php.remote.sftp.knownHosts", NbBundle.getMessage(SftpConfigurationPanel.class, (String)"LBL_SelectKnownHostsFile"));
        if (newFile != null) {
            this.setKnownHostsFile(newFile.getAbsolutePath());
        }
    }

    public String getHostName() {
        return this.hostTextField.getText();
    }

    public void setHostName(String hostName) {
        this.hostTextField.setText(hostName);
    }

    public String getPort() {
        return this.portTextField.getText();
    }

    public void setPort(String port) {
        this.portTextField.setText(port);
    }

    public String getUserName() {
        return this.userTextField.getText();
    }

    public void setUserName(String userName) {
        this.userTextField.setText(userName);
    }

    public String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    public void setPassword(String password) {
        this.passwordTextField.setText(password);
    }

    public String getKnownHostsFile() {
        return this.knownHostsFileTextField.getText();
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFileTextField.setText(knownHostsFile);
    }

    public String getIdentityFile() {
        return this.identityFileTextField.getText();
    }

    public void setIdentityFile(String identityFile) {
        this.identityFileTextField.setText(identityFile);
    }

    public String getInitialDirectory() {
        return this.initialDirectoryTextField.getText();
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectoryTextField.setText(initialDirectory);
    }

    public String getTimeout() {
        return this.timeoutTextField.getText();
    }

    public void setTimeout(String timeout) {
        this.timeoutTextField.setText(timeout);
    }

    public String getKeepAliveInterval() {
        return this.keepAliveTextField.getText();
    }

    public void setKeepAliveInterval(String keepAliveInterval) {
        this.keepAliveTextField.setText(keepAliveInterval);
    }

    @Override
    public void read(ConfigManager.Configuration cfg) {
        this.setHostName(cfg.getValue("host"));
        this.setPort(cfg.getValue("port"));
        this.setUserName(cfg.getValue("user"));
        this.setPassword(this.readPassword(cfg));
        this.setKnownHostsFile(cfg.getValue("knownHostsFile"));
        this.setIdentityFile(cfg.getValue("identityFile"));
        this.setInitialDirectory(cfg.getValue("initialDirectory"));
        this.setTimeout(cfg.getValue("timeout"));
        this.setKeepAliveInterval(cfg.getValue("keepAliveInterval"));
    }

    @Override
    public void store(ConfigManager.Configuration cfg) {
        cfg.putValue("host", this.getHostName());
        cfg.putValue("port", this.getPort());
        cfg.putValue("user", this.getUserName());
        cfg.putValue("password", this.getPassword(), true);
        cfg.putValue("knownHostsFile", this.getKnownHostsFile());
        cfg.putValue("identityFile", this.getIdentityFile());
        cfg.putValue("initialDirectory", RemoteUtils.sanitizeUploadDirectory(this.getInitialDirectory(), false));
        cfg.putValue("timeout", this.getTimeout());
        cfg.putValue("keepAliveInterval", this.getKeepAliveInterval());
    }

    private String readPassword(ConfigManager.Configuration cfg) {
        if (!this.passwordRead) {
            this.passwordRead = true;
            return new SftpConfiguration(cfg).getPassword();
        }
        return cfg.getValue("password", true);
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            SftpConfigurationPanel.this.fireChange();
        }
    }
}

