/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.connections.ftp.Bundle;
import org.netbeans.modules.php.project.connections.ftp.FtpConfiguration;

public class FtpConfigurationValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return new ValidationResult(this.result);
    }

    public FtpConfigurationValidator validate(FtpConfiguration configuration) {
        return this.validate(configuration.getHost(), String.valueOf(configuration.getPort()), configuration.isAnonymousLogin(), configuration.getUserName(), configuration.getInitialDirectory(), String.valueOf(configuration.getTimeout()), String.valueOf(configuration.getKeepAliveInterval()), configuration.isPassiveMode());
    }

    public FtpConfigurationValidator validate(String host, String port, boolean isAnonymousLogin, String user, String initialDirectory, String timeout, String keepAliveInterval, boolean passiveMode) {
        String err = RemoteValidator.validateHost(host);
        if (err != null) {
            this.result.addError(new ValidationResult.Message("host", err));
        }
        if ((err = RemoteValidator.validatePort(port)) != null) {
            this.result.addError(new ValidationResult.Message("port", err));
        }
        this.validateUser(isAnonymousLogin, user);
        err = RemoteValidator.validateUploadDirectory(initialDirectory);
        if (err != null) {
            this.result.addError(new ValidationResult.Message("initialDirectory", err));
        }
        if ((err = RemoteValidator.validateTimeout(timeout)) != null) {
            this.result.addError(new ValidationResult.Message("timeout", err));
        }
        if ((err = RemoteValidator.validateKeepAliveInterval(keepAliveInterval)) != null) {
            this.result.addError(new ValidationResult.Message("keepAliveInterval", err));
        }
        this.validateProxy(passiveMode);
        return this;
    }

    private void validateUser(boolean anonymousLogin, String user) {
        if (anonymousLogin) {
            return;
        }
        String err = RemoteValidator.validateUser(user);
        if (err != null) {
            this.result.addError(new ValidationResult.Message("user", err));
        }
    }

    private void validateProxy(boolean passiveMode) {
        if (RemoteUtils.hasHttpProxy()) {
            if (!passiveMode) {
                this.result.addError(new ValidationResult.Message("proxy", Bundle.FtpConfigurationValidator_error_proxyAndNotPassive()));
            }
            this.result.addWarning(new ValidationResult.Message("proxy", Bundle.FtpConfigurationValidator_warning_proxy()));
        }
    }
}

