/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.ftp.Bundle;
import org.netbeans.modules.php.project.connections.ftp.FtpConnectionProvider;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;

public final class FtpConfiguration
extends RemoteConfiguration {
    private static final String PATH_SEPARATOR = "/";
    private final String host;
    private final int port;
    private final Security security;
    private final String userName;
    private final boolean anonymousLogin;
    private final String initialDirectory;
    private final int timeout;
    private final int keepAliveInterval;
    private final boolean passiveMode;
    private final boolean ignoreDisconnectErrors;
    private String password;

    public FtpConfiguration(ConfigManager.Configuration cfg) {
        super(cfg);
        this.host = cfg.getValue("host");
        this.port = this.readNumber("port", 21);
        this.security = new Security(this.readEnum(Encryption.class, "encryption", FtpConnectionProvider.DEFAULT_ENCRYPTION), this.readBoolean("onlyLoginEncrypted", false));
        this.userName = cfg.getValue("user");
        this.anonymousLogin = Boolean.valueOf(cfg.getValue("anonymousLogin"));
        this.initialDirectory = cfg.getValue("initialDirectory");
        this.timeout = this.readNumber("timeout", 30);
        this.keepAliveInterval = this.readNumber("keepAliveInterval", 30);
        this.passiveMode = Boolean.valueOf(cfg.getValue("passiveMode"));
        this.ignoreDisconnectErrors = Boolean.valueOf(cfg.getValue("ignoreDisconnectErrors"));
    }

    public boolean isAnonymousLogin() {
        return this.anonymousLogin;
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public String getInitialDirectory() {
        return this.initialDirectory;
    }

    public int getPort() {
        return this.port;
    }

    public Security getSecurity() {
        return this.security;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public boolean getIgnoreDisconnectErrors() {
        return this.ignoreDisconnectErrors;
    }

    public String getUserName() {
        if (this.anonymousLogin) {
            return "anonymous";
        }
        return this.userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPassword() {
        if (this.anonymousLogin) {
            return "nobody@nowhere.net";
        }
        FtpConfiguration ftpConfiguration = this;
        synchronized (ftpConfiguration) {
            if (this.password == null) {
                this.password = this.readPassword("password");
            }
            if (this.password == null) {
                this.password = "";
            }
            return this.password;
        }
    }

    @Override
    public String getUrl(String directory) {
        assert (directory != null);
        String path = this.initialDirectory;
        if (directory.trim().length() > 0) {
            path = path + directory;
        }
        return "ftp://" + this.host + path.replaceAll("/{2,}", PATH_SEPARATOR);
    }

    @Override
    public boolean saveProperty(String key, String value) {
        if ("password".equals(key)) {
            this.savePassword(ConfigManager.decode(value), FtpConnectionProvider.get().getDisplayName());
            return true;
        }
        return false;
    }

    @Override
    public void notifyDeleted() {
        this.deletePassword();
    }

    @Override
    public boolean equals(Object obj) {
        String otherPassword;
        if (!super.equals(obj)) {
            return false;
        }
        FtpConfiguration other = (FtpConfiguration)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.userName == null ? other.userName != null : !this.userName.equals(other.userName)) {
            return false;
        }
        String thisPassword = this.getPassword();
        return thisPassword.equals(otherPassword = other.getPassword());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + (this.host != null ? this.host.hashCode() : 0);
        hash = 97 * hash + this.port;
        hash = 97 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        hash = 97 * hash + this.getPassword().hashCode();
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [displayName: ");
        sb.append(this.getDisplayName());
        sb.append(", name: ");
        sb.append(this.getName());
        sb.append(", host: ");
        sb.append(this.host);
        sb.append(", port: ");
        sb.append(this.port);
        sb.append(", userName: ");
        sb.append(this.getUserName());
        sb.append(", password: *****");
        sb.append(", anonymousLogin: ");
        sb.append(this.anonymousLogin);
        sb.append(", initialDirectory: ");
        sb.append(this.initialDirectory);
        sb.append(", timeout: ");
        sb.append(this.timeout);
        sb.append(", passiveMode: ");
        sb.append(this.passiveMode);
        sb.append(", ignoreDisconnectErrors: ");
        sb.append(this.ignoreDisconnectErrors);
        sb.append("]");
        return sb.toString();
    }

    public static enum Encryption {
        NONE(Bundle.LBL_EncryptionNone()){

            @Override
            public boolean isPresent() {
                return false;
            }

            @Override
            public String getProtocol() {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean isImplicit() {
                throw new UnsupportedOperationException("Not supported.");
            }
        }
        ,
        TLS_EXPLICIT(Bundle.LBL_EncryptionTlsExplicit()){

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public String getProtocol() {
                return Encryption.TLS;
            }

            @Override
            public boolean isImplicit() {
                return false;
            }
        }
        ,
        TLS_IMPLICIT(Bundle.LBL_EncryptionTlsImplicit()){

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public String getProtocol() {
                return Encryption.TLS;
            }

            @Override
            public boolean isImplicit() {
                return true;
            }
        };

        private static final String TLS = "TLS";
        private final String label;

        private Encryption(String title) {
            this.label = title;
        }

        public abstract boolean isPresent();

        public abstract String getProtocol();

        public abstract boolean isImplicit();

        public String getLabel() {
            return this.label;
        }
    }

    public static final class Security {
        private final Encryption encryption;
        private final boolean onlyLoginEncrypted;

        public Security(Encryption encryption, boolean onlyLoginEncrypted) {
            this.encryption = encryption;
            this.onlyLoginEncrypted = onlyLoginEncrypted;
        }

        public boolean isPresent() {
            return this.encryption.isPresent();
        }

        public Encryption getEncryption() {
            return this.encryption;
        }

        public boolean isOnlyLoginEncrypted() {
            return this.onlyLoginEncrypted;
        }
    }
}

